
;   ************************************************************************
;   *		 IOS.INC - Windows for Workgroups 3.11 version		   *
;   ************************************************************************

;   This file presents symbolic information from the IOS.INC header that
;   Microsoft provides with the Windows 95 DDK, but adapted to match the
;   IOS implementation in Windows for Workgroups 3.11.

;   ========================================================================

;   The VxD ID for the Windows for Workgroups 3.11 IOS is the same as for
;   BLOCKDEV in Windows 3.10 and for IOS in Windows 95.

IOS_Device_ID		EQU	00010h

;   Perhaps surprisingly, the version numbers are the same for all three of
;   the Windows 3.10 BLOCKDEV, the Windows for Workgroups 3.11 IOS and the
;   Windows 95 IOS.

IOS_Major_Ver		EQU	03h
IOS_Minor_Ver		EQU	0Ah

Begin_Service_Table	IOS

;   Services compatible with BLOCKDEV

  IOS_Service		IOS_Get_Version, LOCAL
  IOS_Service		IOS_BD_Register_Device
  IOS_Service		IOS_Find_Int13_Drive
  IOS_Service		IOS_Get_Device_List
  IOS_Service		IOS_SendCommand
  IOS_Service		IOS_BD_Command_Complete
  IOS_Service		IOS_Synchronous_Command

;   Services introduced with the Windows for Workgroups 3.11 IOS and which
;   have the same service ordinals as their counterparts in the Windows 95
;   IOS

  IOS_Service		IOS_Register
  IOS_Service		IOS_Requestor_Service

;   Service introduced with the Windows for Workgroups 3.11 IOS and not
;   provided by the Windows 95 IOS.  Microsoft's name for this service is
;   not known.	The service fills a buffer with some of the fields of an ILB
;   and was presumably intended to allow higher-level VxDs to get access to
;   some IOS facilities, most notably the ISP functions, without having to
;   register as IOS drivers.

  IOS_Service		IOS_GetILB

;   Services that exist in both the Windows for Workgroups 3.11 IOS and the
;   Windows 95 IOS but with different service ordinals.

  IOS_Service		IOS_Exclusive_Access
  IOS_Service		IOS_Send_Next_Command
  IOS_Service		IOS_Set_Async_Time_Out
  IOS_Service		IOS_Signal_Semaphore_No_Switch
  IOS_Service		IOSIdleStatus

End_Service_Table	IOS

;   ************************************************************************

