
;   ************************************************************************
;   *	   control.asm - for VSD demonstration of hooking disk access	   *
;   ************************************************************************

;   This source file checks whether its target IOS is the one from Windows
;   for Workgroups 3.11 or Windows 95.	Assembly is conditional on the value
;   of the symbol TARGET, defaulting to WIN95.

IFNDEF TARGET
  TARGET		TEXTEQU <WIN95>
ENDIF

IFIDNI TARGET, <WFW311>
  ECHO Target platform is Windows for Workgroups 3.11
  TARGET_VERSION	=	0000030Bh
ELSE
  IFIDNI TARGET, <WIN95>
    ECHO Target platform is Windows 95
    TARGET_VERSION	=	00000400h
  ELSE
    .ERR <Unsupported target platform>
  ENDIF
ENDIF

;   ========================================================================

.386P

;   The DDK include files ignore differences in case.  Force the assembler
;   into case-insensitive mode even without the corresponding command line
;   switch.

			OPTION	CASEMAP:NOTPUBLIC

;   This VxD is compatible with Windows for Workgroups 3.11.  We do not want
;   macros defined in any included file (such as VMM.INC) to generate any
;   code that might call services introduced for Windows 95 when the VxD is
;   being run under Windows for Workgroups 3.11.  On the other hand, we do
;   want the right (even though we happen not to exercise it here) to use
;   features that are new to Windows 95 should our VxD be loaded under
;   Windows 95.  The following settings seem to be the best compromise that
;   Microsoft offers.

DDK_VERSION		EQU	0400h
WIN31COMPAT		EQU	1
WIN40SERVICES		EQU	1

;   Include files from the INC32 directory of the Windows 95 DDK

.NOLIST
  INCLUDE		vmm.inc
  INCLUDE		drp.inc
  INCLUDE		ilb.inc
  INCLUDE		ios.inc 	; in special version for 3.11
.LIST

;   The DDK include files disable the attractive feature of permitting
;   labels that are local to procedures.  Turn this feature on now.

			OPTION	SCOPED

;   ************************************************************************

VxD_ICODE_SEG
			EXTERN	GetIOSVersion:NEAR		; iosver.asm

OnSysDynamicDeviceInit	PROC	NEAR PRIVATE

;   This routine is called sometime after IOS has loaded the driver
;   dynamically (with the help of VXDLDR services) during Device_Init.

;   In Windows 95, this initialisation occurs after the initialisation of
;   the port drivers that actually work with the disk hardware.

;   If the initialisation is successful, the procedure is to return with a
;   clear carry flag.  If the driver sets the carry flag, IOS will arrange
;   for the driver to be removed from memory.

;   ----

;   Check that the IOS is present in the expected version.  This is far from
;   trivial, since the Windows for Workgroups 3.11 and Windows 95 versions
;   of the IOS both have the IOS_Get_Version service return 0000030Ah as the
;   version number!  Worse, the Windows 3.10 BlockDev (also included with
;   Windows for Workgroups 3.11) has the same VxD ID and it too gives its
;   version as 3.10.  We handle the identification through a routine in
;   another source file.

			call	GetIOSVersion
			jc	done

			cmp	eax,TARGET_VERSION
			jnz	fail

;   Register with the IOS.

			mov	esi,OFFSET DrvrRegPacket
			ASSUME	esi:PTR DRP

			VxDCall IOS_Register, <esi>

			cmp	[esi].DRP_reg_result,DRP_REMAIN_RESIDENT
			jnz	fail

ok:
			clc
			jmp	done

fail:
			stc
done:
			ret

			ASSUME	esi:NOTHING
OnSysDynamicDeviceInit	ENDP

VxD_ICODE_ENDS

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

VxD_IDATA_SEG

;   The Driver Registration Packet passed to IOS contains three pieces of
;   information that the IOS really needs and which are meaningful for the
;   remainder of the driver's life.  (Note that the DRP is needed only
;   while the driver initialises.)

;   First, the DRP_VSD_1 symbol represents a sort of initialisation
;   priority and a general position for the driver within the layered model.
;   The particular choice of DRP_VSD_1 puts the driver as far away from the
;   hardware as possible.

;   Second, the driver supplies a routine (AsyncEventRoutine) to handle the
;   interface through which IOS calls the driver for control purposes,
;   especially for initialisation.  It is through one of the functions in
;   this interface that we may discover that the IOS controls the particular
;   storage device that is the subject of our test.

;   Third, the driver provides a buffer that IOS will fill in with
;   information about itself, most especially the address of a service
;   point (through which the driver may call the IOS's ISP functions).

DrvrRegPacket		DRP	{ \
				EyeCatcher,
				DRP_VSD_1,
				OFFSET AsyncEventRoutine,
				OFFSET IOSLinkageBlock,
				}

VxD_IDATA_ENDS

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

VxD_LOCKED_CODE_SEG
			EXTERN	C AsyncEventRoutine:NEAR	; hook.asm
VxD_LOCKED_CODE_ENDS

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

VxD_LOCKED_DATA_SEG

;   The information that the driver gets about IOS may as well be held here
;   in this central module.

			PUBLIC	C IOSLinkageBlock
IOSLinkageBlock 	ILB	{}

VxD_LOCKED_DATA_ENDS

;   ************************************************************************
;   Some necessary VxD features - a DDB in the locked data segment and a
;   Control Procedure in locked code

Declare_Virtual_Device	DISKHOOK, 1, 0, Control_Proc, , , , , \
			<OFFSET DrvrRegPacket>

VxD_LOCKED_CODE_SEG

Control_Proc		PROC	NEAR PRIVATE

  Control_Dispatch	Sys_Dynamic_Device_Init, OnSysDynamicDeviceInit
			clc
			ret

Control_Proc		ENDP

VxD_LOCKED_CODE_ENDS

;   ************************************************************************

END

