
;   ************************************************************************
;   *			    hook.asm - for VSD demo			   *
;   ************************************************************************

;   This source file requires some adaptation in going from Windows for
;   Workgroups 3.11 to Windows 95.  The changes are noted in blocks whose
;   assembly is conditional on the value of the symbol TARGET, defaulting
;   to WIN95.

IFNDEF TARGET
  TARGET		TEXTEQU <WIN95>
ENDIF

IFIDNI TARGET, <WFW311>
  ECHO Target platform is Windows for Workgroups 3.11
ELSE
  IFIDNI TARGET, <WIN95>
    ECHO Target platform is Windows 95
  ELSE
    .ERR <Unsupported target platform>
  ENDIF
ENDIF

;   ========================================================================

.386P

;   The DDK include files ignore differences in case.  Force the assembler
;   into case-insensitive mode even without the corresponding command line
;   switch.

			OPTION	CASEMAP:NOTPUBLIC

;   This VxD is compatible with Windows for Workgroups 3.11.  We do not want
;   macros defined in any included file (such as VMM.INC) to generate any
;   code that might call services introduced for Windows 95 when the VxD is
;   being run under Windows for Workgroups 3.11.  On the other hand, we do
;   want the right (even though we happen not to exercise it here) to use
;   features that are new to Windows 95 should our VxD be loaded under
;   Windows 95.  The following settings seem to be the best compromise that
;   Microsoft offers.

DDK_VERSION		EQU	0400h
WIN31COMPAT		EQU	1
WIN40SERVICES		EQU	1

;   Include files from the INC32 directory of the Windows 95 DDK

.NOLIST
  INCLUDE		vmm.inc
  INCLUDE		aep.inc 	; in special version for 3.11
  INCLUDE		blockdev.inc
  INCLUDE		ilb.inc
  INCLUDE		isp.inc 	; in special version for 3.11
.LIST

;   Include files from the BLOCK\INC directory of the Windows 95 DDK

.NOLIST
  INCLUDE		dcb.inc 	; in special version for 3.11
.LIST

;   The DDK include files disable the attractive feature of permitting
;   labels that are local to procedures.  Turn this feature on now.

			OPTION	SCOPED

;   ************************************************************************

VxD_LOCKED_CODE_SEG
			EXTERN	C IOHook:NEAR			; play.asm

AsyncEventRoutine	PROC	NEAR C PUBLIC USES edi esi ebx,
				aep_ptr:DWORD

			mov	esi,[aep_ptr]
			ASSUME	esi:PTR AEPHDR

			cmp	[esi].AEP_func,AEP_CONFIG_DCB
			jnz	@f

			call	CheckDevice
			jmp	wrap_up

@@:

IFIDNI TARGET, <WIN95>

;   Windows 95 requires a "success" response to the AEP_BOOT_COMPLETE
;   function.  Otherwise, the driver will be removed!

			cmp	[esi].AEP_func,AEP_BOOT_COMPLETE
			jnz	@f

			call	CheckIfHooked
			jmp	wrap_up

@@:

ENDIF			; Windows 95

;   All AEP functions report their success or failure through a field in the
;   AEP header.

fail:
			mov	[esi].AEP_result,AEP_FAILURE
			jmp	done

wrap_up:
			jc	fail

ok:
			mov	[esi].AEP_result,AEP_SUCCESS

done:
			ret

			ASSUME	esi:NOTHING
AsyncEventRoutine	ENDP

VxD_LOCKED_CODE_ENDS

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

VxD_LOCKED_DATA_SEG

;   If assembling with the Windows 95 version of VMM.INC, then because of
;   some particular coding by Microsoft of a macro with the cCall macro, it
;   is vital that the following EXTERN declaration precede any use of the
;   symbol it defines.

			EXTERN	C IOSLinkageBlock:ILB
VxD_LOCKED_DATA_ENDS

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

;   In Windows for Workgroups 3.11, the AEP_CONFIG_DCB function can occur
;   only during the call to IOS_Register during a VSD's initialisation, all
;   port drivers having been initialised first.  The handling may therefore
;   be placed in a discardable segment.

;   This has to be changed for Windows 95, in which port drivers are
;   initialised after VSDs.

IFIDNI TARGET, <WFW311>
  VxD_ICODE_SEG
ELSE
  VxD_PAGEABLE_CODE_SEG
ENDIF

CheckDevice		PROC	NEAR PRIVATE
			ASSUME	esi:PTR AEP_dcb_config

			mov	edi,[esi].AEP_d_c_dcb
			ASSUME	edi:PTR DCB

;   We are interested only in physical devices that are accessible through
;   int 13h.

IFIDN TARGET, <WFW311>
			mov	eax,[edi].DCB_bdd.DCB_device_flags
ELSE
			mov	eax,[edi].DCB_cmn.DCB_device_flags
ENDIF
			test	eax,DCB_DEV_PHYSICAL
			jz	fail
			test	eax,DCB_DEV_LOGICAL OR DCB_DEV_RMM
			jnz	fail
			test	eax,DCB_DEV_INT13_DRIVE
			jz	fail

;   Moreover, we are only interested in the first physical hard disk.

			cmp	[edi].DCB_cmn.DCB_device_type,DCB_type_disk
			jnz	fail
			cmp	[edi].DCB_cmn.DCB_unit_number,80h
			jnz	fail

;   Given that the DCB being configured is for the device we are interested
;   in, hook all subsequent access.

			mov	ebx,OFFSET IOHook
			call	HookDeviceIO
IFIDNI TARGET, <WIN95>
			jc	fail

;   Record for later that a disk has been hooked.  The Windows 95 IOS will
;   eventually pass the driver an AEP_BOOT_COMPLETE function to see if the
;   driver has done something it considers sufficiently worthwhile to
;   justify a place in memory.

			inc	[nDisksHooked]
ENDIF
			jmp	done

fail:
			stc

done:
			ret

			ASSUME	edi:NOTHING
CheckDevice		ENDP

;   ------------------------------------------------------------------------

HookDeviceIO		PROC	NEAR PRIVATE
			LOCAL	cdi:ISP_calldown_insert

			ASSUME	esi:PTR AEPHDR, edi:PTR DCB

;   This function hooks the routine at address EBX into the calldown chain
;   for the device represented by the DCB at EDI.  Other information is
;   expected from the AEP data at ESI.

;   ----

;   Hooking access to the device is a simple matter of calling the IOS's
;   ISP_INSERT_CALLDOWN function.  The main points are that we tell the IOS
;   which device we're interested in (represented by the DCB) and which
;   procedure is to be called when operations are requested on that device.

			mov	[cdi].ISP_i_cd_hdr.ISP_func,ISP_INSERT_CALLDOWN

			mov	[cdi].ISP_i_cd_dcb,edi

			mov	[cdi].ISP_i_cd_req,ebx

			mov	eax,[esi].AEP_ddb
			mov	[cdi].ISP_i_cd_ddb,eax

			mov	[cdi].ISP_i_cd_expan_len,0000h

			mov	eax,[edi].DCB_cmn.DCB_dmd_flags
			mov	[cdi].ISP_i_cd_flags,eax

			mov	al,[esi].AEP_lgn
			mov	[cdi].ISP_i_cd_lgn,al

			lea	eax,[cdi]
			cCall	IOSLinkageBlock.ILB_service_rtn, <eax>

;   ISP functions show their success by returning zero in the ISP_result
;   field.  Anything else is a failure.

			xor	ax,ax
			cmp	ax,[cdi].ISP_i_cd_hdr.ISP_result
			ret

HookDeviceIO		ENDP

IFIDNI TARGET, <WFW311>
  VxD_ICODE_ENDS
ELSE
  VxD_PAGEABLE_CODE_ENDS
ENDIF

;   ========================================================================

IFIDNI TARGET, <WIN95>

VxD_PAGEABLE_CODE_SEG

CheckIfHooked		PROC	NEAR PRIVATE

;   In this provision for the Windows 95 AEP_BOOT_COMPLETE function, check
;   that the driver has hooked access to at least one disk.  If not, fail
;   the function.

			cmp	[nDisksHooked],01h
			ret

CheckIfHooked		ENDP

VxD_PAGEABLE_CODE_ENDS

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

VxD_PAGEABLE_DATA_SEG

nDisksHooked		db	00h

VxD_PAGEABLE_DATA_ENDS

ENDIF			; Windows 95

;   ************************************************************************

END

