
;   ************************************************************************
;   *				   iomgr.asm				   *
;   ************************************************************************

.386P

;   The DDK include files ignore differences in case.  Force the assembler
;   into case-insensitive mode even without the corresponding command line
;   switch.

			OPTION	CASEMAP:NOTPUBLIC

;   Although the VMM.INC supplied with the Windows 95 DDK provides for
;   using MASM 6.x STRUCT semantics if the symbol NEWSTRUCTS is defined,
;   some include files used for block devices do not respect the symbol but
;   assume MASM 5.x STRUCT semantics.  IOR.INC is the particular culprit for
;   this source file.  We have no choice but to reference structure members
;   the old way.  Complain if an attempt is made to assemble with MASM 6.x
;   STRUCT semantics.

IFDEF NEWSTRUCTS
.ERR	MASM 6.x STRUCT semantics not supported
ENDIF

;   This VxD is compatible with Windows for Workgroups 3.11.  We do not want
;   macros defined in any included file (such as VMM.INC) to generate any
;   code that might call services introduced for Windows 95 when the VxD is
;   being run under Windows for Workgroups 3.11.  On the other hand, we do
;   want the right (even though we happen not to exercise it here) to use
;   features that are new to Windows 95 should our VxD be loaded under
;   Windows 95.  The following settings seem to be the best compromise that
;   Microsoft offers.

DDK_VERSION		EQU	0400h
WIN31COMPAT		EQU	1
WIN40SERVICES		EQU	1

;   Include files from the INC32 directory of the Windows 95 DDK

.NOLIST
  INCLUDE		vmm.inc
  INCLUDE		blockdev.inc
  INCLUDE		ior.inc
.LIST

;   Include files from the BLOCK\INC directory of the Windows 95 DDK

.NOLIST
  INCLUDE		dcb.inc 	; in special version for 3.11
  INCLUDE		iop.inc 	; in special version for 3.11
.LIST

;   The DDK include files disable the attractive feature of permitting
;   labels that are local to procedures.  Turn this feature on now.

			OPTION	SCOPED

;   ************************************************************************

VxD_LOCKED_CODE_SEG

ForwardIORequest	PROC	NEAR PUBLIC
			ASSUME	ebx:PTR IOP

;   This procedure passes the I/O request described by the IOP at EBX to the
;   next (lower-level) driver that has registered a desire to see I/O
;   requests for the same storage device.

;   If there is no such driver, the procedure returns with a set carry flag
;   (not that this should ever happen).

;   The procedure makes no attempt to preserve registers eax, ecx and edx
;   which the next driver is allowed to use.

;   ----

;   To pass the I/O request to the next driver in the device's chain, first
;   get the current calldown pointer.

			mov	ecx,[ebx].IOP_calldown_ptr
			ASSUME	ecx:PTR DCB_cd_entry

;   The current calldown pointer is the address of a DCB_calldown_entry
;   structure that describes the driver currently in charge of the request -
;   in other words, this driver!  When the next driver sees the I/O request,
;   it will expect the same property to hold.  So, before calling that
;   driver's I/O hook, be sure to change the IOP's calldown pointer to
;   address the DCB_calldown_entry for that driver.

			mov	ecx,[ecx].DCB_cd_next
			jecxz	fail

			mov	[ebx].IOP_calldown_ptr,ecx

			cCall	[ecx].DCB_cd_io_address, <ebx>

ok:
			clc
			jmp	done
fail:
			stc
done:
			ret

			ASSUME	ecx:NOTHING
ForwardIORequest	ENDP

;   ========================================================================

CallWhenIOComplete	PROC	NEAR PUBLIC USES ecx eax
			ASSUME	ebx:PTR IOP

;   This procedure registers the routine addressed by ESI as one that the
;   I/O system should call (back) when the I/O operation described by the
;   IOP at EBX completes.  The contents of register EDX are stored to serve
;   as reference data for the callback routine.

;   The procedure indicates success or failure via the carry flag.  All
;   registers are preserved.

;   The callback routine will be entered as a C function with the address of
;   the IOP as its one stacked argument.  The callback routine may retrieve
;   the reference data by calling GetReferenceData (see below).

;   ----

;   To arrange a callback, insert an IOP_callback_entry structure in the
;   IOP's callback table.
  
			mov	ecx,[ebx].IOP_callback_ptr
			ASSUME	ecx:PTR IOP_callback_entry

;   It seems prudent to check first that the callback table actually has
;   room.  (Perhaps surprisingly, MASM 6.0 will not accept the following
;   address calculation if put as just an LEA instruction.)

			lea	eax,[ebx].IOP_callback_table \
					+ SIZE IOP.IOP_callback_table
			sub	eax,SIZE IOP_callback_entry

			cmp	eax,ecx
			jb	done

;   Store the callback routine's address and the reference data, then
;   advance the pointer in the IOP's callback "stack".

			mov	[ecx].IOP_CB_address,esi
			mov	[ecx].IOP_CB_ref_data,edx

			add	[ebx].IOP_callback_ptr,SIZE IOP_callback_entry

done:
			ret

			ASSUME	ecx:NOTHING
CallWhenIOComplete	ENDP

;   ========================================================================

GetReferenceData	PROC	NEAR PUBLIC
			ASSUME	ebx:PTR IOP

			mov	edx,[ebx].IOP_callback_ptr
			ASSUME	edx:PTR IOP_callback_entry
			mov	edx,[edx].IOP_CB_ref_data
			ASSUME	edx:NOTHING
			ret

GetReferenceData	ENDP

;   ========================================================================

ForwardIOCompletion	PROC	NEAR PUBLIC
			ASSUME	ebx:PTR IOP

;   This procedure passes the I/O request described by the IOP at EBX back
;   to the next higher-level driver that has expressed interest in being
;   notified of the request's completion.

;   The procedure makes no attempt to preserve registers eax, ecx and edx
;   which the next driver is allowed to use.

;   ----

;   Pop an entry from the IOP's callback stack.

			mov	eax,[ebx].IOP_callback_ptr
			ASSUME	eax:PTR IOP_callback_entry
			sub	eax,SIZE IOP_callback_entry
			mov	[ebx].IOP_callback_ptr,eax

;   Call the callback procedure that was just popped off the callback stack.

			cCall	[eax].IOP_CB_address, <ebx>

			clc
			ret

			ASSUME	eax:NOTHING
ForwardIOCompletion	ENDP

VxD_LOCKED_CODE_ENDS

;   ************************************************************************

END

