
;   ************************************************************************
;   *	     iosver.asm - to distinguish BlockDev and IOS versions	   *
;   ************************************************************************

.386P

;   The DDK include files ignore differences in case.  Force the assembler
;   into case-insensitive mode even without the corresponding command line
;   switch.

			OPTION	CASEMAP:NOTPUBLIC

;   This VxD is compatible with Windows for Workgroups 3.11.  We do not want
;   macros defined in any included file (such as VMM.INC) to generate any
;   code that might call services introduced for Windows 95 when the VxD is
;   being run under Windows for Workgroups 3.11.  On the other hand, we do
;   want the right (even though we happen not to exercise it here) to use
;   features that are new to Windows 95 should our VxD be loaded under
;   Windows 95.  The following settings seem to be the best compromise that
;   Microsoft offers.

DDK_VERSION		EQU	0400h
WIN31COMPAT		EQU	1
WIN40SERVICES		EQU	1

;   Include files from the INC32 directory of the Windows 95 DDK

.NOLIST
  INCLUDE		vmm.inc
  INCLUDE		ios.inc 	; in special version for 3.11
.LIST

;   The DDK include files disable the attractive feature of permitting
;   labels that are local to procedures.  Turn this feature on now.

			OPTION	SCOPED

;   ************************************************************************

VxD_INIT_CODE_SEG

GetIOSVersion		PROC	NEAR PUBLIC

;   The problem with distinguishing different versions of BlockDev and IOS
;   is that the three implementations shipped with Windows 3.10, Windows for
;   Workgroups 3.11 and Windows 95 all have IOS_Get_Version return 3.10 as
;   their version number.

;   Presumably, Microsoft will have future IOS versions return something
;   higher than 0000030Ah from IOS_Get_Version.  (A lower version is taken
;   to indicate something like the Windows 3.0 VHD and we return a set carry
;   flag.)

			VxDCall IOS_Get_Version
			cmp	eax,0000030Ah
			jnz	done

;   In the degenerate case, try to separate the implementations by checking
;   the existence of particular services.

;   The IOS_Register service, which is number 0007h, was introduced for the
;   IOS in Windows for Workgroups 3.11.  If it is not present, assume that
;   we are working with the Windows 3.10 BlockDev.

			xor	esi,esi
			GetVxDServiceOrdinal eax,IOS_Register
			VMMCall Hook_Device_Service
			jc	blockdev
			VMMCall Hook_Device_Service
			jc	done

;   The Windows for Workgroups 3.11 IOS offers services only as far as
;   IOSIdleStatus, which is number 000Eh in that version.  If there is no
;   service 000Fh, assume that we are working with the IOS from Windows for
;   Workgroups 3.11.

			xor	esi,esi
			mov	eax,(IOS_DEVICE_ID SHL 10h) OR 000Fh
			VMMCall Hook_Device_Service
			jc	ios311
			VMMCall Hook_Device_Service
			jc	done

ios95:
			mov	eax,00000400h
			jmp	ok

ios311:
			mov	eax,0000030Bh
			jmp	ok

blockdev:
			mov	eax,0000030Ah

ok:
			clc

done:
			ret

GetIOSVersion		ENDP

VxD_INIT_CODE_ENDS

;   ************************************************************************

END

