
;   ************************************************************************
;   *				    play.asm				   *
;   ************************************************************************

.386P

;   The DDK include files ignore differences in case.  Force the assembler
;   into case-insensitive mode even without the corresponding command line
;   switch.

			OPTION	CASEMAP:NOTPUBLIC

;   Although the VMM.INC supplied with the Windows 95 DDK provides for
;   using MASM 6.x STRUCT semantics if the symbol NEWSTRUCTS is defined,
;   some include files used for block devices do not respect the symbol but
;   assume MASM 5.x STRUCT semantics.  IOR.INC is the particular culprit for
;   this source file.  We have no choice but to reference structure members
;   the old way.  Complain if an attempt is made to assemble with MASM 6.x
;   STRUCT semantics.

IFDEF NEWSTRUCTS
.ERR	MASM 6.x STRUCT semantics not supported
ENDIF

;   This VxD is compatible with Windows for Workgroups 3.11.  We do not want
;   macros defined in any included file (such as VMM.INC) to generate any
;   code that might call services introduced for Windows 95 when the VxD is
;   being run under Windows for Workgroups 3.11.  On the other hand, we do
;   want the right (even though we happen not to exercise it here) to use
;   features that are new to Windows 95 should our VxD be loaded under
;   Windows 95.  The following settings seem to be the best compromise that
;   Microsoft offers.

DDK_VERSION		EQU	0400h
WIN31COMPAT		EQU	1
WIN40SERVICES		EQU	1

;   Include files from the INC32 directory of the Windows 95 DDK

.NOLIST
  INCLUDE		vmm.inc
  INCLUDE		blockdev.inc
  INCLUDE		ior.inc
.LIST

;   Include files from the BLOCK\INC directory of the Windows 95 DDK

.NOLIST
  INCLUDE		dcb.inc 	; in special version for 3.11
  INCLUDE		iop.inc 	; in special version for 3.11
.LIST

;   The DDK include files disable the attractive feature of permitting
;   labels that are local to procedures.  Turn this feature on now.

			OPTION	SCOPED

;   ************************************************************************

VxD_LOCKED_CODE_SEG

			EXTERN	CallWhenIOComplete:NEAR 	; iomgr.asm
			EXTERN	ForwardIOCompletion:NEAR	; iomgr.asm
			EXTERN	ForwardIORequest:NEAR		; iomgr.asm
			EXTERN	GetReferenceData:NEAR		; iomgr.asm

IOHook			PROC	NEAR C PUBLIC USES edi esi ebx, iop_ptr:DWORD

			mov	ebx,[iop_ptr]
			ASSUME	ebx:PTR IOP

			mov	edi,[ebx].IOP_physical_dcb
			ASSUME	edi:PTR DCB

;   The intention is to make a harmless change to the appearance of one
;   specific sector on the hooked drive.  We also refuse write access to
;   that sector.  No other IOR functions are of interest in this toy.

			cmp	[ebx].IOP_ior.IOR_func,IOR_READ
			jz	@f
			cmp	[ebx].IOP_ior.IOR_func,IOR_WRITE
			jz	@f
			cmp	[ebx].IOP_ior.IOR_func,IOR_WRITEV
			jnz	pass

@@:

;   The IOR provides the starting sector and sector count for the read/write
;   operation.

			mov	edx,[ebx].IOP_ior.IOR_start_addr
			mov	ecx,[ebx].IOP_ior.IOR_xfer_count

;   The specific sector of interest is the one in which most machines have a
;   DOS boot sector - the first sector on the disk's second track.

			mov	eax,[edi].DCB_actual_spt

;   If the range for the read/write does not overlap the test sector, just
;   let the operation go through.

			sub	eax,edx
			jb	pass
			cmp	eax,ecx
			jnb	pass

;   Given an overlap, simulate an error if the IOR indicates an attempt to
;   write over the sector.

			cmp	[ebx].IOP_ior.IOR_func,IOR_READ
			jz	read

write:
			mov	ax,IORS_ILLEGAL_ACCESS_MODE
			jmp	simulate_error

read:

;   Given an attempt to read a range of sectors including the test sector,
;   let the operation go through, but only after arranging to be called back
;   when the operation has completed.

;   Since we have handy the offset in sectors from the start of the range to
;   the test sector, we may as well save it as reference data so that it
;   will still be handy when the callback routine executes (whenever that
;   may be).

			mov	esi,OFFSET ReadDone
			mov	edx,eax
			call	CallWhenIOComplete
			jnc	pass

			mov	ax,IORS_DEVICE_ERROR	; should never happen
			jmp	simulate_error

pass:
			call	ForwardIORequest
			jnc	done

			mov	ax,IORS_DEVICE_ERROR	; should never happen

simulate_error:

;   To simulate an error, load the IOR's status field with an error code and
;   then spread the "news" that the requested I/O operation has completed
;   (albeit unsuccessfully).

			mov	[ebx].IOP_ior.IOR_status,ax
			call	ForwardIOCompletion

done:
			ret

IOHook			ENDP

;   ------------------------------------------------------------------------

ReadDone		PROC	NEAR C PRIVATE USES edi esi ebx, iop_ptr:DWORD

			mov	ebx,[iop_ptr]
			ASSUME	ebx:PTR IOP

			cmp	[ebx].IOP_ior.IOR_status,IORS_ERROR_DESIGNTR
			jnb	done

;   Retrieve the sector offset from the first sector read to the test
;   sector.

			call	GetReferenceData
			mov	eax,edx

;   Find the space in the I/O request's buffer where the caller will expect
;   to see the contents of the test sector.

;   In the usual case, this calculation is the obvious:  multiply the sector
;   index by the sector size in bytes and add to the starting address of the
;   buffer.

;   There is a complication, however.  In the scatter-gather case, the
;   caller supplies not just one buffer, but many, leaving it to the system
;   (IOS, an IOS driver or perhaps even the hardware) to distribute the
;   sectors into the many buffers.  The IOR field that would usually
;   provide the buffer address gives instead the address of an array of
;   BlockDev_Scatter_Gather descriptors.

                        mov     esi,[ebx].IOP_ior.IOR_buffer_ptr

			test	[ebx].IOP_ior.IOR_flags,IORF_SCATTER_GATHER
			jz	calculate

			ASSUME	esi:PTR BlockDev_Scatter_Gather

;   Each descriptor corresponds to a buffer - in the same order as sectors
;   have been read from disk.  Just follow the array to find which buffer
;   contains the sector of interest.

@@:
			cmp	eax,[esi].BD_SG_Count
			jb	@f

			sub	eax,[esi].BD_SG_Count
			add	esi,SIZE BlockDev_Scatter_Gather
			jmp	@b

@@:
			mov	esi,[esi].BD_SG_Buffer_Ptr
			ASSUME	esi:NOTHING

calculate:
			mov	edi,[ebx].IOP_physical_dcb
			ASSUME	edi:PTR DCB
			mul	[edi].DCB_actual_blk_size
			add	esi,eax

;   Now that we have the data that was read from the test sector, modify it
;   so that our test programs can confirm that we have hooked access to the
;   disk.

			call	PlayWithImage

done:

;   Keep passing on the news of the I/O operation's completion.  Eventually,
;   this will get all the way to whichever VxD requested the I/O.

			call	ForwardIOCompletion
			ret

			ASSUME	ebx:NOTHING, edi:NOTHING
ReadDone		ENDP

;   ------------------------------------------------------------------------

PlayWithImage		PROC	NEAR PRIVATE

;   Check first that ESI points to a sector with the expected appearance (a
;   DOS boot sector).

			cmp	word ptr [esi + 01FEh],0AA55h
			jnz	fail

			mov	eax,[esi]

			cmp	al,0E9h
			jz	@f
			cmp	al,0EBh
			jnz	fail
			shr	eax,10h
			cmp	al,90h
			jnz	fail

@@:

;   Search for the word "disk" and toggle the case of its last two letters.

;   I am grateful to Ralph Shnelvar for pointing out to me that my first
;   coding of the for loop - with ecx = 0200h on entry - could access memory
;   beyond the end of the buffer (which we are already presuming holds at
;   least the data from a 0200h-byte sector).

			mov	ecx,01FDh
next:
			mov	eax,[esi]
			and	eax,NOT 20202020h
			cmp	eax,"KSID"
			jz	play

			inc	esi
			loop	next

			jmp	fail

play:
			xor	dword ptr [esi],20200000h
			jmp	done

fail:
			stc
done:
			ret

PlayWithImage		ENDP

VxD_LOCKED_CODE_ENDS

;   ************************************************************************

END

