
/*  ************************************************************************  *
 *			fwmemmap.cpp - for fwmemmap.exe 		      *
 *  ************************************************************************  */

#include    <windows.h>

#include    <stdio.h>
#include    <stdlib.h>

#include    "stddefs.h"

#include    "driver.h"
#include    "firmware.h"
#include    "fwmemmap.h"            // shared with kernel-mode driver

/*  ************************************************************************  */
/*  Constants  */

const CHAR Description [] =
"\nRetrieves a map of physical memory from the BIOS (int 15h function E820h)";

const CHAR FwMemMapServiceName [] = FWMEMMAP_DEVICE_NAME;
const CHAR FwMemMapDeviceName [] = "\\\\.\\" FWMEMMAP_DEVICE_NAME;

/*  ************************************************************************  */
/*  Forward references	*/

PSTR MakeDriverPathname (PCSTR, PCSTR);
VOID PutError (PCSTR, ...);

/*  ************************************************************************  */

int __cdecl main (int argc, char **argv)
{
    PSTR progname = argc > 0 ? argv [0] : NULL;

    while (++ argv, -- argc != 0) {
	PSTR p = *argv;
	CHAR ch = *p ++;

	if (ch == '-' OR ch == '/') {
	    ch = *p ++;

	    if (ch == '?') {
		printf (Description);
		return 0;
	    }

	    PutError ("Invalid switch %s", *argv);
	    return -1;
	}
	else {
	    PutError ("Invalid parameter %s", *argv);
	    return -1;
	}
    }

    /*	Load the driver. It's to be in the same directory as this program.
	Additionally, the Service Manager requires a fully qualified
	pathname. Handle the details separately.  */

    PSTR driver = MakeDriverPathname (progname, FWMEMMAP_DRIVER_NAME);
    if (driver == NULL) {
	PutError ("Cannot locate driver from program %s", progname);
	return -1;
    }

    DWORD ec = LoadDriver (FwMemMapServiceName, driver);
    if (ec != ERROR_SUCCESS) {
	PutError ("Error 0x%08X loading driver %s", ec, driver);
    }
    delete driver;
    if (ec != ERROR_SUCCESS) return ec;

    /*	Open the driver's device, talk to it, and then unload the driver.  */

    HANDLE device;
    ec = OpenDevice (FwMemMapDeviceName, &device);
    if (ec != ERROR_SUCCESS) {
	PutError ("Error 0x%08X opening device %s", ec, FwMemMapDeviceName);
    }
    else {
	PE820_MAP map;
	ec = GetMap (device, &map);
	if (ec != ERROR_SUCCESS) {
	    PutError ("Error 0x%08X getting memory map", ec);
	}
	else {
	    ShowMap (map);
	    ReleaseMap (map);
	}

	CloseDevice (device);
    }
    UnloadDriver (FwMemMapServiceName);
    return ec;
}

PSTR MakeDriverPathname (PCSTR ProgramName, PCSTR DriverName)
{
    /*	The Service Manager will want a fully-qualified name.  */

    PSTR progname = _fullpath (NULL, ProgramName, 0);
    if (progname == NULL) return NULL;

    /*	We want to substitute the driver's name for the executable's. Find
	where to make the change.  */

    PSTR p;
    for (p = progname + strlen (progname);
	    p > progname AND *p != '\\' AND *p != ':';
	    p --) {
    }
    if (p != progname) p ++;

    /*	Copy the pieces to a new buffer.  */

    ULONG cchpath = (ULONG) (p - progname);
    ULONG cchfilename = strlen (DriverName) + 1;
    PCHAR pathname = new CHAR [cchpath + cchfilename];
    if (pathname != NULL) {
	memcpy (pathname, progname, cchpath * sizeof (CHAR));
	memcpy (pathname + cchpath, DriverName, cchfilename * sizeof (CHAR));
    }

    free (progname);

    return pathname;
}

/*  ************************************************************************  */

VOID PutError (PCSTR Str, ...)
{
    va_list argptr;
    va_start (argptr, Str);
    printf ("\nFWMEMMAP: ");
    vprintf (Str, argptr);
    printf ("\n");
    va_end (argptr);
}

/*  ************************************************************************  */

