
#   ************************************************************************
#   *		   PROJECT.MK makefile inclusion for FWMEMMAP		   *
#   ************************************************************************

#   This file is included by Microsoft's MAKEFILE.PLT in the DDK, as an
#   under-documented provision for picking up project-wide configurations.

#   MAKEFILE.PLT will have set _PROJECT_MK_PATH to the directory that
#   contains this inclusion. Use it to define a path at which to collect
#   the binaries.

PATH_BIN = $(_PROJECT_MK_PATH)\bin

#   ************************************************************************
#   Driver Signing

#   To get executables signed just by running BUILD, first define SIGNCODE
#   as an environment variable.

!if "$(SIGNCODE)"!="" || "$(SIGNCODE_CERTIFICATE_NAME)"!=""

!if "$(SIGNCODE_CERTIFICATE_NAME)"==""
SIGNCODE_CERTIFICATE_NAME = My Own Testing Authority
!endif
!if "$(SIGNCODE_CERTIFICATE_STORE)"==""
SIGNCODE_CERTIFICATE_STORE = my
!endif

SIGNCODE_FLAGS = /v
!if "$(SIGNCODE_CERTIFICATE_STORE)"!=""
SIGNCODE_FLAGS = $(SIGNCODE_FLAGS) /s "$(SIGNCODE_CERTIFICATE_STORE)"
!endif
!if "$(SIGNCODE_CERTIFICATE_NAME)"!=""
SIGNCODE_FLAGS = $(SIGNCODE_FLAGS) /n "$(SIGNCODE_CERTIFICATE_NAME)"
!endif
!if "$(SIGNCODE_CROSS_CERTIFICATE)"!=""
SIGNCODE_FLAGS = $(SIGNCODE_FLAGS) /ac "$(SIGNCODE_CROSS_CERTIFICATE)"
!endif
!if "$(SIGNCODE_TIME_STAMPER)"!=""
SIGNCODE_FLAGS = $(SIGNCODE_FLAGS) /t "$(SIGNCODE_TIME_STAMPER)"
!endif

SIGNCODE_CMD = signtool sign $(SIGNCODE_FLAGS) $@

!endif	# !if "$(SIGNCODE)"!="" || "$(SIGNCODE_CERTIFICATE_NAME)"!=""

#   ************************************************************************
#   Collection of Built Binaries (BINPLACE)

#   Beware. Use of the BINPLACE tool with the WDK's default makefiles is
#   explicitly documented as unsupported.

#   To get binaries collected in the BIN directory, run
#
#	set NO_BINPLACE=
#
#   before starting the build.

!if $(FREEBUILD)
SUBDIR_BUILD_TYPE = free
!else
SUBDIR_BUILD_TYPE = checked
!endif

#   For the root destination directory

_NT386TREE = $(PATH_BIN)\i386\$(SUBDIR_BUILD_TYPE)
_NTAMD64TREE = $(PATH_BIN)\amd64\$(SUBDIR_BUILD_TYPE)
_NTIA64TREE = $(PATH_BIN)\ia64\$(SUBDIR_BUILD_TYPE)

#   The placefile

BINPLACE_PLACEFILE = $(_PROJECT_MK_PATH)\placefil.txt

#   Collect symbol files into file-type subdirectories of wherever the
#   binaries go to.

BINPLACE_FLAGS = /s . /y

#   ************************************************************************

