
/*  ************************************************************************  *
 *				   driver.cpp				      *
 *  ************************************************************************  */

#include    <windows.h>

#include    "stddefs.h"

#include    "driver.h"

/*  ************************************************************************  */

DWORD LoadDriver (PCSTR Service, PCSTR Driver)
{
    DWORD ec;

    SC_HANDLE scm = OpenSCManager (NULL, NULL, SC_MANAGER_ALL_ACCESS);
    if (scm == NULL) {
	ec = GetLastError ();
    }
    else {
	SC_HANDLE service = CreateService (scm, Service, Service,
				SERVICE_ALL_ACCESS, SERVICE_KERNEL_DRIVER,
				SERVICE_DEMAND_START, SERVICE_ERROR_NORMAL,
				Driver, NULL, NULL, NULL, NULL, NULL);
	if (service == NULL) {
	    ec = GetLastError ();
	}
	else {
	    BOOL result = StartService (service, 0, NULL);
	    ec = result ? ERROR_SUCCESS : GetLastError ();

	    if (ec != ERROR_SUCCESS) DeleteService (service);
	    CloseServiceHandle (service);
	}
	CloseServiceHandle (scm);
    }
    return ec;
}

DWORD UnloadDriver (PCSTR Service)
{
    DWORD ec;
    BOOL result;

    SC_HANDLE scm = OpenSCManager (NULL, NULL, SC_MANAGER_ALL_ACCESS);
    if (scm == NULL) {
	ec = GetLastError ();
    }
    else {
	SC_HANDLE service = OpenService (scm, Service, SERVICE_ALL_ACCESS);
	if (service == NULL) {
	    ec = GetLastError ();
	}
	else {
	    SERVICE_STATUS status;
	    result = ControlService (service, SERVICE_CONTROL_STOP, &status);
	    ec = result ? ERROR_SUCCESS : GetLastError ();

	    DeleteService (service);
	    CloseServiceHandle (service);
	}
	CloseServiceHandle (scm);
    }
    return ec;
}

/*  ************************************************************************  */

DWORD OpenDevice (PCSTR Device, HANDLE *Handle)
{
    HANDLE device = CreateFile (Device, 0, 0, NULL, OPEN_EXISTING, 0, NULL);
    if (device == INVALID_HANDLE_VALUE) return GetLastError ();

    *Handle = device;
    return ERROR_SUCCESS;
}

VOID CloseDevice (HANDLE Handle)
{
    CloseHandle (Handle);
}

/*  ************************************************************************  */

