
/*  ************************************************************************  *
 *				  firmware.cpp				      *
 *  ************************************************************************  */

#include    <windows.h>
#include    <winioctl.h>

#include    <stdio.h>

#include    "stddefs.h"

#include    "firmware.h"
#include    "fwmemmap.h"            // shared with kernel-mode driver

#define     ONE_MB	(1 << 20)
#define     FOUR_GB	((ULONGLONG) 1 << 32)

/*  ************************************************************************  */

DWORD GetMap (HANDLE Device, PE820_MAP *Map)
{
    PE820_MAP map;
    DWORD ec = ERROR_SUCCESS;
    for (DWORD cb = 0x0100; ec == ERROR_SUCCESS; delete map) {

	map = (PE820_MAP) new CHAR [cb];
	if (map == NULL) {
	    ec = ERROR_NOT_ENOUGH_MEMORY;
	    break;
	}

	DWORD cbret;
	BOOL result = DeviceIoControl (Device, IOCTL_FWMEMMAP_GET_MAP,
					NULL, 0, map, cb, &cbret, NULL);
	if (result) {
	    *Map = map;
	    return ERROR_SUCCESS;
	}

	ec = GetLastError ();
	if (ec == ERROR_MORE_DATA AND cbret >= sizeof (map -> Count)) {

	    cb = FIELD_OFFSET (E820_MAP, Descriptors)
		    + map -> Count * sizeof (E820_DESCRIPTOR);
	    ec = ERROR_SUCCESS;
	}
    }
    return ec;
}

VOID ShowMap (PE820_MAP Map)
{
    ULONGLONG total = 0;
    ULONGLONG above4GB = 0;

    printf ("\nMap of firmware memory ranges (from int 15h function E820h)"
	    "\n"
	    "\n       Address               Size              Type"
	    "\n=================== =================== ================="
	    "\n");

    for (DWORD n = 0; n < Map -> Count; n ++) {

	PCSTR type;
	switch (Map -> Descriptors [n].Type) {
	    case 1: {
		type = "memory";
		break;
	    }
	    case 2: {
		type = "reserved";
		break;
	    }
	    case 3: {
		type = "ACPI Reclaim";
		break;
	    }
	    case 4: {
		type = "ACPI NVS";
		break;
	    }
	    default: {
		type = "undefined";
		break;
	    }
	}

	printf ("0x%08X`%08X 0x%08X`%08X  %d (%s)\n",
		Map -> Descriptors [n].Base.HighPart,
		Map -> Descriptors [n].Base.LowPart,
		Map -> Descriptors [n].Size.HighPart,
		Map -> Descriptors [n].Size.LowPart,
		Map -> Descriptors [n].Type,
		type);

	if (Map -> Descriptors [n].Type == 1) {
	    ULONGLONG start = Map -> Descriptors [n].Base.QuadPart;
	    ULONGLONG size = Map -> Descriptors [n].Size.QuadPart;
	    ULONGLONG end = start + size;
	    if (end > FOUR_GB) {
		above4GB += (end - max (start, FOUR_GB));
	    }
	    total += size;
	}
    }

    printf ("\nSummary (in MB, ignoring partial MB):\n");

    printf ("\nTotal memory:     % 14I64u\n", total / ONE_MB);
    printf ("Memory above 4GB: % 14I64u\n", above4GB / ONE_MB);
}

VOID ReleaseMap (PE820_MAP Map)
{
    delete (PCHAR) Map;
}

/*  ************************************************************************  */

