
/*  ************************************************************************  *
 *                                  idc.cpp                                   *
 *  ************************************************************************  */

#include    "stdinc.h"

#include    <objbase.h>         // for CoTaskMemAlloc

#include    "idc.h"
#include    "puterror.h"

/*  ************************************************************************  */

/*  The Control Panel's PIDLs for Control Panel items are meant to be opaque
    to the Control Panel. The names IDCONTROL and IDCONTROLW are known from
    C++ decorations that appear in symbol files. However, no symbol file
    that has yet been available publicly has type information for the
    structures.  */

struct IDCONTROL : public SHITEMID
{
    LONG Icon;                                              // offset 0x04
    USHORT Name;                                            // offset 0x08
    USHORT Info;                                            // offset 0x0A
    CHAR Module [ANYSIZE_ARRAY];                            // offset 0x0C

    /*  Null-terminated ANSI strings for the item's display name and
        description follow, apparently with no requirement for order or
        packing. The Name and Info members are offsets from Module, in
        characters.  */
};

struct IDCONTROLW : public IDCONTROL
{
    /*  The IDCONTROL members have requirements. The Name and Info offsets
        must both be zero. The first character of Module must be zero. The
        second must be 'j'. Note the reliance on at least 2-byte packing for
        the IDCONTROL.  */

    ULONG Flags;                                            // offset 0x10
    USHORT NameW;                                           // offset 0x14
    USHORT InfoW;                                           // offset 0x16
    WCHAR ModuleW [ANYSIZE_ARRAY];                          // offset 0x18

    /*  Null-terminated Unicode strings for the item's display name and
        description follow, apparently with no requirement for order or
        packing. The NameW and InfoW members are offsets from ModuleW, in
        characters.  */
};

/*  ************************************************************************  */
/*  Forward references  */

PITEMID_CHILD ILCreateChild (SIZE_T);

/*  ************************************************************************  */

HRESULT
CreateIDControl (
    PCSTR Module,
    INT Icon,
    PCSTR Name,
    PCSTR Info,
    PITEMID_CHILD *Pidl)
{
    SIZE_T cbmod = Module != NULL ? strlen (Module) + 1 : 0;
    SIZE_T cbname = Name != NULL ? strlen (Name) + 1 : 0;
    SIZE_T cbinfo = Info != NULL ? strlen (Info) + 1 : 0;

    SIZE_T cb = FIELD_OFFSET (IDCONTROL, Module) + cbmod + cbname + cbinfo;
    if (cb != (USHORT) cb) {
        PutError ("Bad PIDL size 0x%IX", cb);
        return E_FAIL;
    }

    PITEMID_CHILD pidl = ILCreateChild (cb);
    if (pidl == NULL) {
        PutMemoryError ();
        return E_OUTOFMEMORY;
    }

    IDCONTROL *idc = (IDCONTROL *) pidl;

    idc -> cb = (USHORT) cb;
    idc -> Icon = Icon;
    idc -> Name = (USHORT) cbmod;
    idc -> Info = (USHORT) (cbmod + cbname);

    PCHAR out = idc -> Module;
    if (cbmod != 0) {
        memcpy (out, Module, cbmod);
        out += cbmod;
    }
    if (cbname != 0) {
        memcpy (out, Name, cbname);
        out += cbname;
    }
    if (cbinfo != 0) {
        memcpy (out, Info, cbinfo);
        out += cbinfo;
    }

    ((SHITEMID *) out) -> cb = 0;

    *Pidl = pidl;
    return S_OK;
}

HRESULT
CreateIDControlW (
    PCWSTR Module,
    INT Icon,
    PCWSTR Name,
    PCWSTR Info,
    bool Wow,
    PITEMID_CHILD *Pidl)
{
    SIZE_T cchmod, cbmod;
    SIZE_T cchname, cbname;
    SIZE_T cbinfo;

    if (Module != NULL) {
        cchmod = wcslen (Module) + 1;
        cbmod = cchmod * sizeof (WCHAR);
    }
    else {
        cchmod = 0;
        cbmod = 0;
    }

    if (Name != NULL) {
        cchname = wcslen (Name) + 1;
        cbname = cchname * sizeof (WCHAR);
    }
    else {
        cchname = 0;
        cbname = 0;
    }

    if (Info != NULL) {
        cbinfo = (wcslen (Info) + 1) * sizeof (WCHAR);
    }
    else {
        cbinfo = 0;
    }

    SIZE_T cb = FIELD_OFFSET (IDCONTROLW, ModuleW) + cbmod + cbname + cbinfo;
    if (cb != (USHORT) cb) {
        PutError ("Bad PIDL size 0x%IX", cb);
        return E_FAIL;
    }

    PITEMID_CHILD pidl = ILCreateChild (cb);
    if (pidl == NULL) {
        PutMemoryError ();
        return E_OUTOFMEMORY;
    }

    IDCONTROLW *idc = (IDCONTROLW *) pidl;

    idc -> cb = (USHORT) cb;
    idc -> Icon = Icon;
    #pragma warning (suppress : 6201)   // else Module [1] is out of bounds
    idc -> Module [1] = 'j';
    if (Wow) idc -> Flags = 0x01;
    idc -> NameW = (USHORT) cchmod;
    idc -> InfoW = (USHORT) (cchmod + cchname);

    PWCHAR out = idc -> ModuleW;
    if (cbmod != 0) {
        memcpy (out, Module, cbmod);
        ((PBYTE &) out) += cbmod;
    }
    if (cbname != 0) {
        memcpy (out, Name, cbname);
        ((PBYTE &) out) += cbname;
    }
    if (cbinfo != 0) {
        memcpy (out, Info, cbinfo);
        ((PBYTE &) out) += cbinfo;
    }

    ((SHITEMID *) out) -> cb = 0;

    *Pidl = pidl;
    return S_OK;
}

/*  ************************************************************************  */
/*  Helper  */

PITEMID_CHILD ILCreateChild (SIZE_T Size)
{
    Size += sizeof (SHITEMID);
    PITEMID_CHILD pidl = (PITEMID_CHILD) CoTaskMemAlloc (Size);
    if (pidl != NULL) RtlZeroMemory (pidl, Size);
    return pidl;
}

/*  ************************************************************************  */

