
/*  ************************************************************************  *
 *                                puterror.cpp                                *
 *  ************************************************************************  */

#include    "stdinc.h"

#include    <stdio.h>

#include    "puterror.h"

/*  ************************************************************************  */

VOID PutError (PCSTR Text, ...)
{
    va_list argptr;
    va_start (argptr, Text);
    printf ("\n");
    vprintf (Text, argptr);
    printf ("\n");
    va_end (argptr);
}

/*  Overload with error code  */

VOID PutError (HRESULT Error, PCSTR Text, ...)
{
    va_list argptr;
    va_start (argptr, Text);
    printf ("\nError 0x%08X ", Error);
    vprintf (Text, argptr);
    printf ("\n");
    va_end (argptr);
}

/*  Special case that's described easily and generally  */

VOID PutMemoryError (VOID)
{
    PutError ("Out of memory");
}

/*  Just text for information  */

VOID PutInfo (PCSTR Text, ...)
{
    va_list argptr;
    va_start (argptr, Text);
    vprintf (Text, argptr);
    printf ("\n");
    va_end (argptr);
}

/*  ************************************************************************  */

