
/*  ************************************************************************  *
 *                                shortcut.cpp                                *
 *  ************************************************************************  */

#include    "stdinc.h"

#pragma     warning (push)
#pragma     warning (disable : 4917)    // for Microsoft's OCIDL.H
#include    <shobjidl.h>
#pragma     warning (pop)

#include    "puterror.h"
#include    "shortcut.h"

/*  ************************************************************************  */

HRESULT CreateShortcut (PCIDLIST_ABSOLUTE Target, PCWSTR FileName)
{
    /*  To create a shortcut file we need a ShellLink object. Its IShellLink
        interface lets us set the link's properties (of which we have only a
        target, albeit an esssentially arbitrary one). Its IPersistFile
        interface lets us save the link as a shortcut file.

        There's no point if we can't get both interfaces.  */

    IShellLink *sl;
    HRESULT hr = CoCreateInstance (
                    __uuidof (ShellLink),
                    NULL,
                    CLSCTX_INPROC_SERVER,
                    __uuidof (*sl),
                    (PVOID *) &sl);
    if (FAILED (hr)) {
        PutError (hr, "creating ShellLink object");
    }
    else {

        IPersistFile *pf;
        hr = sl -> QueryInterface (__uuidof (*pf), (PVOID *) &pf);
        if (FAILED (hr)) {
            PutError (hr, "getting IPersistFile interface");
        }
        else {

            /*  Set the target. Save the file. That's it.  */

            hr = sl -> SetIDList (Target);
            if (FAILED (hr)) {
                PutError (hr, "setting link target");
            }
            else {

                hr = pf -> Save (FileName, TRUE);
                if (FAILED (hr)) {
                    PutError (hr, "saving link as \"%ws\"", FileName);
                }

                /*  It's all clean-up from here.  */
            }
            pf -> Release ();
        }
        sl -> Release ();
    }
    return hr;
}

/*  ************************************************************************  */

