/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.spec.SecretKeySpec;

class JKS
extends KeyStoreSpi {
    private static final int MAGIC = -17957139;
    private static final int PRIVATE_KEY = 1;
    private static final int TRUSTED_CERT = 2;
    private final Vector aliases = new Vector();
    private final HashMap trustedCerts = new HashMap();
    public final HashMap privateKeys = new HashMap();
    public final HashMap certChains = new HashMap();
    private final HashMap dates = new HashMap();
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.privateKeys.containsKey(string)) {
            return null;
        }
        byte[] byArray = JKS.decryptKey((byte[])this.privateKeys.get(string), JKS.charsToBytes(cArray));
        Certificate[] certificateArray = this.engineGetCertificateChain(string);
        if (certificateArray.length > 0) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(certificateArray[0].getPublicKey().getAlgorithm());
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new UnrecoverableKeyException(invalidKeySpecException.getMessage());
            }
        }
        return new SecretKeySpec(byArray, string);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        return (Certificate[])this.certChains.get(string);
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        return (Certificate)this.trustedCerts.get(string);
    }

    @Override
    public Date engineGetCreationDate(String string) {
        return (Date)this.dates.get(string);
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (this.trustedCerts.containsKey(string)) {
            throw new KeyStoreException("\"" + string + " is a trusted certificate entry");
        }
        this.privateKeys.put(string, JKS.encryptKey(key, JKS.charsToBytes(cArray)));
        if (certificateArray != null) {
            this.certChains.put(string, certificateArray);
        } else {
            this.certChains.put(string, new Certificate[0]);
        }
        if (!this.aliases.contains(string)) {
            this.dates.put(string, new Date());
            this.aliases.add(string);
        }
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        if (this.trustedCerts.containsKey(string)) {
            throw new KeyStoreException("\"" + string + "\" is a trusted certificate entry");
        }
        try {
            new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            throw new KeyStoreException("encoded key is not an EncryptedPrivateKeyInfo");
        }
        this.privateKeys.put(string, byArray);
        if (certificateArray != null) {
            this.certChains.put(string, certificateArray);
        } else {
            this.certChains.put(string, new Certificate[0]);
        }
        if (!this.aliases.contains(string)) {
            this.dates.put(string, new Date());
            this.aliases.add(string);
        }
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.privateKeys.containsKey(string)) {
            throw new KeyStoreException("\"" + string + "\" is a private key entry");
        }
        if (certificate == null) {
            throw new NullPointerException();
        }
        this.trustedCerts.put(string, certificate);
        if (!this.aliases.contains(string)) {
            this.dates.put(string, new Date());
            this.aliases.add(string);
        }
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        this.aliases.remove(string);
    }

    public Enumeration engineAliases() {
        return this.aliases.elements();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.aliases.contains(string);
    }

    @Override
    public int engineSize() {
        return this.aliases.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        return this.privateKeys.containsKey(string);
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        return this.trustedCerts.containsKey(string);
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        for (String string : this.trustedCerts.keySet()) {
            if (!certificate.equals(this.trustedCerts.get(string))) continue;
            return string;
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        messageDigest.update(JKS.charsToBytes(cArray));
        messageDigest.update("Mighty Aphrodite".getBytes("UTF-8"));
        DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(outputStream, messageDigest));
        dataOutputStream.writeInt(-17957139);
        dataOutputStream.writeInt(2);
        dataOutputStream.writeInt(this.aliases.size());
        Object object = this.aliases.elements();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            if (this.trustedCerts.containsKey(string)) {
                dataOutputStream.writeInt(2);
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeLong(((Date)this.dates.get(string)).getTime());
                JKS.writeCert(dataOutputStream, (Certificate)this.trustedCerts.get(string));
                continue;
            }
            dataOutputStream.writeInt(1);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeLong(((Date)this.dates.get(string)).getTime());
            byte[] byArray = (byte[])this.privateKeys.get(string);
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
            Certificate[] certificateArray = (Certificate[])this.certChains.get(string);
            dataOutputStream.writeInt(certificateArray.length);
            for (int i = 0; i < certificateArray.length; ++i) {
                JKS.writeCert(dataOutputStream, certificateArray[i]);
            }
        }
        object = messageDigest.digest();
        dataOutputStream.write((byte[])object);
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        messageDigest.update(JKS.charsToBytes(cArray));
        messageDigest.update("Mighty Aphrodite".getBytes("UTF-8"));
        this.aliases.clear();
        this.trustedCerts.clear();
        this.privateKeys.clear();
        this.certChains.clear();
        this.dates.clear();
        DataInputStream dataInputStream = new DataInputStream(new DigestInputStream(inputStream, messageDigest));
        if (dataInputStream.readInt() != -17957139) {
            throw new IOException("not a JavaKeyStore");
        }
        dataInputStream.readInt();
        int n = dataInputStream.readInt();
        this.aliases.ensureCapacity(n);
        if (n < 0) {
            throw new IOException("negative entry count");
        }
        block4: for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            String string = dataInputStream.readUTF();
            this.aliases.add(string);
            this.dates.put(string, new Date(dataInputStream.readLong()));
            switch (n2) {
                case 1: {
                    int n3 = dataInputStream.readInt();
                    byte[] byArray = new byte[n3];
                    dataInputStream.read(byArray);
                    this.privateKeys.put(string, byArray);
                    int n4 = dataInputStream.readInt();
                    Certificate[] certificateArray = new Certificate[n4];
                    for (int j = 0; j < n4; ++j) {
                        certificateArray[j] = JKS.readCert(dataInputStream);
                    }
                    this.certChains.put(string, certificateArray);
                    continue block4;
                }
                case 2: {
                    this.trustedCerts.put(string, JKS.readCert(dataInputStream));
                    continue block4;
                }
                default: {
                    throw new IOException("malformed key store");
                }
            }
        }
        byte[] byArray = new byte[20];
        dataInputStream.read(byArray);
        if (MessageDigest.isEqual(byArray, messageDigest.digest())) {
            throw new IOException("signature not verified");
        }
    }

    private static Certificate readCert(DataInputStream dataInputStream) throws IOException, CertificateException, NoSuchAlgorithmException {
        String string = dataInputStream.readUTF();
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        CertificateFactory certificateFactory = CertificateFactory.getInstance(string);
        return certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
    }

    private static void writeCert(DataOutputStream dataOutputStream, Certificate certificate) throws IOException, CertificateException {
        dataOutputStream.writeUTF(certificate.getType());
        byte[] byArray = certificate.getEncoded();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    public static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = hexArray[n >>> 4];
            cArray[i * 2 + 1] = hexArray[n & 0xF];
        }
        return new String(cArray);
    }

    private static byte[] decryptKey(byte[] byArray, byte[] byArray2) throws UnrecoverableKeyException {
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
            byte[] byArray3 = encryptedPrivateKeyInfo.getEncryptedData();
            byte[] byArray4 = new byte[20];
            System.arraycopy(byArray3, 0, byArray4, 0, 20);
            byte[] byArray5 = new byte[20];
            System.arraycopy(byArray3, byArray3.length - 20, byArray5, 0, 20);
            byte[] byArray6 = new byte[byArray3.length - 40];
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            int n = 0;
            while (n < byArray6.length) {
                messageDigest.reset();
                messageDigest.update(byArray2);
                messageDigest.update(byArray4);
                messageDigest.digest(byArray4, 0, byArray4.length);
                for (int i = 0; i < byArray4.length && n < byArray6.length; ++n, ++i) {
                    byArray6[n] = (byte)(byArray4[i] ^ byArray3[n + 20]);
                }
            }
            messageDigest.reset();
            messageDigest.update(byArray2);
            messageDigest.update(byArray6);
            if (!MessageDigest.isEqual(byArray5, messageDigest.digest())) {
                throw new UnrecoverableKeyException("checksum mismatch");
            }
            return byArray6;
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException(exception.getMessage());
        }
    }

    private static byte[] encryptKey(Key key, byte[] byArray) throws KeyStoreException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] byArray2 = key.getEncoded();
            byte[] byArray3 = new byte[byArray2.length + 40];
            byte[] byArray4 = SecureRandom.getSeed(20);
            System.arraycopy(byArray4, 0, byArray3, 0, 20);
            int n = 0;
            while (n < byArray2.length) {
                messageDigest.reset();
                messageDigest.update(byArray);
                messageDigest.update(byArray4);
                messageDigest.digest(byArray4, 0, byArray4.length);
                for (int i = 0; i < byArray4.length && n < byArray2.length; ++n, ++i) {
                    byArray3[n + 20] = (byte)(byArray4[i] ^ byArray2[n]);
                }
            }
            messageDigest.reset();
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            messageDigest.digest(byArray3, byArray3.length - 20, 20);
            return new EncryptedPrivateKeyInfo("1.3.6.1.4.1.42.2.17.1.1", byArray3).getEncoded();
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.getMessage());
        }
    }

    private static byte[] charsToBytes(char[] cArray) {
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            byArray[n++] = (byte)(cArray[i] >>> 8);
            byArray[n++] = (byte)cArray[i];
        }
        return byArray;
    }
}

