/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import javax.crypto.EncryptedPrivateKeyInfo;

public class JksPrivkPrepare {
    static HashMap<String, byte[][]> mappings = new HashMap<String, byte[][]>(){
        {
            this.put("DSA_512", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("3081a806072a8648ce3804013081")});
            this.put("DSA_1024", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("003082012c06072a8648ce380401")});
            this.put("DSA_504", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("3081a806072a8648ce3804013081")});
            this.put("DSA_1016", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("003082012c06072a8648ce380401")});
            this.put("DSA", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("003082012c06072a8648ce380401")});
            this.put("RSA_512", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("00300d06092a864886f70d010101")});
            this.put("RSA_784", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("00300d06092a864886f70d010101")});
            this.put("RSA_1024", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("00300d06092a864886f70d010101")});
            this.put("RSA_2048", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("00300d06092a864886f70d010101")});
            this.put("RSA_4096", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("00300d06092a864886f70d010101")});
            this.put("RSA_8192", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("00300d06092a864886f70d010101")});
            this.put("RSA", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("00300d06092a864886f70d010101")});
            this.put("EC_256", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("1306072a8648ce3d020106082a86")});
            this.put("EC_359", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("1306072a8648ce3d020106082a86")});
            this.put("EC_431", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("1306072a8648ce3d020106082a86")});
            this.put("EC_283", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("1006072a8648ce3d020106052b81")});
            this.put("EC_384", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("1006072a8648ce3d020106052b81")});
            this.put("EC_409", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("1006072a8648ce3d020106052b81")});
            this.put("EC_521", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("1006072a8648ce3d020106052b81")});
            this.put("EC", new byte[][]{JksPrivkPrepare.hexToBytes("30"), JksPrivkPrepare.hexToBytes("1006072a8648ce3d020106052b81")});
        }
    };
    static int[] fingerprint_indexes_first = new int[]{0};
    static int[] fingerprint_indexes_second = new int[]{6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static void main(String[] stringArray) throws FileNotFoundException, CertificateException, NoSuchAlgorithmException {
        if (stringArray.length < 1) {
            System.err.println("Usage: java JksPrivkPrepare keystore_file");
            System.exit(1);
        }
        String string = stringArray[0];
        FileInputStream fileInputStream = new FileInputStream(string);
        JKS jKS = new JKS();
        try {
            try {
                jKS.engineLoad(fileInputStream, "we could not care less about the keystore password :)".toCharArray());
            }
            catch (Exception exception) {
                System.err.println("The file you specified does not seem to be a valid JKS file format. Are you sure it is not one of the other Key Store formats?");
                System.err.println("Exception was:");
                exception.printStackTrace(System.err);
            }
            ((InputStream)fileInputStream).close();
            Enumeration enumeration = jKS.engineAliases();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string2 = (String)enumeration.nextElement();
                byte[] byArray = (byte[])jKS.privateKeys.get(string2);
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = null;
                try {
                    encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
                }
                catch (Exception exception) {
                    System.err.println("Alias " + string2 + " seems to have no private key associated.");
                    continue;
                }
                byte[] byArray2 = encryptedPrivateKeyInfo.getEncryptedData();
                byte[] byArray3 = Arrays.copyOfRange(byArray2, 0, 20);
                byte[] byArray4 = Arrays.copyOfRange(byArray2, byArray2.length - 20, byArray2.length);
                byte[] byArray5 = Arrays.copyOfRange(byArray2, 20, byArray2.length - 20);
                Certificate[] certificateArray = (Certificate[])jKS.certChains.get(string2);
                Certificate certificate = certificateArray[0];
                PublicKey publicKey = certificate.getPublicKey();
                String string3 = publicKey.getAlgorithm();
                String string4 = "";
                if (string3.equals("RSA")) {
                    object = (RSAPublicKey)publicKey;
                    string4 = String.valueOf(object.getModulus().bitLength());
                } else if (string3.equals("DSA")) {
                    int n;
                    object = (DSAPublicKey)publicKey;
                    if (object.getParams() != null) {
                        n = object.getParams().getP().bitLength();
                    } else {
                        n = object.getY().bitLength();
                        for (int i = 128; i < 10000; i *= 2) {
                            if (i - 20 >= n || n >= i + 20) continue;
                            n = i;
                            break;
                        }
                    }
                    string4 = String.valueOf(n);
                } else if (string3.equals("EC")) {
                    object = (ECPublicKey)publicKey;
                    string4 = String.valueOf(object.getParams().getCurve().getField().getFieldSize());
                } else {
                    System.err.println("The public key is not in RSA, DSA or EC format, but " + string3 + ".");
                    System.err.println("This is not supported, the default provider doesn't have this format.");
                    System.exit(1);
                }
                System.err.println("Alias: " + string2 + ", algorithm: " + string3 + ", keysize or field size: " + string4);
                object = JksPrivkPrepare.choseFingerprint(string3, string4);
                byte[] byArray6 = Arrays.copyOfRange(byArray5, 0, 20);
                byte[][] byArray7 = JksPrivkPrepare.precalculateXorStep(byArray6, (byte[][])object);
                String string5 = "$jksprivk$*" + JksPrivkPrepare.bytesToHex(byArray4) + "*" + JksPrivkPrepare.bytesToHex(byArray3) + "*" + JksPrivkPrepare.bytesToHex(byArray5) + "*" + JksPrivkPrepare.bytesToHex(byArray7[0]) + "*" + JksPrivkPrepare.bytesToHex(byArray7[1]) + "*" + string2;
                System.out.println(string5);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static byte[][] choseFingerprint(String string, String string2) {
        byte[][] byArray;
        if (mappings.containsKey(string + "_" + string2)) {
            byArray = mappings.get(string + "_" + string2);
        } else if (string.equals("RSA")) {
            byArray = mappings.get(string);
        } else {
            System.err.println("WARNING: The key type " + string + "_" + string2 + " is untested.");
            System.err.println("WARNING: We are going to try to make a best bet choice how this could work.");
            System.err.println("WARNING: If you are able to make a new fingerprint for this type (eg. create example keystore");
            System.err.println("WARNING: Add the fingerprint of the decrypted private key to the mappings variable.");
            byArray = mappings.get(string);
        }
        return byArray;
    }

    public static byte[][] precalculateXorStep(byte[] byArray, byte[][] byArray2) {
        byte[] byArray3 = new byte[byArray2[0].length];
        int n = 0;
        for (int n2 : fingerprint_indexes_first) {
            byArray3[n] = (byte)(byArray2[0][n] ^ byArray[n2]);
            ++n;
        }
        n = 0;
        byte[] byArray4 = new byte[byArray2[1].length];
        for (int n3 : fingerprint_indexes_second) {
            byArray4[n] = (byte)(byArray2[1][n] ^ byArray[n3]);
            ++n;
        }
        byte[][] byArrayArray = new byte[][]{byArray3, byArray4};
        return byArrayArray;
    }

    public static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = hexArray[n >>> 4];
            cArray[i * 2 + 1] = hexArray[n & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] hexToBytes(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }
}

