/*
 * Decompiled with CFR 0.152.
 */
import com.lagodiuk.gp.symbolic.SymbolicRegressionEngine;
import com.lagodiuk.gp.symbolic.SymbolicRegressionIterationListener;
import com.lagodiuk.gp.symbolic.TabulatedFunctionFitness;
import com.lagodiuk.gp.symbolic.Target;
import com.lagodiuk.gp.symbolic.interpreter.Expression;
import com.lagodiuk.gp.symbolic.interpreter.Functions;
import java.util.LinkedList;
import java.util.List;

public class HelloSymbolicRegression {
    public static void main(String[] args) {
        TabulatedFunctionFitness fitness = new TabulatedFunctionFitness(new Target().when("x", 0.0).targetIs(0.0), new Target().when("x", 1.0).targetIs(11.0), new Target().when("x", 2.0).targetIs(24.0), new Target().when("x", 3.0).targetIs(39.0), new Target().when("x", 4.0).targetIs(56.0), new Target().when("x", 5.0).targetIs(75.0), new Target().when("x", 6.0).targetIs(96.0));
        SymbolicRegressionEngine engine = new SymbolicRegressionEngine(fitness, HelloSymbolicRegression.list("x"), HelloSymbolicRegression.list(Functions.ADD, Functions.SUB, Functions.MUL, Functions.VARIABLE, Functions.CONSTANT));
        HelloSymbolicRegression.addListener(engine);
        engine.evolve(200);
    }

    private static void addListener(SymbolicRegressionEngine engine) {
        engine.addIterationListener(new SymbolicRegressionIterationListener(){

            @Override
            public void update(SymbolicRegressionEngine engine) {
                Expression bestSyntaxTree = engine.getBestSyntaxTree();
                double currFitValue = engine.fitness(bestSyntaxTree);
                System.out.println(String.format("iter = %s \t fit = %s \t func = %s", engine.getIteration(), currFitValue, bestSyntaxTree.print()));
                if (currFitValue < 5.0) {
                    engine.terminate();
                }
            }
        });
    }

    private static <T> List<T> list(T ... items) {
        LinkedList<T> list = new LinkedList<T>();
        for (T item : items) {
            list.add(item);
        }
        return list;
    }
}

