/*
 * Decompiled with CFR 0.152.
 */
package com.lagodiuk.gp.symbolic;

import com.lagodiuk.ga.Chromosome;
import com.lagodiuk.ga.Fitness;
import com.lagodiuk.ga.GeneticAlgorithm;
import com.lagodiuk.ga.Population;
import com.lagodiuk.gp.symbolic.interpreter.Context;
import com.lagodiuk.gp.symbolic.interpreter.Expression;
import com.lagodiuk.gp.symbolic.interpreter.Function;
import com.lagodiuk.gp.symbolic.interpreter.SyntaxTreeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

class GpChromosome
implements Chromosome<GpChromosome> {
    private Expression syntaxTree;
    private Context context;
    private Fitness<GpChromosome, Double> fitnessFunction;
    private Random random = new Random();

    public GpChromosome(Context context, Fitness<GpChromosome, Double> fitnessFunction, Expression syntaxTree) {
        this.context = context;
        this.fitnessFunction = fitnessFunction;
        this.syntaxTree = syntaxTree;
    }

    public List<GpChromosome> crossover(GpChromosome anotherChromosome) {
        ArrayList<GpChromosome> ret = new ArrayList<GpChromosome>(2);
        GpChromosome thisClone = new GpChromosome(this.context, this.fitnessFunction, this.syntaxTree.clone());
        GpChromosome anotherClone = new GpChromosome(this.context, this.fitnessFunction, anotherChromosome.syntaxTree.clone());
        Expression thisRandomNode = this.getRandomNode(thisClone.syntaxTree);
        Expression anotherRandomNode = this.getRandomNode(anotherClone.syntaxTree);
        Expression thisRandomSubTreeClone = thisRandomNode.clone();
        Expression anotherRandomSubTreeClone = anotherRandomNode.clone();
        this.swapNode(thisRandomNode, anotherRandomSubTreeClone);
        this.swapNode(anotherRandomNode, thisRandomSubTreeClone);
        ret.add(thisClone);
        ret.add(anotherClone);
        thisClone.optimizeTree();
        anotherClone.optimizeTree();
        return ret;
    }

    public GpChromosome mutate() {
        GpChromosome ret = new GpChromosome(this.context, this.fitnessFunction, this.syntaxTree.clone());
        int type = this.random.nextInt(7);
        switch (type) {
            case 0: {
                ret.mutateByRandomChangeOfFunction();
                break;
            }
            case 1: {
                ret.mutateByRandomChangeOfChild();
                break;
            }
            case 2: {
                ret.mutateByRandomChangeOfNodeToChild();
                break;
            }
            case 3: {
                ret.mutateByReverseOfChildsList();
                break;
            }
            case 4: {
                ret.mutateByRootGrowth();
                break;
            }
            case 5: {
                ret.syntaxTree = SyntaxTreeUtils.createTree(2, this.context);
                break;
            }
            case 6: {
                ret.mutateByReplaceEntireTreeWithAnySubTree();
            }
        }
        ret.optimizeTree();
        return ret;
    }

    private void mutateByReplaceEntireTreeWithAnySubTree() {
        this.syntaxTree = this.getRandomNode(this.syntaxTree);
    }

    private void mutateByRootGrowth() {
        int i;
        Function function = this.context.getRandomNonTerminalFunction();
        Expression newRoot = new Expression(function);
        newRoot.addChild(this.syntaxTree);
        for (i = 1; i < function.argumentsCount(); ++i) {
            newRoot.addChild(SyntaxTreeUtils.createTree(0, this.context));
        }
        for (i = 0; i < function.argumentsCount(); ++i) {
            newRoot.addCoefficient(this.context.getRandomValue());
        }
        this.syntaxTree = newRoot;
    }

    private void mutateByRandomChangeOfFunction() {
        int mutatingNodeCoefficientsCount;
        int functionCoefficientsCount;
        int mutatingNodeChildsCount;
        int functionArgumentsCount;
        Expression mutatingNode = this.getRandomNode(this.syntaxTree);
        Function oldFunction = mutatingNode.getFunction();
        Function newFunction = null;
        for (int i = 0; i < 3 && (newFunction = this.random.nextDouble() > 0.5 ? this.context.getRandomNonTerminalFunction() : this.context.getRandomTerminalFunction()) == oldFunction; ++i) {
        }
        mutatingNode.setFunction(newFunction);
        if (newFunction.isVariable()) {
            mutatingNode.setVariable(this.context.getRandomVariableName());
        }
        if ((functionArgumentsCount = newFunction.argumentsCount()) > (mutatingNodeChildsCount = mutatingNode.getChilds().size())) {
            for (int i = 0; i < functionArgumentsCount - mutatingNodeChildsCount + 1; ++i) {
                mutatingNode.getChilds().add(SyntaxTreeUtils.createTree(1, this.context));
            }
        } else if (functionArgumentsCount < mutatingNodeChildsCount) {
            ArrayList<Expression> subList = new ArrayList<Expression>(functionArgumentsCount);
            for (int i = 0; i < functionArgumentsCount; ++i) {
                subList.add(mutatingNode.getChilds().get(i));
            }
            mutatingNode.setChilds(subList);
        }
        if ((functionCoefficientsCount = newFunction.coefficientsCount()) > (mutatingNodeCoefficientsCount = mutatingNode.getCoefficientsOfNode().size())) {
            for (int i = 0; i < functionCoefficientsCount - mutatingNodeCoefficientsCount + 1; ++i) {
                mutatingNode.addCoefficient(this.context.getRandomValue());
            }
        } else if (functionCoefficientsCount < mutatingNodeCoefficientsCount) {
            ArrayList<Double> subList = new ArrayList<Double>(functionCoefficientsCount);
            for (int i = 0; i < functionCoefficientsCount; ++i) {
                subList.add(mutatingNode.getCoefficientsOfNode().get(i));
            }
            mutatingNode.setCoefficientsOfNode(subList);
        }
    }

    private void mutateByReverseOfChildsList() {
        Expression mutatingNode = this.getRandomNode(this.syntaxTree);
        Function mutatingNodeFunction = mutatingNode.getFunction();
        if (mutatingNode.getChilds().size() > 1 && !mutatingNodeFunction.isCommutative()) {
            Collections.reverse(mutatingNode.getChilds());
        } else {
            this.mutateByRandomChangeOfFunction();
        }
    }

    private void mutateByRandomChangeOfChild() {
        Expression mutatingNode = this.getRandomNode(this.syntaxTree);
        if (!mutatingNode.getChilds().isEmpty()) {
            int indx = this.random.nextInt(mutatingNode.getChilds().size());
            mutatingNode.getChilds().set(indx, SyntaxTreeUtils.createTree(1, this.context));
        } else {
            this.mutateByRandomChangeOfFunction();
        }
    }

    private void mutateByRandomChangeOfNodeToChild() {
        Expression mutatingNode = this.getRandomNode(this.syntaxTree);
        if (!mutatingNode.getChilds().isEmpty()) {
            int indx = this.random.nextInt(mutatingNode.getChilds().size());
            Expression child = mutatingNode.getChilds().get(indx);
            this.swapNode(mutatingNode, child.clone());
        } else {
            this.mutateByRandomChangeOfFunction();
        }
    }

    private Expression getRandomNode(Expression tree) {
        List<Expression> allNodesOfTree = tree.getAllNodesAsList();
        int allNodesOfTreeCount = allNodesOfTree.size();
        int indx = this.random.nextInt(allNodesOfTreeCount);
        return allNodesOfTree.get(indx);
    }

    private void swapNode(Expression oldNode, Expression newNode) {
        oldNode.setChilds(newNode.getChilds());
        oldNode.setFunction(newNode.getFunction());
        oldNode.setCoefficientsOfNode(newNode.getCoefficientsOfNode());
        oldNode.setVariable(newNode.getVariable());
    }

    public void optimizeTree() {
        this.optimizeTree(70);
    }

    public void optimizeTree(int iterations) {
        SyntaxTreeUtils.cutTree(this.syntaxTree, this.context, 6);
        SyntaxTreeUtils.simplifyTree(this.syntaxTree, this.context);
        List<Double> coefficientsOfTree = this.syntaxTree.getCoefficientsOfTree();
        if (coefficientsOfTree.size() > 0) {
            CoefficientsChromosome initialChromosome = new CoefficientsChromosome(coefficientsOfTree, 0.6, 0.8);
            Population population = new Population();
            for (int i = 0; i < 5; ++i) {
                population.addChromosome((Chromosome)initialChromosome.mutate());
            }
            population.addChromosome((Chromosome)initialChromosome);
            CoefficientsFitness fit = new CoefficientsFitness();
            GeneticAlgorithm env = new GeneticAlgorithm(population, (Fitness)fit);
            env.evolve(iterations);
            List<Double> optimizedCoefficients = ((CoefficientsChromosome)env.getBest()).getCoefficients();
            this.syntaxTree.setCoefficientsOfTree(optimizedCoefficients);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Expression getSyntaxTree() {
        return this.syntaxTree;
    }

    private class CoefficientsFitness
    implements Fitness<CoefficientsChromosome, Double> {
        private CoefficientsFitness() {
        }

        public Double calculate(CoefficientsChromosome chromosome) {
            GpChromosome.this.syntaxTree.setCoefficientsOfTree(chromosome.getCoefficients());
            return (Double)GpChromosome.this.fitnessFunction.calculate((Chromosome)GpChromosome.this);
        }
    }

    private class CoefficientsChromosome
    implements Chromosome<CoefficientsChromosome>,
    Cloneable {
        private double pMutation;
        private double pCrossover;
        private List<Double> coefficients;

        public CoefficientsChromosome(List<Double> coefficients, double pMutation, double pCrossover) {
            this.coefficients = coefficients;
            this.pMutation = pMutation;
            this.pCrossover = pCrossover;
        }

        public List<CoefficientsChromosome> crossover(CoefficientsChromosome anotherChromosome) {
            ArrayList<CoefficientsChromosome> ret = new ArrayList<CoefficientsChromosome>(2);
            CoefficientsChromosome thisClone = this.clone();
            CoefficientsChromosome anotherClone = anotherChromosome.clone();
            for (int i = 0; i < thisClone.coefficients.size(); ++i) {
                if (!(GpChromosome.this.random.nextDouble() > this.pCrossover)) continue;
                thisClone.coefficients.set(i, anotherChromosome.coefficients.get(i));
                anotherClone.coefficients.set(i, this.coefficients.get(i));
            }
            ret.add(thisClone);
            ret.add(anotherClone);
            return ret;
        }

        public CoefficientsChromosome mutate() {
            CoefficientsChromosome ret = this.clone();
            for (int i = 0; i < ret.coefficients.size(); ++i) {
                if (!(GpChromosome.this.random.nextDouble() > this.pMutation)) continue;
                double coeff = ret.coefficients.get(i);
                ret.coefficients.set(i, coeff += GpChromosome.this.context.getRandomMutationValue());
            }
            return ret;
        }

        protected CoefficientsChromosome clone() {
            ArrayList<Double> ret = new ArrayList<Double>(this.coefficients.size());
            for (double d : this.coefficients) {
                ret.add(d);
            }
            return new CoefficientsChromosome(ret, this.pMutation, this.pCrossover);
        }

        public List<Double> getCoefficients() {
            return this.coefficients;
        }
    }
}

