/*
 * Decompiled with CFR 0.152.
 */
package com.lagodiuk.gp.symbolic.interpreter;

import com.lagodiuk.gp.symbolic.interpreter.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Context {
    private Random random = new Random();
    private int minValue = -1024;
    private int maxValue = 1024;
    private int minMutationValue = -7;
    private int maxMutationValue = 7;
    private Map<String, Double> variables = new HashMap<String, Double>();
    private List<Function> nonTerminalFunctions = new ArrayList<Function>();
    private List<Function> terminalFunctions = new ArrayList<Function>();
    private int nextRndFunctionIndx = 0;

    public Context(List<? extends Function> functions, Collection<String> variables) {
        for (Function function : functions) {
            if (function.argumentsCount() == 0) {
                this.terminalFunctions.add(function);
                continue;
            }
            this.nonTerminalFunctions.add(function);
        }
        if (this.terminalFunctions.isEmpty()) {
            throw new IllegalArgumentException("At least one terminal function must be defined");
        }
        if (variables.isEmpty()) {
            throw new IllegalArgumentException("At least one variable must be defined");
        }
        for (String string : variables) {
            this.setVariable(string, 0.0);
        }
    }

    public double lookupVariable(String variable) {
        return this.variables.get(variable);
    }

    public void setVariable(String variable, double value) {
        this.variables.put(variable, value);
    }

    public Function getRandomNonTerminalFunction() {
        return this.roundRobinFunctionSelection();
    }

    private Function roundRobinFunctionSelection() {
        if (this.nextRndFunctionIndx >= this.nonTerminalFunctions.size()) {
            this.nextRndFunctionIndx = 0;
            Collections.shuffle(this.nonTerminalFunctions);
        }
        return this.nonTerminalFunctions.get(this.nextRndFunctionIndx++);
    }

    public Function getRandomTerminalFunction() {
        int indx = this.random.nextInt(this.terminalFunctions.size());
        Function f = this.terminalFunctions.get(indx);
        return f;
    }

    public List<Function> getTerminalFunctions() {
        return this.terminalFunctions;
    }

    public String getRandomVariableName() {
        int indx = this.random.nextInt(this.variables.keySet().size());
        int i = 0;
        for (String varName : this.variables.keySet()) {
            if (i == indx) {
                return varName;
            }
            ++i;
        }
        return this.variables.keySet().iterator().next();
    }

    public double getRandomValue() {
        return this.random.nextInt(this.maxValue - this.minValue - 1) + this.minValue;
    }

    public double getRandomMutationValue() {
        return this.random.nextInt(this.maxMutationValue - this.minMutationValue - 1) + this.minMutationValue;
    }

    public boolean hasVariables() {
        return !this.variables.isEmpty();
    }
}

