/*
 * Decompiled with CFR 0.152.
 */
package com.lagodiuk.gp.symbolic.interpreter;

import com.lagodiuk.gp.symbolic.interpreter.Context;
import com.lagodiuk.gp.symbolic.interpreter.Expression;
import com.lagodiuk.gp.symbolic.interpreter.Function;
import java.util.LinkedList;
import java.util.List;

public enum Functions implements Function
{
    CONSTANT{
        private int coefficientsCount = 1;

        @Override
        public int argumentsCount() {
            return 0;
        }

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return expression.getCoefficientsOfNode().subList(0, this.coefficientsCount);
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
            for (int i = 0; i < this.coefficientsCount; ++i) {
                expression.addCoefficient(coefficients.get(startIndex + i));
            }
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            double r = expression.getCoefficientsOfNode().get(0);
            return (int)r;
        }

        @Override
        public String print(Expression expression) {
            double retVal = expression.getCoefficientsOfNode().get(0);
            retVal = (int)retVal;
            int i = (int)retVal;
            String retStr = null;
            retStr = retVal < 0.0 ? String.format("(%s)", i) : "" + i;
            return retStr;
        }

        @Override
        public boolean isNumber() {
            return true;
        }
    }
    ,
    VARIABLE{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 0;
        }

        @Override
        public boolean isVariable() {
            return true;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            return context.lookupVariable(expression.getVariable());
        }

        @Override
        public String print(Expression expression) {
            return expression.getVariable();
        }
    }
    ,
    ADD{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            int right = (int)childs.get(1).eval(context);
            return left + right;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            String right = childs.get(1).print();
            return String.format("(%s + %s)", left, right);
        }
    }
    ,
    MOD{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            int right = (int)childs.get(1).eval(context);
            if (right == 0) {
                return -2.147483648E9;
            }
            return left % right;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            String right = childs.get(1).print();
            return String.format("(%s %% %s)", left, right);
        }
    }
    ,
    TERNARY{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public double eval(Expression expression, Context context) {
            int right;
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            return left > (right = (int)childs.get(1).eval(context)) ? left : right;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            String right = childs.get(1).print();
            return String.format("(((%s)>(%s))?(%s):(%s))", left, right, left, right);
        }
    }
    ,
    BITAND{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            int right = (int)childs.get(1).eval(context);
            return left & right;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            String right = childs.get(1).print();
            return String.format("(%s & %s)", left, right);
        }
    }
    ,
    BITOR{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            int right = (int)childs.get(1).eval(context);
            return left | right;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            String right = childs.get(1).print();
            return String.format("(%s | %s)", left, right);
        }
    }
    ,
    BITXOR{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            int right = (int)childs.get(1).eval(context);
            return left ^ right;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            String right = childs.get(1).print();
            return String.format("(%s ^ %s)", left, right);
        }
    }
    ,
    BITSHIFTL{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            int right = (int)childs.get(1).eval(context);
            return left << right;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            String right = childs.get(1).print();
            return String.format("(%s << %s)", left, right);
        }
    }
    ,
    BITSHIFTR{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            int right = (int)childs.get(1).eval(context);
            return left >> right;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            String right = childs.get(1).print();
            return String.format("(%s >> %s)", left, right);
        }
    }
    ,
    SUB{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            int right = (int)childs.get(1).eval(context);
            return left - right;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            String right = childs.get(1).print();
            return String.format("(%s - %s)", left, right);
        }
    }
    ,
    MUL{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            int right = (int)childs.get(1).eval(context);
            return left * right;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            String right = childs.get(1).print();
            return String.format("(%s * %s)", left, right);
        }
    }
    ,
    DIV{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            int right = (int)childs.get(1).eval(context);
            if (right == 0) {
                return -2.147483648E9;
            }
            return left / right;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            String right = childs.get(1).print();
            return String.format("(%s / %s)", left, right);
        }
    }
    ,
    SQRT{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 1;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            double arg = childs.get(0).eval(context);
            return (int)Math.sqrt(Math.abs(arg));
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String arg = childs.get(0).print();
            return String.format("sqrt(abs(%s))", arg);
        }
    }
    ,
    POW{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 2;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int arg1 = (int)childs.get(0).eval(context);
            int arg2 = (int)childs.get(1).eval(context);
            return Math.pow(arg1, arg2);
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String arg1 = childs.get(0).print();
            String arg2 = childs.get(1).print();
            return String.format("((int)pow(%s,%s))", arg1, arg2);
        }
    }
    ,
    LN{
        private double threshold = 1.0E-5;
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 1;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            double arg = childs.get(0).eval(context);
            return (int)Math.log(Math.abs(arg) + this.threshold);
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String arg = childs.get(0).print();
            return String.format("(int)log(abs(%s) + %s)", arg, this.threshold);
        }
    }
    ,
    SIN{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 1;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            double arg = childs.get(0).eval(context);
            return Math.sin(arg);
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String arg = childs.get(0).print();
            return String.format("sin(%s)", arg);
        }
    }
    ,
    COS{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 1;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            double arg = childs.get(0).eval(context);
            return Math.cos(arg);
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String arg = childs.get(0).print();
            return String.format("cos(%s)", arg);
        }
    }
    ,
    NOT{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 1;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            return ~left;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            return String.format("(~%s)", left);
        }
    }
    ,
    UMINUS{
        private int coefficientsCount = 0;

        @Override
        public int coefficientsCount() {
            return this.coefficientsCount;
        }

        @Override
        public List<Double> getCoefficients(Expression expression) {
            return new LinkedList<Double>();
        }

        @Override
        public void setCoefficients(Expression expression, List<Double> coefficients, int startIndex) {
            expression.removeCoefficients();
        }

        @Override
        public int argumentsCount() {
            return 1;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public double eval(Expression expression, Context context) {
            List<Expression> childs = expression.getChilds();
            int left = (int)childs.get(0).eval(context);
            return -left;
        }

        @Override
        public String print(Expression expression) {
            List<Expression> childs = expression.getChilds();
            String left = childs.get(0).print();
            return String.format("(-%s)", left);
        }
    };

}

