/*
 * Decompiled with CFR 0.152.
 */
import com.lagodiuk.ga.Chromosome;
import com.lagodiuk.ga.Fitness;
import com.lagodiuk.ga.GeneticAlgorithm;
import com.lagodiuk.ga.IterartionListener;
import com.lagodiuk.ga.Population;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Demo {
    public static void main(String[] args) {
        Population<MyVector> population = Demo.createInitialPopulation(5);
        MyVectorFitness fitness = new MyVectorFitness();
        GeneticAlgorithm<MyVector, Double> ga = new GeneticAlgorithm<MyVector, Double>(population, fitness);
        Demo.addListener(ga);
        ga.evolve(500);
    }

    private static Population<MyVector> createInitialPopulation(int populationSize) {
        Population<MyVector> population = new Population<MyVector>();
        MyVector base = new MyVector();
        for (int i = 0; i < populationSize; ++i) {
            MyVector chr = base.mutate();
            population.addChromosome(chr);
        }
        return population;
    }

    private static void addListener(GeneticAlgorithm<MyVector, Double> ga) {
        System.out.println(String.format("%s\t%s\t%s", "iter", "fit", "chromosome"));
        ga.addIterationListener(new IterartionListener<MyVector, Double>(){
            private final double threshold = 1.0E-5;

            @Override
            public void update(GeneticAlgorithm<MyVector, Double> ga) {
                MyVector best = ga.getBest();
                double bestFit = ga.fitness(best);
                int iteration = ga.getIteration();
                System.out.println(String.format("%s\t%s\t%s", iteration, bestFit, best));
                if (bestFit < this.threshold) {
                    ga.terminate();
                }
            }
        });
    }

    public static class MyVectorFitness
    implements Fitness<MyVector, Double> {
        private final int[] target = new int[]{10, 20, 30, 40, 50};

        @Override
        public Double calculate(MyVector chromosome) {
            double delta = 0.0;
            int[] v = chromosome.getVector();
            for (int i = 0; i < 5; ++i) {
                delta += this.sqr(v[i] - this.target[i]);
            }
            return delta;
        }

        private double sqr(double x) {
            return x * x;
        }
    }

    public static class MyVector
    implements Chromosome<MyVector>,
    Cloneable {
        private static final Random random = new Random();
        private final int[] vector = new int[5];

        @Override
        public MyVector mutate() {
            MyVector result = this.clone();
            int index = random.nextInt(this.vector.length);
            int mutationValue = random.nextInt(3) - random.nextInt(3);
            int n = index;
            result.vector[n] = result.vector[n] + mutationValue;
            return result;
        }

        @Override
        public List<MyVector> crossover(MyVector other) {
            int index;
            MyVector thisClone = this.clone();
            MyVector otherClone = other.clone();
            for (int i = index = random.nextInt(this.vector.length - 1); i < this.vector.length; ++i) {
                int tmp = thisClone.vector[i];
                thisClone.vector[i] = otherClone.vector[i];
                otherClone.vector[i] = tmp;
            }
            return Arrays.asList(thisClone, otherClone);
        }

        protected MyVector clone() {
            MyVector clone = new MyVector();
            System.arraycopy(this.vector, 0, clone.vector, 0, this.vector.length);
            return clone;
        }

        public int[] getVector() {
            return this.vector;
        }

        public String toString() {
            return Arrays.toString(this.vector);
        }
    }
}

