/*
 * Decompiled with CFR 0.152.
 */
import com.lagodiuk.gp.symbolic.SymbolicRegressionEngine;
import com.lagodiuk.gp.symbolic.SymbolicRegressionIterationListener;
import com.lagodiuk.gp.symbolic.TabulatedFunctionFitness;
import com.lagodiuk.gp.symbolic.Target;
import com.lagodiuk.gp.symbolic.interpreter.Expression;
import com.lagodiuk.gp.symbolic.interpreter.Functions;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class HelloSymbolicRegression {
    private static double last_fit = 0.0;
    private static int cnt_repeat_fits = 0;

    public static List<Target> dumbcsv(String csvFile) throws IOException {
        String line = "";
        String cvsSplitBy = ",";
        ArrayList<Target> ret = new ArrayList<Target>();
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            while ((line = br.readLine()) != null) {
                String[] data = line.split(cvsSplitBy);
                double x = Double.parseDouble(data[0]);
                double y = Double.parseDouble(data[1]);
                Target point = new Target().when("x", x).targetIs(y);
                ret.add(point);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        return ret;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: csvdata.csv");
            System.exit(1);
        }
        List<Target> data = null;
        try {
            data = HelloSymbolicRegression.dumbcsv(args[0]);
        }
        catch (IOException e) {
            System.out.println("Unable to open csv datafile");
            System.exit(1);
        }
        TabulatedFunctionFitness fitness = new TabulatedFunctionFitness(data);
        SymbolicRegressionEngine engine = new SymbolicRegressionEngine(fitness, HelloSymbolicRegression.list("x"), HelloSymbolicRegression.list(Functions.ADD, Functions.MOD, Functions.NOT, Functions.SUB, Functions.MUL, Functions.DIV, Functions.LN, Functions.VARIABLE, Functions.CONSTANT, Functions.BITAND, Functions.BITXOR, Functions.BITOR, Functions.BITSHIFTR, Functions.BITSHIFTL, Functions.TERNARY));
        HelloSymbolicRegression.addListener(engine);
        do {
            cnt_repeat_fits = 0;
            last_fit = 1.0E300;
            engine.evolve(1000000);
        } while (Math.abs(last_fit) > 1.0E-14);
    }

    private static void addListener(SymbolicRegressionEngine engine) {
        engine.addIterationListener(new SymbolicRegressionIterationListener(){

            @Override
            public void update(SymbolicRegressionEngine engine) {
                Expression bestSyntaxTree = engine.getBestSyntaxTree();
                double currFitValue = engine.fitness(bestSyntaxTree);
                System.out.println(String.format("iter = %s \t fit = %s \t func = %s", engine.getIteration(), currFitValue, bestSyntaxTree.print()));
                if (currFitValue * currFitValue < 1.0E-16) {
                    engine.terminate();
                }
                if (Math.abs(currFitValue - last_fit) < 1.0E-14) {
                    if (cnt_repeat_fits > 100) {
                        engine.terminate();
                        return;
                    }
                    ++cnt_repeat_fits;
                } else {
                    last_fit = currFitValue;
                }
            }
        });
    }

    private static <T> List<T> list(T ... items) {
        LinkedList<T> list = new LinkedList<T>();
        for (T item : items) {
            list.add(item);
        }
        return list;
    }
}

