import java.util.LinkedList;
import java.util.ArrayList;
import java.util.List;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

import com.lagodiuk.gp.symbolic.SymbolicRegressionEngine;
import com.lagodiuk.gp.symbolic.SymbolicRegressionIterationListener;
import com.lagodiuk.gp.symbolic.TabulatedFunctionFitness;
import com.lagodiuk.gp.symbolic.Target;
import com.lagodiuk.gp.symbolic.interpreter.Expression;
import com.lagodiuk.gp.symbolic.interpreter.Functions;


/**
 * f(x) - ? <br/>
 * 
 * f(0) = 0 <br/>
 * f(1) = 11 <br/>
 * f(2) = 24 <br/>
 * f(3) = 39 <br/>
 * f(4) = 56 <br/>
 * f(5) = 75 <br/>
 * f(6) = 96 <br/>
 * 
 * (target function is f(x) = x^2 + 10*x)
 */
public class HelloSymbolicRegression {
    private static double last_fit = 0;
    private static int cnt_repeat_fits = 0;

	public static List<Target> dumbcsv(String csvFile) throws IOException {
		String line = "";
		String cvsSplitBy = ",";
		
		List<Target> ret = new ArrayList<Target>();
		try (BufferedReader br = new BufferedReader(new FileReader(csvFile))) {
			while ((line = br.readLine()) != null) {

				// use comma as separator
				String[] data = line.split(cvsSplitBy);
				double x = Double.parseDouble(data[0]);
				double y = Double.parseDouble(data[1]);
				Target point = new Target().when("x",x).targetIs(y);
				ret.add(point);
			}

		} catch (IOException e) {
			e.printStackTrace();
			throw e;
		}
		return ret;
	}

	public static void main(String[] args) {
		
		if(args.length  != 1) { 
			System.out.println("Usage: csvdata.csv");
			System.exit(1);
		}

		List<Target> data = null;
		try {
			data = dumbcsv(args[0]);
		} catch (IOException e) {
			System.out.println("Unable to open csv datafile");
			System.exit(1);
		}
		
		
		

		// define training set
		/*
		TabulatedFunctionFitness fitness =
				new TabulatedFunctionFitness(
						new Target().when("x", 1).targetIs(0),
						new Target().when("x", 2).targetIs(3),
						new Target().when("x", 3).targetIs(5),
						new Target().when("x", 4).targetIs(9),
						new Target().when("x", 5).targetIs(13),
						new Target().when("x", 6).targetIs(17));
		*/

		TabulatedFunctionFitness fitness = new TabulatedFunctionFitness(data);

		SymbolicRegressionEngine engine =
				new SymbolicRegressionEngine(
						fitness,
						// define variables
						list("x"),
						// define base functions
						list(Functions.ADD, Functions.MOD, Functions.NOT, Functions.SUB, Functions.MUL, Functions.DIV, Functions.LN,Functions.VARIABLE, Functions.CONSTANT,Functions.BITAND,Functions.BITXOR,Functions.BITOR,Functions.BITSHIFTR,Functions.BITSHIFTL,Functions.TERNARY));
						//list(Functions.VARIABLE,Functions.CONSTANT,Functions.ADD,Functions.SUB,Functions.MOD,Functions.MUL,Functions.POW,Functions.UMINUS));

		addListener(engine);

		// 200 iterations
        do {
            cnt_repeat_fits = 0;
            last_fit = 1e300;
            engine.evolve(1000000);
        } while(Math.abs(last_fit) > 1e-14);
	}

	/**
	 * Track each iteration
	 */
	private static void addListener(SymbolicRegressionEngine engine) {
		engine.addIterationListener(new SymbolicRegressionIterationListener() {
			@Override
			public void update(SymbolicRegressionEngine engine) {

				Expression bestSyntaxTree = engine.getBestSyntaxTree();

				double currFitValue = engine.fitness(bestSyntaxTree);

				// log to console
				System.out.println(
						String.format("iter = %s \t fit = %s \t func = %s",
								engine.getIteration(), currFitValue, bestSyntaxTree.print()));

				// halt condition
				if (currFitValue*currFitValue < 1e-16) {
					engine.terminate();
				}

                if (Math.abs(currFitValue - last_fit)<1e-14) {
                    if(cnt_repeat_fits > 100) {
                        engine.terminate();
                        return;
                    }
                    ++cnt_repeat_fits;
                } else {
                    last_fit = currFitValue;
                }
			}
		});
	}

	private static <T> List<T> list(T... items) {
		List<T> list = new LinkedList<T>();
		for (T item : items) {
			list.add(item);
		}
		return list;
	}
}
