//
// dipflip.h
//
// DIP Flip Whixr Trick
//
// This file contains code for the Microchip PIC12F629/675 for CCS PIC C (PCM)
//
// Joe Grand, Grand Idea Studio, Inc. (http://www.grandideastudio.com)
//
// Distributed under a Creative Commons Attribution-3.0 United States
// https://creativecommons.org/licenses/by/3.0/us/
//

#ifndef __INC_H__
#define __INC_H__

#include <12F629.h>
#use delay(clock=4000000)

// Configuration Bits:
// Oscillator = Internal RC, I/O on GP4/GP5
// Watchdog Timer (WDT) = DISABLED
// Power-Up Timer = ENABLED
// Master Clear = DISABLED (Functions as GP3 input)
// Brown-out Detect = DISABLED
// Code Protect = DISABLED
// Data Code Protect = DISABLED
#fuses INTRC_IO, NOWDT, PUT, NOMCLR, NOBROWNOUT, NOPROTECT, NOCPD

// definitions
#define MODE_NORMAL		1
#define MODE_ALTERNATE	0

// function prototypes
void hardware_init (void);

// from CCS PCM stdlib.h
void srand(unsigned int32);
unsigned int16 rand(void);

#endif
