//
// main.c
//
// DIP Flip Whixr Trick
//
// This file contains code for the Microchip PIC12F629/675 for CCS PIC C (PCM)
//
// Joe Grand, Grand Idea Studio, Inc. (http://www.grandideastudio.com)
//
// Distributed under a Creative Commons Attribution-3.0 United States
// https://creativecommons.org/licenses/by/3.0/us/
//

#include "dipflip.h"

void main (void)
{
	hardware_init();

	switch (input(PIN_A1)) // orientation detection
	{
		case MODE_NORMAL:
    		#use rs232(baud=9600, bits=8, parity=N, stop=1, xmit=PIN_A0, force_sw)
			while(input(PIN_A4)); // wait for a state change indicating a keypress (idle high)
			srand(get_timer0()); // seed random number generator with current value of timer0
			printf("\n\n");
			while(1)
			{	
				//printf("A ");
				printf("%X", (unsigned int8)rand());
				delay_ms(10);
			}
			break;
		case MODE_ALTERNATE:
			#use rs232(baud=9600, bits=8, parity=N, stop=1, xmit=PIN_A4, force_sw)
			while(input(PIN_A0)); // wait for a state change indicating a keypress (idle high)
			srand(0xAC); // seed random number generator with fixed/known value
			printf("\n\n");
			while(1)
			{	
				//printf("B ");
    			printf("%X", (unsigned int8)rand());
				delay_ms(10);
			}
			break;
	}
}

/**************************************************************/
// from CCS PCM stdlib.h

#ifndef RAND_MAX
#define RAND_MAX  32767    // The value of which is the maximum value
                           // ... returned by the rand function
#endif
unsigned int32 _Randseed;

unsigned int16 rand(void)
{
   _Randseed = _Randseed * 1103515245 + 12345;
   return ((unsigned int16)(_Randseed >> 16) % RAND_MAX);
}

void srand(unsigned int32 seed)
{
   _Randseed = seed;
}

/**************************************************************/

void hardware_init (void) // Configure hardware to a known state
{
    disable_interrupts(GLOBAL);

	// setup port pins
	input(PIN_A0);
	input(PIN_A2); // set pin to input, as it may be connected to VDD if flipped
	input(PIN_A3); // set pin to input, as it may be connected to VSS if flipped
	input(PIN_A5); // can be used as an alternate input for orientation detection

	// setup peripherals
    setup_timer_0(T0_INTERNAL | T0_DIV_2); // setup timer (used for seeding the prng)
	setup_timer_1(T1_DISABLED);
	setup_comparator(NC_NC_NC_NC);
	port_a_pullups(FALSE);
	//setup_adc(ADC_OFF); // pic12f675 only
	//setup_adc_ports(NO_ANALOGS);

	delay_ms(250); // power-up delay
}

