/* remd5.c: mangle files produced by fastcoll without changing MD5
 *
 * Copyright (c) 2017 Mako
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "md5.h"
#include <time.h>
#include <assert.h>
#include <stdio.h>
#include <string.h>


int main(int argc, char** argv) {
  int n, m, off = 0;
  uint32_t block0[16], block1[16];
  uint32_t state[4] = { 0x67452301,0xefcdab89,0x98badcfe,0x10325476  };
  if(argc != 3) {
    printf("Usage: %s <in> <out>\n", argv[0]);
    return 1;
  }
  FILE *fin = fopen(argv[1],"rb");
  if(fin == NULL) { printf("couldn't open input\n"); return 1; }
  FILE *fout = fopen(argv[2],"wb");
  if(fout == NULL) { printf("couldn't open output\n"); return 1; }
  n = fread(block0, 1, 64, fin);
  if(n != 64) { printf("couldn't read first block \n"); return 1; }
  off += n;
  for(;;) {
    n = fread(block1, 1, 64, fin);
    if(n < 64) {
      m = fwrite(block0, 1, 64, fout);
      if(m != 64) { printf("couldn't write block\n"); return 1; }
      m = fwrite(block1, 1, n, fout);
      if(m != n) { printf("couldn't write block\n"); return 1; }
      fclose(fin); fclose(fout); return 0;
    }

    uint32_t stateA[4], stateB[4];
    memcpy(stateA, state, 16);
    memcpy(stateB, state, 16);

    MD5Transform(stateA, block0);
    MD5Transform(stateA, block1);
    block0[4] += 1U<<31;
    block0[11] += 1U<<15;
    block0[14] += 1U<<31;
    block1[4] -= 1U<<31;
    block1[11] -= 1U<<15;
    block1[14] -= 1U<<31;
    MD5Transform(stateB, block0);
    MD5Transform(stateB, block1);
    if(stateA[0] != stateB[0] || stateA[1] != stateB[1] ||
       stateA[2] != stateB[2] || stateA[3] != stateB[3]) {
      block0[4] -= 1U<<31;
      block0[11] -= 1U<<15;
      block0[14] -= 1U<<31;
      block1[4] += 1U<<31;
      block1[11] += 1U<<15;
      block1[14] += 1U<<31;
    }
    
    MD5Transform(state, block0);
    m = fwrite(block0, 1, 64, fout);
    if(m != 64) { printf("couldn't write block\n"); return 1; }
    memcpy(block0, block1, 64);
  }
}
