/*
 * $Id: discover_dispatch.h,v 1.2 2002/12/22 19:59:56 skyper Exp $
 */

#ifndef __THCRUT_SCANNER_DISPATCH_H__
#define __THCRUT_SCANNER_DISPATCH_H__ 1

#include <pcap.h>
#include "state.h"

struct _state_fp
{
	struct _state state;

	union _un
	{
		void *ptr;  /* NMAP results */
		char turn;  /* Turn         */
	} un;
	int sox; /* fixme: this only needs to be 10 bits */
	unsigned short port;  /* tcp, HBO */
	unsigned char flags;
	unsigned char testnr:5; /* number in that category           */
	unsigned char cat:3;    /* category: TCP, UDP, Banner or WWW */
	char results[0];
};
#define STATE_FOUND_OPEN_PORT   (0x01)
#define STATE_CRLF_SENT		(0x02)

void dis_timeout(struct _state *state);
void scanner_filter(unsigned char *u, struct pcap_pkthdr *p, unsigned char *packet);

#endif /* !__THCRUT_SCANNER_DISPATCH_H__ */
