/*
 * $Id:$
 */

#include "nvt.h"

#define IACFOUND        0x01
#define DOFOUND         0x02
#define UNKNOWNOPT      0x04
#define SUBNEGO         0x08
#define CRFOUND         0x10

/*
 * Input:
 *   data of raw NVT data of lenght len.
 *
 * Output:
 *   ans is the proposed answer to the NVT request of lenght alen.
 *   rem is the remaining data of length rlen.
 *
 * Requirement
 *   ans and rem must be at least len bytes in size.
 *
 * return 0 on success.
 */
int
NVT_decode(char *data, int len, char *ans, int *alen, char *rem, int *rlen)
{
	char *ptr = data;
	char flags = 0;
	unsigned char c;

	*rlen = 0;
	*alen = 0;

	while (1)
	{
		if (len-- <= 0)
			break;
		c = *ptr++;

		if (flags & UNKNOWNOPT)
		{
			flags = 0;
			continue;
		}

		if (flags & IACFOUND)
		{
			if (c == NVT_IAC)  /* IAC IAC */
			{
				*rem++ = NVT_IAC;
				flags = 0;
				continue;
			}

			if (flags & SUBNEGO)
			{
				if (c == NVT_SE)
					flags = 0;
				continue;
			}

			if (flags & DOFOUND)
			{
				*ans++ = NVT_IAC;
				*ans++ = NVT_WONT;  /* me is dump */
				*ans++ = c;
				*alen = *alen + 3;
				flags = 0;
				continue;
			}

			if (c == NVT_SB) /* sub-negotiation */	
			{
				flags = SUBNEGO;
				continue;
			}

			if (c == NVT_DO)
			{
				flags |= DOFOUND;
				continue;
			} else {
				flags = ~(IACFOUND | DOFOUND);
				flags |= UNKNOWNOPT; /* skip next */
				continue;
			}
		} /* IACFOUND */

		if (flags & SUBNEGO)
			continue;

		if (c == NVT_IAC)
		{
			flags = IACFOUND;   /* first IAC */
			continue;
		}

		if (flags & CRFOUND)
		{
			if (c == '\0')
			{
				flags &= ~CRFOUND;
				*rem++ = '\r';
				*rlen = *rlen + 1;
				continue;
			}
			if (c == '\n')
			{
				flags &= ~CRFOUND;
				*rem++ = '\n';
				*rlen = *rlen + 1;
				continue;
			}
		}

		if (c == '\r')
		{
			flags |= CRFOUND;
			continue;
		}

		*rem++ = c;
		*rlen = *rlen + 1;
	}

	return 0;
}


