#ifndef THCRUT_RANGE_H
#define THCRUT_RANGE_H 1

#ifndef ETH_ALEN
#define ETH_ALEN               6
#endif

struct _bmac
{
    unsigned char  start_mac[ETH_ALEN];
    unsigned char  saved_sm[ETH_ALEN];
    unsigned char  end_mac[ETH_ALEN];
    unsigned char  saved_em[ETH_ALEN];
    unsigned char  current[ETH_ALEN];
    unsigned char  ltag;       /* left tag value */
    unsigned char  saved_ltag;
    unsigned char  firstround; /* err..dirty */
    unsigned long  count;   /* -1 means REALLY MANY, 1 is min. value */
};

struct _bip
{
    unsigned long  start_ip;       /* HBO */
    unsigned long  end_ip;         /* HBO */
    unsigned long  current;        /* HBO */
};

struct _ipranges
{
	char **argv;
	unsigned long start_ip;
	unsigned long end_ip;
	unsigned long current_ip;
};

#define IP_current(ipr)  (ipr)->current_ip
#define IP_init(ipr, myargv) do{ memset((ipr), 0, sizeof(struct _ipranges)); (ipr)->argv = myargv;}while(0)
#define IP_end(ipr)    (((ipr)->argv[0] == NULL) && ((ipr)->current_ip >= (ipr)->end_ip))

/*
 * We like to have that one FAST ;>
 */
#define IP_next(ipr) do{ \
	char *ptr; \
	char buf[16]; \
	unsigned char len; \
	if ((ipr)->current_ip >= (ipr)->end_ip) \
	{ \
		if ((ipr)->argv[0] == NULL) \
		{ \
			(ipr)->current_ip = 0; \
			(ipr)->end_ip = 0; \
			break; \
		} \
		ptr = strchr((ipr)->argv[0], '-'); \
		if (ptr) \
		{ \
			len = MIN(sizeof buf - 1, ptr - (ipr)->argv[0]); \
			memcpy(buf, (ipr)->argv[0], len); \
			buf[len] = '\0'; \
			(ipr)->end_ip = ntohl(inet_addr(++ptr)); \
			ptr = buf; \
		} else { \
			(ipr)->end_ip = 0; \
			ptr = (ipr)->argv[0]; \
		} \
		(ipr)->start_ip = ntohl(inet_addr(ptr)); \
		(ipr)->current_ip = (ipr)->start_ip; \
		(ipr)->argv++; \
	} else \
		(ipr)->current_ip++; \
}while(0)


int init_next_ip(char *, struct _bip *);
int init_next_mac(unsigned char *, struct _bmac *);
int reset_next_mac(struct _bmac *);
unsigned long *next_ip(struct _bip *, unsigned long *);
unsigned char *next_mac(struct _bmac *);

#endif /* !THCRUT_RANGE_H */
