/*
 * $Id: state.c,v 1.5 2002/12/22 19:59:56 skyper Exp $
 *
 * ChangeLog
 * - added variable length state support (struct _state_* ).
 */


#include "default.h"
#include <sys/time.h>
#include <sys/types.h>
#if 0
#include <sys/ipc.h>
#include <sys/shm.h>
#endif
#include <netinet/in.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "state.h"
//#include "network_raw.h"

#define STATE_HASH(sq, ip) (ip & (sq)->hash_entry_mask)
// FIXME: debugging
//#define STATE_HASH(sq, ip) 0

/*
 * Initialize a state queue
 */
#define BIT_HASH    (10)
struct _state_queue *
SQ_init(struct _state_queue *sq, unsigned long nitems, size_t item_size, int fd, cb_timeout_t cb_timeout, cb_filter_t cb_filter)
{
	int size;

	item_size = (item_size + 3) & ~3; /* Align to 4 bytes */

	if (nitems > 500000)
		nitems = 500000;
	sq->epoch = 1000000 / nitems; /* length of on epoch in ms */

	size = nitems * item_size + (1 << BIT_HASH) * sizeof(struct _state *);
	/* Hash size must be one of 2^n */
	sq->hash_entry_mask = (1 << BIT_HASH) - 1;
	sq->n_entries = nitems;
	sq->current = 0;
	sq->item_size = item_size;
	sq->cb_timeout = cb_timeout;
	sq->cb_filter = cb_filter;
	sq->fd = fd;

//	sq->shmid = shmget(IPC_PRIVATE, size, SHM_R | SHM_W);
	//sq->shmid = shmget(IPC_PRIVATE, size, IPC_CREAT | IPC_EXCL | SHM_R | SHM_W);
	sq->hash = malloc(size); //shmat(sq->shmid, NULL, 0);
	if (!sq->hash)
		return NULL;
	memset(sq->hash, 0, size);
	sq->queue = (struct _state *)(sq->hash + (1 << BIT_HASH));

//	if (1 != ntohl(1))
//		sq->hash_fix = (char)(sizeof(long) - BIT_HASH);

	gettimeofday(&sq->expect, NULL);

	return sq;
}

void
STATE_deinit(struct _state_queue *sq)
{
	XFREE(sq->hash);
#if 0
	if (sq->shmid)
		shmctl(sq->shmid, IPC_RMID, 0);
	sq->shmid = 0;
#endif
}

/*
 * IP is in HBO
 */
struct _state *
STATE_by_ip(struct _state_queue *sq, unsigned long ip)
{
	struct _state *state = sq->hash[STATE_HASH(sq, ip)];
	int i = 0;

	while (state)
	{
		i++;
		if (state->ip == ip)
			break;
		state = state->next;
	}
//	fprintf(stderr, "Elements in hash colum: %d\n", i);

	return state;
};

/*
 * Only called by sending process
 *
 * One might think that here is a race condition, but
 * this wrong: The element we unlink is the last element of
 * the hash list. New elements are always inserted at the top.
 * The last one is thus the oldest. Relinking becomes
 * very easy as we only have to set the next pointer of the previous
 * item to NULL (to make it become the last).
 */
void
STATE_link(struct _state_queue *sq, struct _state *state)
{
	unsigned int idx;

	idx = STATE_HASH(sq, state->ip);

	/* Link */
	state->prev = NULL;
	state->next = sq->hash[idx];
	if (state->next)
		state->next->prev = state;

	sq->hash[idx] = state;
}

void
STATE_unlink(struct _state_queue *sq, struct _state *state)
{
	unsigned int idx;

	if (state->prev == NULL)
	{
		if (state->ip == 0)
			return; /* Not linked at all! */
		idx = STATE_HASH(sq, state->ip);
		sq->hash[idx] = state->next; /* NULL usually */
	} else
		state->prev->next = state->next; /* NULL usually */

#if 0
	/* Should not happen, we always remove the last element */
	if (state->next)
		state->next->prev = state->prev;
#endif
}


void cb_filter(void);
static void
state_select(struct _state_queue *sq)
{
	struct timeval now, diff;
	fd_set rfds;

	gettimeofday(&now, NULL);
	SQ_TV_add(&sq->expect, 0, sq->epoch);
	SQ_TV_diff(&diff, &now, &sq->expect);

	while (diff.tv_usec >= 0)
	{
		FD_ZERO(&rfds); /* FIXME */
		FD_SET(sq->fd, &rfds);
		if (select(sq->fd + 1, &rfds, NULL, NULL, &diff) <= 0)
			break;

		sq->cb_filter();
		gettimeofday(&now, NULL);
		SQ_TV_diff(&diff, &now, &sq->expect);
	}
}

/*
 * SQ must be init first
 * FIXME: determine when to exit.
 * - Set STATE_reset decrement n_inuse and check in select loop
 *   if it dropped to 0.
 */
int
STATE_wait(struct _state_queue *sq, struct _state *nextstate)
{
	struct _state *state;

	SQ_next(state, sq);

start:
	if (!STATE_current(state))
	{
fillagain:
		if (nextstate)
		{
			STATE_unlink(sq, state);
	 		memcpy(state, nextstate, sq->item_size);
			STATE_link(sq, state);
			//DEBUGF("FIXME Fist invokation of dis_timeout.\n");
			sq->cb_timeout(state);
			/* Didnt switched state? */
			if (state->current)
				sq->n_inuse = sq->n_entries;
			state_select(sq);
			return 0;
			SQ_next(state, sq);
			goto start;
		} else {
			sq->n_inuse--;
			if (sq->n_inuse <= 0)
				return -1;   /* FINISHED */
			state_select(sq);
			SQ_next(state, sq);
			goto start;
		}
	} else { /* Current state is set and waited 1 sec */
		sq->n_inuse = sq->n_entries;
		if (state->reschedule)
		{
			state->reschedule = 0;
			state_select(sq);
			SQ_next(state, sq);
			goto start;
		} else {
			sq->cb_timeout(state);
			if ((!state->current) && (nextstate == NULL) && (sq->n_inuse <= 1))
				return -1;
			/*
			 * Instantly reused if a slot became free.
			 * Otherwise put it back and sniff a round.
			 */
			if (state->current)
			{
				state_select(sq);
				SQ_next(state, sq);
				goto start;
			}
			goto fillagain;
		}
	}

	return -1; /* Not reached */
}

