/*
 * $Id:$
 */

#include <stdio.h>

static unsigned char esctable[] = "\x80\x80\x80\x80\x80\x80\x80\x80\x80\x89\x8A\x80\x80\x8D\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80 \xA1\xA2#\xA4%&'\xA8\xA9\xAA\xAB,-\xAE/0123456789:;<=>\xBF@ABCDEFGHIJKLMNOPQRSTUVWXYZ\xDB\xDC]\xDE_`abcdefghijklmnopqrstuvwxyz\xFB\xFC}~\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80";


/*
 * Convert a (binary) string into a perl style string.
 *
 * Input:
 *    src and slen are the source and length to be translated.
 *     
 *  Output:
 *    dst and dlen are destionation and max. destination length.
 *
 *  Return:
 *    Number of chars placed into dst. dst will be \0 terminated.
 *
 *  Warning:
 *    This is not exactly a perl like string. We also escape " here.
 */
int
perlstring(char *dst, int dlen, char *src, int slen)
{
	unsigned char s;
	char *start = dst;
	char *end = dst + dlen;

	while ((slen-- > 0) && (dst + 4 < end))
	{
		s = *src++;
		if (esctable[s] == 0x80)
		{
			snprintf(dst, dlen, "\\x%2.2x", s);
			dst += 4;
			continue;
		}

		/*
		 * Escape the following chars:
		 * \ | ( ) [ { ^ $ * + ? . "
		 *
		 * Where " is the non-perl critical character.
		 */
		if (esctable[s] > 0x80)
		{
			*dst++ = '\\';
			*dst++ = esctable[s] - 0x80;
			continue;
		}

		*dst++ = s;
	}

	*dst = '\0';

	return dst - start;
}

void
hexdump(unsigned char *data, size_t len)
{
        size_t n = 0;
	int line = 0;

	if (!len)
		return;

	fprintf(stderr, "%03x: ", line++);
	while (1)
	{
		fprintf(stderr, "%2.2x ", data[n++]);
		if (n >= len)
			break;
		if (n % 8 == 0)
			fprintf(stderr, " - "); 
		if (n % 16 == 0)
			fprintf(stderr, "\n%03x: ", line++);
	}
	fprintf(stderr, "\n");
}

