/*
 * $Id:$
 */

#include <libnet.h>

struct libnet_link_int *
init_libnet(char **device)
{
	char err_buf[LIBNET_ERRBUF_SIZE];
	struct libnet_link_int *network;
	char *mydev = NULL;

	if ((device == NULL) || (*device == NULL))
	{
		struct sockaddr_in sin;

		if (libnet_select_device(&sin, &mydev, err_buf) == -1)
			libnet_error(LIBNET_ERR_FATAL, "libnet_select_device: %s\n", err_buf);
	}

	network = libnet_open_link_interface(mydev, err_buf);
	if (!network)
		libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_interface: %s\n", err_buf);

	if (device)
		*device = mydev;

	return network;
}

void
fini_libnet(struct libnet_link_int *network, char *packet)
{
	libnet_close_link_interface(network);
#if 0
	libnet_destroy_packet(packet);
#endif
}

