#!/bin/sh
#
# Part of the THC Wardrive package by van Hauser / THC
# Configures your wvlan
# This needs the wireless-tools.rpm (e.g. from SuSE)
#

#
# load the configuration
#
test -e "wardrive.conf" || { echo "Error: wardrive.conf not found in current directory"; exit 1; }
. wardrive.conf

killall dhcpcd 2> /dev/null
killall dhclient 2> /dev/null

$IWCFG $DEVICE power off
$IWCFG $DEVICE rate auto
$IWCFG $DEVICE nickname "$NAME"
$IWCFG $DEVICE essid any
$IWCFG $DEVICE nwid off 2> /dev/null
$IWCFG $DEVICE mode auto 2> /dev/null || $IWCFG $DEVICE mode $MODE
$IWP $DEVICE roam on 2> /dev/null

ifconfig eth0 down
ifconfig eth0 hw ether "$HWADDR"
ifconfig eth0 0.0.0.0 up

test -x ./sniff_wvlan.sh && ./sniff_wvlan.sh
test -x ./sniff_wvlan.sh || {
    test -x /usr/local/bin/sniff_wvlan.sh && /usr/local/bin/sniff_wvlan.sh
    test -x /usr/local/bin/sniff_wvlan.sh || echo "Error: can not find sniff_wvlan.sh"
}
