#ifndef __ICMP_TUNNEL_HDR
#define __ICMP_TUNNEL_HDR

/*
** defines and global variables used between functions.
*/

#ifndef INADDR_NONE
#define INADDR_NONE   0xFFFFFFFF    /* should be in <netinet/in.h> */
#endif

#define SIZE_ICMP_HDR        8      /* 8-byte ICMP header */
#define MAXMESG           4096      /* max data area */
#define MAXPACKET         5004      /* max packet size */
                                    /* SIZE_ICMP_HDR + MAXMESG */
                                    
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN      64      /* should be defined in <sys/param.h> */
#endif

/*
** Our errno stuff.
*/
extern int  eit_errno;

#define EIT_2BIG            0   /* The message we want to sent is too big to */
                                /* fit into 1 packet */
#define EIT_SENDTO          2   /* sendto() error */
#define EIT_SENDLESS        3   /* sendto() send less bytes as it should */
#define EIT_RECVFROM        5   /* recvfrom() error */
#define EIT_PROTO           6   /* proto ICMP not known */
#define EIT_SOCKET          7   /* cant create icmp socket */

struct sockaddr_in          clisrc;

/*
** Our library functions.
*/
int   tunnel_init(void);
int   tunnel_send(char *send_mesg, size_t mesglen, u_long srv_ip);
int   tunnel_recv(char *recv_mesg, size_t mesglen);
void  tunnel_reset(void);

#endif
