#include "pcaptcp.h"

extern int init_pcap(char *device, char *proto, int snaplen, int to_ms, int promisc)
{
  if(device == NULL)
    if((device = pcap_lookupdev(__errbuf)) == NULL)
      err_mesg(FATAL_SYS, "ERROR: pcap_lookupdev()\nSYSERR");
      
  if((__pdesc = pcap_open_live(device, snaplen, promisc, to_ms, __errbuf)) == NULL)
    err_mesg(FATAL_SYS, "PCAP: %s\nERROR: pcap_open_live()\nSYSERR", __errbuf);
            
  if(pcap_lookupnet(device, &__localnet, &__netmask, __errbuf) < 0)
    err_mesg(FATAL_SYS, "PCAP: %s\nERROR: pcap_lookupnet()\nSYSERR", __errbuf);
                  
  if(pcap_compile(__pdesc, &__filter, proto, 1, __netmask) < 0)
    err_mesg(FATAL, "ERROR: pcap_compile()\n");
                        
  if(pcap_setfilter(__pdesc, &__filter)<0)
    err_mesg(FATAL, "ERROR: pcap_set()\n");

  return(0);
}

extern int readtcp(char *ip, char *tcp, char *load)
{
  u_char              *pcdata;
  struct pcap_pkthdr  pchdr;

reread:
  errno = 0;
  if( (pcdata = (u_char *) pcap_next(__pdesc, &pchdr)) == NULL)
  {
    if(errno == EINTR)
      return(-1);
    if(!errno)
      goto reread;
    pcap_perror(__pdesc, "PCAP");
    err_mesg(FATAL_SYS, "ERROR: pcap_next()\nSYSERR");
  }
  
  if(ip)
    memcpy(ip, pcdata + ETHHDR, IPHDR);
  if(tcp)
    memcpy(tcp, pcdata + ETHHDR + IPHDR, TCPHDR);
  if(load && pchdr.len >= (TCPIPHDR + ETHHDR))
    memcpy(load, pcdata + ETHHDR + TCPIPHDR, pchdr.len - (TCPIPHDR));
  
  return(pchdr.len);
}
