/*
** Copyright 1999 TICK / THC <tick@thehackerschoice.com>
*/

/*
 * This is a temporary solution, since some operation system donnot
 * have such a definition. This should later be done by a configure
 * script or something similar. 
 */
#define NAME_MAX 255

#include <stdio.h>
#include <unistd.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "error.h"
#include "icmp_tunnel.h"
extern int  eit_errno;

#define DEFLOG "./nosetunnel.log"
#define USAGE(prog) \
  err_mesg(FATAL, "\nusage:\t%s [-l <logfile>]\n", prog);

FILE *logfd;


int main(int argc, char **argv)
{
  char    rcvmesg[MAXMESG+1];
  char    fname[NAME_MAX+1] = { 0 };
  int     opt, n;

  opterr = 0;
  while( (opt = getopt(argc, argv, "l::")) != EOF)
  {
    switch(opt)
    {
      case 'l':
        if(optarg[0] == 0)
        {
          USAGE(argv[0])
          exit(-1);
        }
        strncpy(fname, optarg, NAME_MAX);
        break;
      default:
        USAGE(argv[0])
        exit(-1);
    }
  }

  if(!fname[0])
    strcpy(fname, DEFLOG);

  if((logfd = fopen(fname, "a")) == NULL)
    err_mesg(FATAL_SYS, "ERROR: fopen()\nSYSERR");

  while(1)
  {
    memset(rcvmesg, 0, MAXMESG+1);

    if((n = tunnel_recv(rcvmesg, MAXMESG)) < 0 )
      continue;

    fprintf(logfd, rcvmesg);
    fflush(logfd);
  }

  tunnel_reset();

  exit(0);
}
