To log into a tetrifast server with a nickname of `TestUser`, the string we have to send to the server is

    tetrifaster TestUser 1.13

This string has to be encoded as exemplified in the following (python) script. [Some pages](http://www.javafacts.com/jts/protocol.html) claim that you have to use the server IP for deriving `h`, but most servers guess `h` anyway and don't care what IP it comes from or goes to. This script is using the IP `209.52.144.98` as the server IP.
```python
ip = [209, 52, 144, 98]  # list of ints
reg_str = 'tetrifaster TestUser 1.13'
h = str(54 * ip[0] + 41 * ip[1] + 29 * ip[2] + 17 * ip[3])
dec = randrange(256)  # random value between 0 <= x < 256
encoded = '{:02X}'.format(dec)
for i, c in enumerate(reg_str):
    dec = ((dec + ord(c)) % 255) ^ ord(h[i % len(h)])
    encoded += '{:02X}'.format(dec)
```
For an initial random value of `dec=128`, this yields the encoded string `80C512B4114A81DB7DC71DBEE70E4588CD1ABF13B5E42F6F96F9`.