/* 6811 family memory map */

#ifndef M6811_H
#define M6811_H

/*
 * Number of internal regs in register block
 */
#define NIREGS		0x40		/* 64 */

/*
 * Generated by program equ2define (c) Arne Riiber
 */

/*******************************************/
/*	68HC11 INTERNAL REGISTERS	***/
/*	  J P SOMERS   05/01/87		***/
/*******************************************/
/*     DEFINITIONS */

#define REGS 0x1000

/*
 * Offsets from register block base address (normally 0x1000)
 */
/*  PORT A DATA REGISTER */
#define PORTA 0x00

#define RESVD 0x01

/*  PARALLEL I/O CONTROL REGISTER */
#define PIOC 0x02

/* STROBE A FLAG */
/*  0= INACTIVE */
/*  1= SET AT ACTIVE EDGE OF STRA PIN */
#define STAF 0x80

/* STROBE A INTERRUPT ENABLE */
/*  0= NO HARDWARE INTERRUPT GENERATED */
/*  1= HARDWARE INTERRUPT REQ WHEN STAF=1 */
#define STAI 0x40

/* PORT C WIRE-OR MODE */
/*  0= PORT C OUTPUTS NORMAL */
/*  1= OPEN DRAIN */
#define CWOM 0x20

/* HANDSHAKE/SIMPLE STROBE MODE SELECT */
/*  0= SIMPLE STROBE MODE */
/*  1= FULL HANDSHAKE MODES */
#define HNDS 0x10

/* OUTPUT/INPUT HANDSHAKE SELECT */
/*  0= INPUT */
/*  1= OUTPUT */
#define OIN 0x08

/* PULSE MODE SELECT FOR STRB OUTPUT */
/*  0= STRB LEVEL ACTIVE */
/*  1= STRB PULSES */
#define PLS 0x04

/* ACTIVE EDGE SELECT FOR STRA */
/*  0= HI TO LO (FALLING) */
/*  1= LO TO HI (RISING) */

#define EGA 0x02
/* INVERT STRB OUTPUT */
/*  0= STRB ACTIVE LOW */
/*  1= STRB ACTIVE HIGH */
#define INVB 0x01

/*  PORT C DATA REGISTER */
#define PORTC 0x03

/*  PORTB DATA REGISTER */
#define PORTB 0x04

/*  PORT C LATCHED DATA REGISTER */
#define PORTCL 0x05

#define RESVD1 0x06

/*  DATA DIRECTION REGISTER FOR PORT C */
#define DDRC 0x07

/*  PORT D DATA REGISTER */
#define PORTD 0x08

/*  DATA DIRECTION REGISTER FOR PORT D */
#define DDRD 0x09

/*  PORT E DATA REGISTER */
#define PORTE 0x0a

/*  TIMER COMPARE FORCE REGISTER */
#define CFORC 0x0b
#define FOC1 0x80
#define FOC2 0x40
#define FOC3 0x20
#define FOC4 0x10
#define FOC5 0x08

/*  OUTPUT COMPARE 1 MASK REGISTER */
#define OC1M 0x0c
#define OC1M7 0x80
#define OC1M6 0x40
#define OC1M5 0x20
#define OC1M4 0x10
#define OC1M3 0x08

/*  OUTPUT COMPARE 1 DATA REGISTER */
#define OC1D 0x0d
#define OC1D7 0x80
#define OC1D6 0x40
#define OC1D5 0x20
#define OC1D4 0x10
#define OC1D3 0x08

/*  TIMER COUNTER REGISTER (2 BYTES) */
#define TCNT 0x0e

/*  TIMER INPUT CAPTURE REGISTERS (3 REGS, 6 BYTES) */
#define TIC1 0x10
#define TIC2 0x12
#define TIC3 0x14

/*  TIMER OUTPUT COMPARE REGISTERS (5 REGS, 10 BYTES) */
#define TOC1 0x16
#define TOC2 0x18
#define TOC3 0x1a
#define TOC4 0x1c
#define TOC5 0x1e

/*  TIMER CONTROL REGISTER 1 */
#define TCTL1 0x20
/*  OMx  OLx  ACTION UPON SUCCESSFUL COMPARE */
/*   0    0    TIMER DISC FROM OUTPUT PIN */
/*   0    1    TOGGLE OCx OUTPUT LINE */
/*   1    0    CLEAR OCx OUTPUT LINE TO ZERO */
/*   1    1    SET OCx OUTPUT LINE TO ONE */
#define OM2 0x80
#define OL2 0x40
#define OM3 0x20
#define OL3 0x10
#define OM4 0x08
#define OL4 0x04
#define OM5 0x02
#define OL5 0x01

/*  TIMER CONTROL REGISTER 2 */
#define TCTL2 0x21
/* EDGxB EDGxA  CONFIGURATION */
/*   0     0    CAPTURE DISABLED */
/*   0     1    CAPTURE ON RISING EDGES ONLY */
/*   1     0    CAPTURE ON FALING EDGES ONLY */
/*   1     1    CAPTURE ON ANY EDGE (RISING OR FALLING) */
#define EDG1B 0x20
#define EDG1A 0x10
#define EDG2B 0x08
#define EDG2A 0x04
#define EDG3B 0x02
#define EDG3A 0x01

/*  MAIN TIMER INTERRUPT MASK REG 1 */
#define TMSK1 0x22
#define OC1I 0x80
#define OC2I 0x40
#define OC3I 0x20
#define OC4I 0x10
#define OC5I 0x08
#define IC1I 0x04
#define IC2I 0x02
#define IC3I 0x01

/*  MAIN TIMER INTERRUPT FLAG REG 1 */
#define TFLG1 0x23
#define OC1F 0x80
#define OC2F 0x40
#define OC3F 0x20
#define OC4F 0x10
#define OC5F 0x08
#define IC1F 0x04
#define IC2F 0x02
#define IC3F 0x01

/*  MISC TIMER INTERRUPT MASK REG 2 */
#define TMSK2 0x24
/* TIMER OVERFLOW INTERRUPT ENABLE */
#define TOI 0x80
/* RTI INTERRUPT ENABLE */
#define RTII 0x40
/* PULSE ACCUMULATOR OVERFLOW INTERRUPT ENABLE */
#define PAOVI 0x20
/* PULSE ACCUMULATOR INPUT INTERRUPT ENABLE */
/*  0= INTERRUPT INHIBITED */
/*  1= INTERRUPT REQUESTED IF FLAG SET */
#define PAII 0x10
/* PR1  PR2  PRESCALE FACTOR */
/*  0    0      1 */
/*  0    1      4 */
/*  1    0      8 */
/*  1    1     16 */
#define PR1 0x02
#define PR0 0x01

/*  MISC TIMER INTERRUPT FLAG REG 2 */
#define TFLG2 0x25
/* TIMER OVERFLOW FLAG */
#define TOF 0x80
/* REAL TIME (PERIODIC) INTERRUPT FLAG */
#define RTIF 0x40
/* PULSE ACCUMULATOR OVERFLOW FLAG */
#define PAOVF 0x20
/* PULSE ACCUMULATOR INPUT EDGE FLAG */
#define PAIF 0x10

/*  PULSE ACCUMULATOR CONTROL REGISTER */
#define PACTL 0x26
/* DATA DIRECTION FOR PA7 */
/*  0= INPUT */
/*  1= OUTPUT */
#define DDRA7 0x80
/* PULSE ACCUMULATOR SYSTEM ENABLE */
/*  0= DISABLED */
/*  1= ENABLED */
#define PAEN 0x40
/* PULSE ACCUMULATOR MODE */
/*  0= EVENT COUNTER */
/*  1= GATED TIME ACCUMULATION */
#define PAMOD 0x20
/* PULSE ACCUMULATOR EDGE CONTROL */
/*  0= FALLING EDGES, HIGH LEVEL ENABLES ACCUM */
/*  1= RISING EDGES, LOW LEVEL ENABLES ACCUM */
#define PEDGE 0x10
/* RTI INTERRUPT RATE */
/*  RTR1 RTR0  DIV E BY */
/*   0    0     2^13 */
/*   0    1     2^14 */
/*   1    0     2^15 */
/*   1    1     2^16 */
#define RTR1 0x02
#define RTR0 0x01

/*  PULSE ACCUMULATOR COUNT REGISTER */
#define PACNT 0x27

/*  SPI CONTROL REGISTER */
#define SPCR 0x28
/* SPI INTERRUPT ENABLE */
#define SPIE 0x80
/* SPI SYSTEM ENABLE */
#define SPE 0x40
/* PORT D WIRE-OR MODE */
/*  0=PORT D OUTPUTS NORMAL */
/*  1=OPEN DRAIN */
#define DWOM 0x20
/* MASTER/SLAVE MODE SELECT */
/*  0=SLAVE MODE */
/*  1=MASTER MODE */
#define MSTR 0x10
/* CLOCK POLARITY */
#define CPOL 0x08
/* CLOCK PHASE */
#define CPHA 0x04
/* SPI CLOCK (SCK) RATE BIT */
/*  SPR1 SPR0  E DIV BY */
/*   0    0       2 */
/*   0    1       4 */
/*   1    0       16 */
/*   1    1       32 */
#define SPR1 0x02
#define SPR0 0x01

/*  SPI STATUS REGISTER */
#define SPSR 0x29

/* SPI INTERRUPT REQUEST */
#define SPIF 0x80
/* WRITE COLLISION STATUS FLAG */
#define WCOL 0x40
/* SPI MODE ERROR INTERRUPT STATUS FLAG */
#define MODF 0x10

/*  SPI DATA REGISTER */
#define SPDR 0x2a

/*  SCI BAUD RATE CONTROL REGISTER */
#define BAUD 0x2b
/* CLEAR BAUD COUNTER CHAIN (TEST ONLY) */
#define TCLR 0x80
/* SERIAL PRESCALER SELECTS */
/*  SCP1 SCP0  DIV E BY */
/*   0    0       1 */
/*   0    1       3 */
/*   1    0       4 */
/*   1    1      13 */
#define SCP1 0x20
#define SCP0 0x10
/* SCI BAUD RATE CLOCK TEST (TEST ONLY) */
#define RCKB 0x08
/* SCI RATE SELECT BIT 2 THRU BIT 0 */
/*  SCR2 SCR1 SCR0  PRESC OUT DIV BY */
/*   0    0    0          1 */
/*   0    0    1          2 */
/*   0    1    0          4 */
/*   0    1    1          8 */
/*   1    0    0         16 */
/*   1    0    1         32 */
/*   1    1    0         64 */
/*   1    1    1        128 */
#define SCR2 0x04
#define SCR1 0x02
#define SCR0 0x01

/*  SCI CONTROL REGISTER 1 */
#define SCCR1 0x2c
/* RECEIVE BIT 8 */
#define R8 0x80
/* TRANSMIT BIT 8 */
#define T8 0x40
/* MODE SELECT */
/*  0 = 1 START, 8 DATA, 1 STOP */
/*  1 = 1 START, 8 DATA, 9TH DATA, 1 STOP BIT */
#define M 0x10
/* WAKE = WAKE UP (BY ADDRESS MARK/IDLE) */
/*  0 = WAKE UP BY IDEL LINE */
/*  1 = WAKE UP BY ADDRESS MARK */
#define WAKE 0x08
/*  SCI CONTROL REGISTER 2 */

#define SCCR2 0x2d
/* TRANSMIT INTERRUPT ENABLE */
#define TIE 0x80
/* TRANSMIT COMPLETE INTERRUPT ENABLE */
#define TCIE 0x40
/* RECEIVER INTERRUPT ENABLE */
#define RIE 0x20
/* IDLE LINE INTERRUPT ENABLE */
/*  0=INHIBIT INTERRUPTS */
/*  1=ENABLE INTERRUPTS */
#define ILIE 0x10
/* TRANSMITER ENABLE (TOGGLE TO QUEUE IDLE CHAR) */
#define TE 0x08
/* RECEIVER ENABLE */
/*  0=OFF */
/*  1=ON */
#define RE 0x04
/* RECEIVER WAKE-UP CONTROL */
/*  0=NORMAL */
/*  1=RECEIVER ASLEEP */
#define RWU 0x02
/* SEND BREAK */
#define SBK 0x01

/*  SCI STATUS REGISTER */
#define SCSR 0x2e
/* TRANSMIT DATA REG EMPTY FLAG */
#define TDRE 0x80
/* TRANSMIT COMPLETE FLAG */
#define TC 0x40
/* RECEIVE DATA REG FULL FLAG */
#define RDRF 0x20
/* IDLE LINE DETECTED FLAG */
#define IDLE 0x10
/* OVER-RUN ERROR FLAG */
#define OR 0x08
/* NOISE ERROR FLAG */
#define NF 0x04
/* FRAMING ERROR FLAG */
#define FE 0x02
/*  SCI DATA REGISTER */

/* RECEIVE AND TRANSMIT DOUBLE BUFFERED */
#define SCDR 0x2f

/*  A/D CONTROL/STATUS REGISTER */
#define ADCTL 0x30
/* CONVERSIONS COMPLETE FLAG (SETS AFTER 4TH CONVERSION) */
#define CCF 0x80
/* CONTINUOUS SCAN CONTROL */
/*  0=4 CONVERSIONS AND STOP */
/*  1=CONVERT CONTINUOUSLY */
#define SCAN 0x20
/* MULTIPLE CHANNEL/SINGLE CHANNEL CONTROL */
/*  0=CONVER SINGLE CHANNEL */
/*  1=CONVERT FOUR CHANNEL GROUP */
#define MULT 0x10
/*  CD  CC  CB  CA    CHANNEL SIGNAL  RESULT IN ADRX */
/*-------------------------------------------------- */
/*  0   0   0   0     ADO PORT E0	ADR1 */
/*  0   0   0   1     ADO PORT E1	ADR2 */
/*  0   0   1   0     ADO PORT E2	ADR3 */
/*  0   0   1   1     ADO PORT E3	ADR4 */
/*  0   1   0   0     ADO PORT E4	ADR1 */
/*  0   1   0   1     ADO PORT E5	ADR2 */
/*  0   1   1   0     ADO PORT E6	ADR3 */
/*  0   1   1   1     ADO PORT E7	ADR4 */
/*  1   0   0   0     RESERVED		ADR1 */
/*  1   0   0   1     RESERVED		ADR2 */
/*  1   0   1   0     RESERVED		ADR3 */
/*  1   0   1   1     RESERVED		ADR4 */
/*  1   1   0   0     VREF HI		ADR1 */
/*  1   1   0   1     VREF LOW		ADR2 */
/*  1   1   1   0     VREF HI/2		ADR3 */
/*  1   1   1   1     TEST/RESERVED	ADR4 */
#define CD 0x08
#define CC 0x04
#define CB 0x02
#define CA 0x01

/*  A/D RESULT REGISTERS */
#define ADR1 0x31
#define ADR2 0x32
#define ADR3 0x33
#define ADR4 0x34
#define RESVD2 0x35
#define RESVD3 0x36
#define RESVD4 0x37
#define RESVD5 0x38

/*  SYSTEM CONFIGURATION OPTIONS */
#define OPTION 0x39
/* A TO D POWER UP */
/*  0= A/D SYSTEM POWERED DOWN */
/*  1= A/D SYSTEM POWERED UP */
#define ADPU 0x80
/* CLOCK SELECT */
/* SHOULD BE USED IF E LESS THAN 1MHZ */
/*  0= A/D & EE USE SYSTEM E CLOCK */
/*  1= A/D & EE USE AN INTERNAL R-C CLOCK */
#define CSEL 0x40
/* IRQ SELECT EDGE SENSITIVE ONLY (TIME PROTECTED) */
/*  0= IRQ CONFIGURED FOR LOW LEVEL */
/*  1= IRQ CONFIGURED FOR FALLING EDGES */
#define IRQE 0x20
/* ENABLE OSCILATOR START UP DELAY (EXITING FROM STOP) */
/*  0= NO DELAY */
/*  1= A DELAY IS IMPOSED */
#define DLY 0x10
/* CLOCK MONITOR ENABLE */
/*  0= DISABLED */
/*  1= SLOW OR STOPPED CLOCKS CAUSE RESET */
#define CME 0x08
/* COP TIMER RATE SELECT BITS */
/* CR1 CR0 E/2^15 DIV BY */
/*  0   0      1 */
/*  0   1      4 */
/*  1   0     16 */
/*  1   1     64 */
#define CR1 0x02
#define CR0 0x01
/*  CR1  CR0	E/2^15 DIV BY */
/*---------------------------- */
/*   0    0	1 */
/*   0    1	4 */
/*   1    0	16 */
/*   1    1	64 */
/*  ARM/RESET COP TIMER CIRCUITRY */

#define COPRST 0x3a
/*  EEPROM PROGRAMMING REGISTER */

#define PPROG 0x3b
/* PROGRAM ODD ROWS IN HALF OF EEPROM (TEST) */
#define ODD 0x80
/* PROGRAM EVEN ROWS IN HALF OF EEPROM (TEST) */
#define EVEN 0x40
/* BYTE/OTHER EEPROM ERASE MODE */
/*  0= ROW OR ALL ERASE MODE WILL BE USED */
/*  1= ERASE ONLY ONE BYTE OF EEPROM */
#define BYTE 0x10
/* ROW/ALL EEPROM ERASE MODE */
/*  0= ALL 512 BYTES OF EEPROM TO BE ERASED */
/*  1= ERASE ONLY ONE 16 BYTE ROW OF EEPROM */
#define ROW 0x08
/* ERASE/NORMAL CONTROL OF EEPROM */
/*  0= NORMAL READ OR PROGRAM MODE */
/*  1= ERASE MODE */
#define ERASE 0x04
/*  EEPROM LATCH CONTROL */
/*  0= EEPROM ADDRESS AND DATA BUS CONFIG FOR READS */
/*  1= EEPROM BUSS CONFIG FOR PROGRAM OR ERASE */
/*     EEPROM CANNOT BE READ WHILE EELAT = 1 */
#define EELAT 0x02
/* EEPROM PROGRAM COMMAND */
/*   WRITABLE ONLY IF EELAT = 1 */
/*  0= PROGRAM (OR ERASE) POWER SWITCHED OFF */
/*  1= PROGRAM (OR ERASE) POWER SWITCHED ON */
#define EEPGM 0x01
/*  HIGHEST PRIORITY INTERRUPT AND MISC. */

#define HPRIO 0x3c
/* READ BOOTSTRAP ROM (ONLY WRITABLE IF SMOD=1) */
/*  0= BOOT ROM NOT IN MAP (NORMAL) */
/*  1= BOOT ROM ENABLED */
#define RBOOT 0x80
/* INTERNAL READ VISIBILITY */
/*  0= NO VISIBILITY OF INTERNAL READS ON EXTERNAL BUS */
/*  1= DATA FROM INTERNAL READS IS DRIVEN OUT DATA BUS */
#define IRV 0x10
/* SPECIAL MODE SELECT */
/*  MODB MODA	MODE DESCR	SMOD MDA */
/*--------------------------------------- */
/*   1    0	SINGLE CHIP	0    0 */
/*   1	 1	EXPANDED MUX	0    1 */
/*   0	 0	BOOTSTRAP	1    0 */
/*   0	 1	SPECIAL TEST	1    1 */
#define SMOD 0x40
/* MODE SELECT */
#define MDA 0x20
/* PRIORITY SELECT */
/* MAY ONLY BE WRITTEN IF I BIT IN CC REG IS 1 */
/* PSEL3 PSEL2 PSEL1 PSEL0	INTERRUPT */
/*------------------------------------------ */
/*   0     0     0     0		TIMER OVERFLOW */
/*   0     0     0     1		PULSE ACCUM OVERFL */
/*   0     0     1     0		PULSE ACC EDGE */
/*   0     0     1     1		SPI XFER COMPLETE */
/*   0     1     0     0		SCI SERIAL SYSTEM */
/*   0     1     0     1		RESERVED (DEFAULT IRQ) */
/*   0     1     1     0		IRQ (PIN OR PAR I/O) */
/*   0     1     1     1		REAL TIME INTERRUPT */
/*   1     0     0     0		TIMER INPUT CAPTURE 1 */
/*   1     0     0     1		TIMER INPUT CAPTURE 2 */
/*   1     0     1     0		TIMER INPUT CAPTURE 3 */
/*   1     0     1     1		TIMER OUTPUT COMPARE 1 */
/*   1     1     0     0		TIMER OUTPUT COMPARE 2 */
/*   1     1     0     1		TIMER OUTPUT COMPARE 3 */
/*   1     1     1     0		TIMER OUTPUT COMPARE 4 */
/*   1     1     1     1		TIMER OUTPUT COMPARE 5 */
#define PSEL3 0x08
#define PSEL2 0x04
#define PSEL1 0x02
#define PSEL0 0x01

/*  RAM AND I/O MAPPING REGISTER */
#define INIT 0x3d
#define RAM3 0x80
#define RAM2 0x40
#define RAM1 0x20
#define RAM0 0x10
#define REG3 0x08
#define REG2 0x04
#define REG1 0x02
#define REG0 0x01

/*  FACTORY TEST REGISTER */
/*   RESTRICTED TEST MODES ONLY */
#define TEST1 0x3e
/* TEST ILLEGAL OPCODE */
#define TILOP 0x80
/* OUTPUT CONDITION CODE REG STAT TO TIMER PORT */
#define OCCR 0x20
/* TIMER DIVIDER CHAIN BYPASS */
#define CBYP 0x10
/* DISABLE RESETS FROM COP AND CLOCK MONITOR */
#define DISR 0x08
/* FORCE CLOCK MONITOR FAILURE */
#define FCM 0x04
/* FORCE COP WATCHDOG FAILURE */
#define FCOP 0x02
/* TEST CONFIGURATION */
#define TCON 0x01

/*  CONFIGURATION CONTROL REGISTER */
#define CONFIG 0x3f
/* SECURITY MODE DISABLE (MASK) */
/*  0=SECURITY MODE */
/*  1=NO SECURITY */
#define NOSEC 0x08
/* COP SYSTEM DISABLE */
/*  0=COP SYSTEM ENABLED (FORCES RESET ON TIMEOUT) */
/*  1=COP SYSTEM DISABLED */
#define NOCOP 0x04
/* ROM ENABLE */
/*  0= ROM IS NOT IN THE MEMORY MAP */
/*  1= ROM ON AT $E000 TO $FFFF */
#define ROMON 0x02
/* EEPROM ENABLE */
/*  0= EEPROM IS NOT IN THE MEMORY MAP */
/*  1= EEPROM ON AT $B600 TO $B7FF */
#define EEON 0x01
/*   INTERRUPT VECTOR ASSIGNMENT */
#define RESVEC0 0xffc0
#define RESVEC1 0xffc2
#define RESVEC2 0xffc4
#define RESVEC3 0xffc6
#define RESVEC4 0xffc8
#define RESVEC5 0xffca
#define RESVEC6 0xffcc
#define RESVEC7 0xffce
#define RESVEC8 0xffd0
#define RESVEC9 0xffd2
#define RESVECA 0xffd4
#define VECSCI 0xffd6
#define VECSPI 0xffd8
#define VECPAI 0xffda
#define VECPAO 0xffdc
#define VECTOV 0xffde
#define VECTO5 0xffe0
#define VECTO4 0xffe2
#define VECTO3 0xffe4
#define VECTO2 0xffe6
#define VECTO1 0xffe8
#define VECTI3 0xffea
#define VECTI2 0xffec
#define VECTI1 0xffee
#define VECRTI 0xfff0
#define VECIRQ 0xfff2
#define VECXIRQ 0xfff4
#define VECSWI 0xfff6
#define VECILL 0xfff8
#define VECCOP 0xfffa
#define VECCMF 0xfffc
#define VECRES 0xfffe

/*
 *	Interrupt vector map - check values and if they're used
 */
#define SCIVECTOR	0xFFD6
#define SPIVECTOR	0xFFD8
#define PAIEVECTOR	0xFFDA
#define PAOVECTOR	0xFFDC
#define TOFVECTOR	0xFFDE
#define TOC5VECTOR	0xFFE0
#define TOC4VECTOR	0xFFE2
#define TOC3VECTOR	0xFFE4
#define TOC2VECTOR	0xFFE6
#define TOC1VECTOR	0xFFE8
#define TIC3VECTOR	0xFFEA
#define TIC2VECTOR	0xFFEC
#define TIC1VECTOR	0xFFEE
#define RTIVECTOR	0xFFF0
#define IRQVECTOR	0xFFF2
#define XIRQVECTOR	0xFFF4
#define SWIVECTOR	0xFFF6
#define ILLOPVECTOR	0xFFF8
#define COPVECTOR	0xFFFA
#define CLKMONVECTOR	0xFFFC
#define RESETVECTOR	0xFFFE

#endif
