/****************************************************************************************/
/*											*/
/* Abacus Sentry - Port Scan Detector Header File					*/
/*											*/
/* Author: Craig H. Rowland <crowland@psionic.com> <crowland@bipolar.net>		*/
/* Created: 10-12-97									*/
/*											*/
/* This software is Copyright(c) 1997-98 Craig H. Rowland				*/
/*											*/
/* This software is free to use provided the enclosed DISCLAIMER is read and adhered	*/
/* to. Use of this software in a commercial product offering is prohibited.		*/
/* Code changes are permitted for PERSONAL USE ONLY and may not be distributed.		*/
/* Send all changes/modifications/bugfixes to the above addresses.			*/
/*											*/
/* This software is provided AS-IS and has no warranty or guarantee of any type.	*/
/*											*/
/*											*/
/* Id: $Id: sentry.h,v 1.2 1998/03/11 04:24:10 crowland Exp crowland $		*/
/****************************************************************************************/

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h> 
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include <netdb.h>

#define ERROR -1
#define TRUE 1
#define FALSE 0
#define MAXBUF 1024
/* max size of an IP address plus NULL */
#define IPMAXBUF 17
/* max sockets we can open */
#define MAXSOCKS 64


#define VERSION "0.50"

/* prototypes */

extern int abacusWriteBlocked(char *, int);
extern void abacusLog(char *);
extern void abacusExit(int);
extern void abacusStart(void);
extern int abacusDaemonSeed(void);
extern int abacusNeverBlock(char *);
extern int abacusCheckConfig(void);
extern int abacusOpenTCPSocket(void);
extern int abacusOpenUDPSocket(void);
extern int abacusBindSocket(int , struct sockaddr_in , struct sockaddr_in , int );
extern int abacusKillRoute(char *);
extern int abacusKillHostsDeny(char *);
extern int abacusKillRunCmd(char *);
extern int abacusConfigTokenRetrieve(char *, char *);
extern int abacusIsBlocked(char *);
extern int abacusSubstString(char *, char *, char *);
extern int abacusDoBlockUDP(void);
extern int abacusDoBlockTCP(void);

int sentryModeTCP(void);
int sentryModeUDP(void);
int disposeUDP(char *);
int disposeTCP(char *);
int checkStateEngine(char *);
void usage(void);

