#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <time.h>
#include <pcap.h>
#include "thc-ipv6.h"

extern int debug;

char *mcasts1[] = { "FF01:0:0:0:0:0:0:1", "FF01:0:0:0:0:0:0:2",
  "FF01:0:0:0:0:0:0:FB", "FF02:0:0:0:0:0:0:1", "FF02:0:0:0:0:0:0:2",
  "FF02:0:0:0:0:0:0:4", "FF02:0:0:0:0:0:0:5", "FF02:0:0:0:0:0:0:6",
  "FF02:0:0:0:0:0:0:7", "FF02:0:0:0:0:0:0:8", "FF02:0:0:0:0:0:0:9",
  "FF02:0:0:0:0:0:0:A", "FF02:0:0:0:0:0:0:B", "FF02:0:0:0:0:0:0:C", 
  "FF02:0:0:0:0:0:0:D", "FF02:0:0:0:0:0:0:E", "FF02:0:0:0:0:0:0:F",
  "FF02:0:0:0:0:0:0:12", "FF02:0:0:0:0:0:0:16", "FF02:0:0:0:0:0:0:6A",
  "FF02:0:0:0:0:0:0:6B", "FF02:0:0:0:0:0:0:6C", "FF02:0:0:0:0:0:0:6D",
  "FF02:0:0:0:0:0:0:6E", "FF02:0:0:0:0:0:0:6F", "FF02:0:0:0:0:0:0:FB", 
  "FF02:0:0:0:0:0:1:1", "FF02:0:0:0:0:0:1:2", "FF02:0:0:0:0:0:1:3",
  "FF02:0:0:0:0:0:1:4", "FF05:0:0:0:0:0:0:2", "FF05:0:0:0:0:0:0:FB",
  "FF05:0:0:0:0:0:1:3", NULL };

char *mcasts1t[] = { "All Nodes Address", "All Routers Address", 
  "mDNSv6", "All Nodes Address", "All Routers Address", "DVMRP Routers", 
  "OSPFIGP", "OSPFIGP Designated Routers", "ST Routers", "ST Hosts", 
  "RIP Routers", "EIGRP Routers", "Mobile-Agents", "SSDP", "All PIM Routers",
  "RSVP-ENCAPSULATION", "UPnP", "VRRP", "All MLDv2-capable routers", 
  "All-Snoopers", "PTP-pdelay", "Saratoga", "LL-MANET-Routers", "IGRS", 
  "iADT Discovery", "mDNSv6", "Link Name", "All-dhcp-agents", 
  "Link-local Multicast Name", "DTCP Announcement", "All Routers Address", 
  "mDNSv6", "All-dhcp-servers", NULL } ;

char *mcasts2[] = { "FF0X:0:0:0:0:0:0:C", "FF0X:0:0:0:0:0:0:FB",
  "FF0X:0:0:0:0:0:0:100", "FF0X:0:0:0:0:0:0:101", "FF0X:0:0:0:0:0:0:102", 
  "FF0X:0:0:0:0:0:0:103", "FF0X:0:0:0:0:0:0:104", "FF0X:0:0:0:0:0:0:106", 
  "FF0X:0:0:0:0:0:0:107", "FF0X:0:0:0:0:0:0:108", "FF0X:0:0:0:0:0:0:109", 
  "FF0X:0:0:0:0:0:0:118", "FF0X:0:0:0:0:0:0:120", "FF0X:0:0:0:0:0:0:121", 
  "FF0X:0:0:0:0:0:0:122", "FF0X:0:0:0:0:0:0:123", "FF0X:0:0:0:0:0:0:127", 
  "FF0X:0:0:0:0:0:0:128", "FF0X:0:0:0:0:0:0:129", "FF0X:0:0:0:0:0:0:12B", 
  "FF0X:0:0:0:0:0:0:130", "FF0X:0:0:0:0:0:0:201", "FF0X:0:0:0:0:0:0:202", 
  "FF0X:0:0:0:0:0:0:204", "FF0X:0:0:0:0:0:0:300", "FF0X:0:0:0:0:0:1:1000", 
  "FF0X:0:0:0:0:0:1:1001", "FF0X:0:0:0:0:0:1:1002", "FF0X:0:0:0:0:0:2:7FFE",
  NULL } ;

char *mcasts2t[] = { "SSDP", "mDNSv6", "VMTP Managers Group", 
  "Network Time Protocol (NTP)", "SGI-Dogfight", "Rwhod", "VNP", 
  "NSS - Name Service Server", "AUDIONEWS - Audio News Multicast", 
  "SUN NIS+ Information Service", "MTP Multicast Transport Protocol", 
  "microsoft-ds", "mtrace", "RSVP-encap-1", "RSVP-encap-2", "SVRLOC-DA", 
  "cisco-rp-announce", "cisco-rp-discovery", "gatekeeper", "X Display", 
  "UPnP", "rwho Group (BSD) (unofficial)", "SUN RPC PMAPPROC_CALLIT", 
  "All C1222 Nodes", "Mbus/Ipv6", "Service Location - Version 2", 
  "Service Location - Version 2", "Service Location - Version 2", 
  "SAPv1 Announcements", NULL } ;

void help(char *prg) {
  printf("%s %s (c) 2010 by %s %s\n\n", prg, VERSION, AUTHOR, RESOURCE);
  printf("Syntax: %s [-r] interface\n\n", prg);
  printf("Tries to find out anything possible on the local network\n");
  printf("Use -r to use raw mode.\n\n");
  exit(-1);
}

int main(int argc, char *argv[]) {
  unsigned char *pkt = NULL;
  unsigned char *dst6 = NULL, *src6 = NULL, *mac = NULL, string[64] = "icmp6 and dst ";
  int rawmode = 0, i;
  char *interface;
  unsigned char buf[16];
  pcap_t *p;
  thc_ipv6_hdr *hdr;

  if (argv[1] != NULL && strcmp(argv[1], "-r") == 0) {
    thc_ipv6_rawmode(1);
    rawmode = 1;
    argv++;
    argc--;
  }

  if (argc < 2 || strncmp(argv[1], "-h", 2) == 0)
    help(argv[0]);

  interface = argv[optind];
  src6 = thc_get_own_ipv6(interface, dst6, PREFER_LINK);

  if (rawmode == 0 && (mac = thc_get_mac(interface, src6, dst6)) == NULL) {
    fprintf(stderr, "ERROR: Can not resolve mac address for %s\n", argv[2]);
    exit(-1);
  }

  src6 = thc_get_own_ipv6(interface, dst6, PREFER_LINK);
  strcat(string, thc_string2notation(thc_ipv62string(src6)));

  if ((p = thc_pcap_init(interface, string)) == NULL) {
    fprintf(stderr, "Error: could not capture on interface %s with string %s\n", interface, string);
    exit(-1);
  }

  printf("TOOL NOT IMPLEMENTED YET\n");
  exit(-1);


// alle multicast adressen pingen
//
// router sol
// mcast router sol
// prefix sol
// home address sol
// alive auf ff02::1
// dhcp6client request
// DAD?
// MAC address from IP -> HW tabelle hersteller
// fe80::... ip erstellung



  thc_pcap_close(p);
  return 0;
}
