//#pragma optimize(5,SPEED)
//#pragma debug
//#pragma code


 * Season95 -- Videocrypt BSkyB smard card emulator for DOS.
 *
 * Author: max
 *
 * Compiles with Borland C++ 3.0, small model.
 *
 * to compile, TCC.EXE, TASM.EXE and TLINK.EXE are needed
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <ctype.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <string.h>
#include <time.h>
#include "decrypt.h"
#include "async.h"

/***********************************************************************
*								       *
*      prototypes						       *
*								       *
***********************************************************************/
void delayy(unsigned d);
void activate_com(int com);
void deactivate_com(void);
int send(unsigned char *data, int len);
int receive(unsigned char *data, int max);
void inverse(unsigned char *data, int len);
void log_packet(unsigned char *header, unsigned char *data,
		int direction);
int FastScroll(int line_top, int line_bottom);
int FastPrintf(int line, int col, int attr, char * str);
int InitVideo();
int InitScreen();
int ShowHelp(int helppage) ;
int PreloadValues() ;
int DisplayStation();
/***********************************************************************
*								       *
*      definitions						       *
*								       *
***********************************************************************/
#define VERSION "1.3"         // last change: 1995-08-07  By MAX

// message directions
#define IN   0	   // to card
#define OUT  1	   // to decoder

/***********************************************************************
*								       *
*      workfields						       *
*								       *
***********************************************************************/
extern unsigned char ext_ee[];
extern unsigned char ext_ee2[];

/*
 * information in answer to reset: (as defined in ISO 7816-3)
 * inverse convention (3f), protocol type T=0, F=372, D=1, I=50mA, P=5V, N=5.
 * historic characters (final 10 bytes): ???
 */
#define RESET_ANSWER_LEN 16
char reset_answer[RESET_ANSWER_LEN] =
  {
  0x3f, 0xfa, 0x11, 0x25, 0x05, 0x00, 0x01, 0xb0,
  0x02, 0x3b, 0x36, 0x4d, 0x59, 0x02, 0x81, 0x80
  };

/*
 * These are some delay values (milliseconds) used in the program.
 * Use command line option w to modify them.
 */
#define DELAYS 5
unsigned long delms[DELAYS] =
  {
  30000,	 // wait between reset and answer to reset
  1750,		 // wait after each outgoing byte
  0,		 // wait between header and first procedure byte
  0,		 // wait between procedure byte and data
  0		 // wait between final data byte and procedure bytes
  };

unsigned char indata[165];     // input, 32-byte message
unsigned char outdata[165];    // output, answer to 32-byte message

unsigned char *data;

int debug = 1;
int sdebug = 0;

// because we have these values in ROM, all special addresses have to
// be modified in ram
unsigned char mod08, mod81, mod83, modaa, mod7e, modfe, modbf, modc0;

/***********************************************************************
*								       *
*      screenfields						       *
*								       *
***********************************************************************/
char far * p_screen;		       // pointer to screen memory
#define MAXHELPPAGE 6
int helppage=0; 		       // keeps track of help pages

// we show this shortly after a reset on the screen
unsigned char display[45] = "\x80"
  "SEASON95 " VERSION
  "   --:--    ";

// channel id (based on byte 7 in 74 messages) for TV screen display
char *channel_id[16] =
  {
  "    ????    ",
  " SKY MOVIES ",
  "MOVIECHANNEL",
  "MOVIES GOLD ",
  "    ????    ",
  "    ????    ",
  " SKY SPORTS ",
  "    ????    ",
  "   ZEE TV   ",
  "    ????    ",
  "    ????    ",
  "    ????    ",
  "MULTICHANNEL",
  "    ????    ",
  "    ????    ",
  "    ????    "
  };

// channel name for text screen display on the PC

char *channel_name[16] =
  {
  "???              ",
  "Sky Movies       ",
  "The Moviechannel ",
  "Sky Movies Gold  ",
  "???              ",
  "???              ",
  "Sky Sports       ",
  "???              ",
  "Zee TV           ",
  "???              ",
  "???              ",
  "???              ",
  "Sky Multichannels",
  "???              ",
  "???              ",
  "???              "
  };

int station = -1;
int messagePC = 1;

char *current_name = "???              ";

char screenbuf[100];

unsigned char last_nano, last_subnano;



/***********************************************************************
*								       *
*      01  main 		       parent = --  dos system	       *
*								       *
***********************************************************************/
main(int argc, char **argv)
{
unsigned char header[5];	       // 5-byte header
int hc = 0;			       // header count

int received = -1, length, dir;

time_t now;
unsigned char answer_40;

int com = 2;
int quit = 0, message = 1;
int i, j, k, c, fk;
int dd=0;

#define LOGMAX 400

time_t logtime[LOGMAX +10];
unsigned char logmsg[LOGMAX +10][32 +10];
int loglength = 0;		       // goes till LOGMAX and then stops
int lognext = 0;		       // where to put next log message
				       // (wraps around)
char *logfn = "VCLOG";
char tmp[80];
FILE *f;
int fh;






// TEST ONLY TEST ONLY	TEST ONLY TEST ONLY TEST ONLY TEST ONLY
/*
dcdr 74: e8 49 09 92 1f 93 63 74 ce 62 e4 c2 36 00 00 00   .I....ct.b..6...
	 00 00 00 00 00 00 00 00 00 00 00 8a 10 c7 0f 2f   .............../
card 78: cc 2e 3c 1a 12 5f 9c 05			   ..<.._..
*/
/*
PreloadValues();
indata[0]=0xe8	;
indata[1]=0x49	;
indata[2]=0x09	;
indata[3]=0x92	;
indata[4]=0x1f	;
indata[5]=0x93	;
indata[6]=0x63	;
indata[7]=0x74	;
indata[8]=0xce	;
indata[9]=0x62	;
indata[10]=0xe4 ;
indata[11]=0xc2 ;
indata[12]=0x36 ;
indata[13]=0x00 ;
indata[14]=0x00 ;
indata[15]=0x00 ;
indata[16]=0x00 ;
indata[17]=0x00 ;
indata[18]=0x00 ;
indata[19]=0x00 ;
indata[20]=0x00 ;
indata[21]=0x00 ;
indata[22]=0x00 ;
indata[23]=0x00 ;
indata[24]=0x00 ;
indata[25]=0x00 ;
indata[26]=0x00 ;
indata[27]=0x8a ;
indata[28]=0x10 ;
indata[29]=0xc7 ;
indata[30]=0x0f ;
indata[31]=0x2f ;

for (i=0; i<256; i++)
  {
  indata[1]=i;
  for (j=0; j<256; j++)
    {
    indata[6]=j;
    PreloadValues();
    if ((decode() & 1) == 0)
      {
      printf("i=%d   j=%d",i,j);
      exit(0);
      }

    }
  }

exit(1);
*/
// END TEST

#ifndef __MSC
clrscr();
#endif

InitVideo();
InitScreen();



if (dd==1) printf(
  "Notice: this software must not be used to view a channel for\n"
  "        which a regular subscription is available in your country,\n"
  "        unless you have already such a subscription and want to use\n"
  "        this software only for educational purposes.\n"
  "        This software is in the public domain and may be redistributed\n"
  "        and used under the above conditions without any restrictions.\n"
  );

for (i = 1; i < argc; i++)
  {
  if (isdigit(argv[i][0]))
    {
    com = atoi(argv[i]);
    }
   else
    {
    for (j = 0; j < 999 && argv[i][j]; j++)
      {
      switch(argv[i][j])
	{
	case 'd':
	case 'D':
	  // switch on screen log mode
	  debug = 1;
	  break;

	case 's':
	case 'S':
	  // switch on screen log mode
	 sdebug = 1;
	  break;

	case 'e':
	case 'E':
	  // suppress PC display messages
	 messagePC = 0;
	  break;

	case 'm':
	case 'M':
	  // suppress TV display messages
	  message = 0;
	  break;

	case 'w':
	case 'W':
	  /*
	   * modify delay table, e.g. option wb2 waits 2 ms after each
	   * byte because this sets delms['b' - 'a'] = 2.
	   * Fast machines (i486) might need wb1 or even wb2. The other
	   * possible settings are for experimental purposes only.
	   */
	  k = tolower(argv[i][j+1]) - 'a';
	  if (k < 0 || k >= DELAYS || !isdigit(argv[i][j + 2]))
	    {
	    printf("Only wait options between wa<microseconds> and "
		   "w%c<microseconds> possible.\n", 'a' + DELAYS - 1);
	    exit(1);
	    }
	  j += 2;
	  delms[k] = atoi(argv[i] + j);
	  while (isdigit(argv[i][j + 1])) j++;
	  break;

	default:
	  break;

	} /* end switch argv */

      } /* end for j */

    } /* end else */

  } /* end for i */


// printf("Press q for exit; F1 for help.\n\n");
FastPrintf(22,40,3,"Press Q for exit; F1 for help.");
// printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
sprintf(screenbuf,"Using serial port COM%d",com);
FastPrintf(21, 0, 7,screenbuf);
FastPrintf(22, 0, 7,"delays:              change with keys:");
FastPrintf(23, 0, 7,"reset:          us (wa)    a/b        ");
FastPrintf(24, 0, 7,"byte :          us (wb)    +/-        ");
sprintf(screenbuf,"%.2d",delms[0]);
FastPrintf(23, 7, 5,screenbuf);
sprintf(screenbuf,"%.2d",delms[1]);
FastPrintf(24, 7, 5,screenbuf);

if (dd==1)
printf(
  "Using serial port COM%d, reset / answer to reset        delay %d ms. (wa)\n"
  "                        byte                           delay %d ms. (wb)\n"
  "                        header / procedure byte        delay %d ms. (wc)\n"
  "                        procedure byte / data          delay %d ms. (wd)\n"
  "                        final data byte/procedure byte delay %d ms. (we)\n",
  com, delms[0], delms[1], delms[2], delms[3], delms[4]);


activate_com(com);
tzset();       // get local time zone from environment variable TZ

// printf("\nWaiting for reset ...");
FastPrintf(21,40, 4,"Waiting for reset ...         ");


while (!quit)
  {
  // keyboard commands
  if (kbhit())
    {
    c = getch();
    switch (c)
      {
      case 0:
	// handle function keys
	fk = getch();
	if (fk==59)	       // F1
	  {
	  helppage=1; ShowHelp(helppage);
	  }
	if (fk==73)	       // page up
	  {
	  if (helppage>=1) helppage--; ShowHelp(helppage);
	  }
	if (fk==81)	       // page down
	  {
	  if (helppage<MAXHELPPAGE) helppage++; else helppage=0;
	  ShowHelp(helppage);
	  }
	// screenbuf[0]=fk; screenbuf[1]='\x0';
	// FastPrintf(0,0,7,screenbuf);
	break;

      case 'q':
      case 'Q':
      case 'x':
      case 'X':
      case 27:
	/* abort program */
	quit = 1;
	continue;

      case 'd':
      case 'D':
	/* switch on/off screen log */
	debug = !debug;
	FastScroll( 7,19);
	sprintf(screenbuf,"Debug mode %s.", debug ? "on" : "off");
	FastPrintf(19, 0,30,screenbuf);
	break;

      case 's':
      case 'S':
	/* switch on/off screen log */
       sdebug = !sdebug;
	FastScroll( 7,19);
	sprintf(screenbuf,"Debug mode %s.", debug ? "on" : "off");
	FastPrintf(19, 0,30,screenbuf);
	break;



      case 'l':
      case 'L':
	// write last crypto messages (command 0x74 and 0x78) to a file
	i = lognext - loglength;
	while (i < 0) i += LOGMAX;
	// printf("\rWriting last %d messages to logfile '%s'...\t\t\t\n",
	//	  loglength, logfn);
	FastScroll( 7,19);
	sprintf(screenbuf,
		"Writing last %d messages to logfile '%s'...",
		loglength, logfn);
	FastPrintf(19, 0,30,screenbuf);

	/*
	remove(logfn);
	if ((fh = open(logfn, O_CREAT | O_TEXT)) == -1)
	  {
	  // perror("Sorry, can't open logfile");
	  FastPrintf(21,40, 4,"Sorry, can't open logfile.    ");
	  }
	 else
	  {
	  strftime(tmp, 80, "%Y-%m-%d", gmtime(&logtime[i]));
	  write(fh, tmp, strlen(tmp) );
	  write(fh, "\n", 1);
	  for (j = 0; j < loglength; j++)
	    {
	    strftime(tmp, 80, "%H:%M:%SZ", gmtime(&logtime[i]));
	    write(fh, tmp, strlen(tmp) );
	    write(fh, " ", 1);
	    for (k = 0; k < 32; k++)
	      {
	      sprintf(tmp, "%02x", logmsg[i][k]);
	      write (fh, tmp, strlen(tmp) );
	      }
	    write(fh, "\n", 1);
	    if (++i >= LOGMAX) i = 0;
	    }
	  close(fh);
	  }
	*/


	f = fopen(logfn, "w");
	if (f == NULL)
	  {
	  perror("Sorry, can't open logfile");
	  FastPrintf(21,40, 4,"Sorry, can't open logfile.    ");
	  }
	 else
	  {
	  strftime(tmp, 80, "%Y-%m-%d", gmtime(&logtime[i]));
	  fprintf(f, "%s\n", tmp);
	  for (j = 0; j < loglength; j++)
	    {
	    strftime(tmp, 80, "%H:%M:%SZ", gmtime(&logtime[i]));
	    fprintf(f, "%s ", tmp);
	    for (k = 0; k < 32; k++) fprintf(f, "%02x", logmsg[i][k]);
	    fprintf(f, "\n");
	    if (++i >= LOGMAX) i = 0;
	    }
	  fclose(f);
	  }


	break;

      case 'a':
	/* increase reset delay by 1 us */
	if (delms[0] < 50001) delms[0]+=100;
	// printf("\rReset delay set to %d ms.\t\t\t\t\t\n", delms[0]);
	sprintf(screenbuf,"%.2d",delms[0]);
	FastPrintf(23, 7, 5,screenbuf);
	break;
      case 'b':
	/* decrease reset delay by 1 us */
	if (delms[0] > 0) delms[0]-=100;
	// printf("\rReset delay set to %d ms.\t\t\t\t\t\n", delms[0]);
	sprintf(screenbuf,"%.2d",delms[0]);
	FastPrintf(23, 7, 5,screenbuf);
	break;

      case '+':
	/* increase byte delay by 1 us */
	if (delms[1] < 3000) delms[1]+=100;
	// printf("\rByte delay set to %d ms.\t\t\t\t\t\n", delms[1]);
	sprintf(screenbuf,"%.2d",delms[1]);
	FastPrintf(24, 7, 5,screenbuf);
	break;
      case '-':
	/* decrease byte delay by 1 us */
	if (delms[1] > 0) delms[1]-=100;
	// printf("\rByte delay set to %d ms.\t\t\t\t\t\n", delms[1]);
	sprintf(screenbuf,"%.2d",delms[1]);
	FastPrintf(24, 7, 5,screenbuf);
	break;

      default:
	break;
      } /* end switch (c) */
    } /* end if kbhit() */


  if (AsyncStat() & DCD)
    {
    /*
     *	we have a reset
     */
    AsyncClear();
    /* if (!debug)  */
      {
      // printf("\r\t\t\t\t\t\rRESET");
      FastPrintf(21,40, 4,"RESET                         ");
      }
    while ((AsyncStat() & DCD) && !kbhit());
    if (kbhit()) continue;
    if (delms[0]) delayy(delms[0]);    // let VCC become stable

    PreloadValues();

    if (send(reset_answer, RESET_ANSWER_LEN)) continue;
    if (debug)
      {
      header[1] = 0x60;    // special value indicates log_packet a reset
      header[4] = RESET_ANSWER_LEN;
      log_packet(header, (unsigned char *) reset_answer, IN);
      }

    if (message)
      {
      now = time(NULL);
      strftime((char *) display + 13, 13, "   %H:%M    ", localtime(&now));
      display[0] = '\xd8';
      }
    station = -1;
    hc = 0;
    received = -1;
    } /* end if 'we have a reset' */


  if (hc < 5)
    {
    // waiting for more header bytes
    hc += receive((char *) header + hc, 5 - hc);
    }

   else 	   // else block: hc >= 5

    {
    if (received < 0)
      {
      // new 5 byte command header has arrived
      if (delms[2]) delayy(delms[2]);
      if (header[0] != 0x53)
	{
	send("\x6e\x00", 2);  /* unsupported class */
	hc = 0;
	// printf("\rUnsupported class code %02x \t\t\n", header[0]);
	sprintf(screenbuf,"Unsupported class code %02x!             ",
		header[0]);
	screenbuf[30]='\x0';
	FastPrintf(21,40, 4,screenbuf);
	}

       else	       // else block: good class code

	{
	data = indata;
	memset(indata, 0, 64);	   // default answer: 00 00 00 ...
	switch (header[1])	   // the different instruction types
	  {
	  case 0x70: length =  6; dir = OUT; break;
	  case 0x72: length = 16; dir = IN;  break;
	  case 0x74: length = 32; dir = IN;  break;
	  case 0x76: length =  1; dir = IN;  break;
	  case 0x78: length =  8; dir = OUT; data = outdata; break;
	  case 0x7a: length = 25; dir = OUT; data = display; break;
	  case 0x7c: length = 16; dir = OUT; break;
	  case 0x7e: length = 64; dir = OUT; break;
	  case 0x80: length =  1; dir = IN;  break;
	  case 0x82: length = 64; dir = OUT; break;
	  default:
	    send("\x6d\x00", 2);   // unsupported instruction
	    hc = 0;
	    // printf("\rUnsupported instruction code %02x!\t\t\n", header[1]);
	    sprintf(screenbuf,
		    "Unsupported instruction %02x          ", header[1]);
	    screenbuf[30]='\x0';
	    FastPrintf(21,40, 4,screenbuf);
	  } /* end switch header[1] */

	if (length != header[4])
	  {
	  send("\x67\x00", 2);  /* incorrect length */
	  hc = 0;
	  // printf("\rIncorrect length %d in instruction %02x!\t\t\n",
	  //	       header[4], header[1]);
	  sprintf(screenbuf,
		 "Wrong length %d (instr %02x)       ",
		 header[4], header[1]);
	  screenbuf[30]='\x0';
	  FastPrintf(21,40, 4,screenbuf);
	  }
	if (hc == 5)
	  {
	  // procedure byte: no Vpp, send all data in one piece
	  if (send((char *) header + 1, 1)) continue;	   // ack.
	  if (dir == IN)
	    {
	    received = 0;
	    }
	   else
	    {
	    if (delms[3]) delayy(delms[3]);

	    // here comes the answer (all trafic from card to dcdr)
	    if (length==64 || header[1]==0x7c) memset(outdata, 0, 64);
	    if (length==64) outdata[0]=answer_40;  // for 7e and 82
	    if (send((char *) data, length)) continue;
	    if (delms[4]) delayy(delms[4]);

	    if (send("\x90\x00", 2)) continue;     // ack: everything ok

	     if (header[1]==0x78 )
	      {
	      time(&logtime[lognext]);
	      memcpy(logmsg[lognext++], outdata, 8);
	      if (loglength < LOGMAX) loglength++;
	      if (lognext >= LOGMAX) lognext = 0; /*
	      PreloadValues();
	      memset(indata, 0, 64);
	      memset(outdata, 0, 64);*/
	      }

	     if (header[1]<=0x79  || sdebug ) {

	      if (debug) log_packet(header, data, OUT);
	    }
	    hc = 0;
	    received = -1;
	    }


	  } /* end if hc==5 */

	} /* end else block: good class code */

      } /* end if received < 0 */


     else	       // else block: received >= 0

      {
      if (received < header[4])
	{
	// waiting for more data to receive
	received += receive((char *) data + received, header[4] - received);
	}

       else	       // else block: all data received

	{
	// here, all data has been received
	if (delms[4]) delayy(delms[4]);
	if (send("\x90\x00", 2)) continue;         // ack: everything ok
	if (data[0] & 8   || sdebug) {
	if (debug) log_packet(header, data, IN);
	}
	// reaction on received data
	switch (header[1])
	  {
	  case 0x74:
	    // calculate random number seed from crypto message
	    /*if (*/decode()/*) printf("\rChecksum wrong !!!\t\t\t\t\t\n")*/;

	    // keep history of last LOGMAX crypto messages
	    time(&logtime[lognext]);
	    memcpy(logmsg[lognext++], indata, 32);
	    if (loglength < LOGMAX) loglength++;
	    if (lognext >= LOGMAX) lognext = 0;

	    // handle display
	    if (data[0] & 8) DisplayStation();

	    break;

	  case 0x76:
	    // printf("\rAuthorize button pressed.\t\t\t\t\n");
	    FastPrintf(21,40, 4,"Authorize button pressed.     ");
	    break;

	  case 0x80:
	    answer_40 = 0;
	    if ( data[0] == 0x00 ) answer_40 = 1;
	    break;

	  default:
	    break;

	  } /* end switch header[1] */

	hc = 0;
	received = -1;

	} /* end else block 'all data received' */

      } /* end else block 'received >= 0' */

    } /* end else block 'hc >= 5' */

  } /* end while !quit */


deactivate_com();

#ifndef __MSC
clrscr();
#endif

return 0;
}


/********************** SUPPORT FUNCTIONS *****************************/


/***********************************************************************
*								       *
*      03  delayy		       parent = 01  main	       *
*								       *
***********************************************************************/
void delayy(unsigned d)
{
/* delay routine */

//delay (d);
//;
  union REGS regs;
  if (d == 0) return;
  regs.h.ah = 0x86;
  regs.x.cx = (int) (d >> 16);
  regs.x.dx = (int) (d & 0xffff);
  int86(0x15, &regs, &regs);
}


/***********************************************************************
*								       *
*      03  activate_com 	       parent = 01  main	       *
*								       *
***********************************************************************/
void activate_com(int com)
{
int port, parity;

switch (com)
  {
  case 1: port = COM1; break;
  case 2: port = COM2; break;
  case 3: port = COM3; break;
  case 4: port = COM4; break;
  default:
    printf("Port COM%d not available!\n", com);
    exit(1);
  }
if (AsyncInit(port))
  {
  printf("Can't initialize port COM%d!\n", com);
  exit(1);
  }
AsyncHand(DTR | RTS);
parity	 = reset_answer[0] == 0x3f ? ODD_PARITY : EVEN_PARITY;
AsyncSet(9600, BITS_8 | STOP_2 | parity);

return;
}


/***********************************************************************
*								       *
*      03  deactivate_com	       parent = 01  main	       *
*								       *
***********************************************************************/
void deactivate_com(void)
{
AsyncStop();
}

/***********************************************************************
*								       *
*      03  send 		       parent = 01  main	       *
*								       *
***********************************************************************/
/*
 * Send a string of bytes to serial port and wait for each single echo.
 * (More efficient send methods are too fast for decoder, it seems to
 * need more than 2 stop bits.)
 */
int send(unsigned char *data, int len)
{
int i;
unsigned char c;

AsyncClear();
for (i = 0; i < len; i++)
  {
  c = data[i];
  if (reset_answer[0] == 0x3f) inverse(&c, 1);
  AsyncOut(c);
  while (AsyncInStat() == 0)
    if ((AsyncStat() & DCD) || kbhit()) return 1;
  AsyncIn();
  if (delms[1]) delayy(delms[1]);
  }

return 0;
}


/***********************************************************************
*								       *
*      03  receive		       parent = 01  main	       *
*								       *
***********************************************************************/
/*
 * Get all bytes available from serial port FIFO and return how many
 * bytes were available.
 */
int receive(unsigned char *data, int max)
{
int i = 0;

while (AsyncInStat() > 0 && i < max) data[i++] = AsyncIn();
if (reset_answer[0] == 0x3f) inverse(data, i);

return i;
}

/***********************************************************************
*								       *
*      05  inverse		       parent = 03  send	       *
*						03  receive	       *
*								       *
***********************************************************************/
/*
 * Reverse and invert all bits in each byte of a string.
 * E.g. 10010111b (0x97) becomes 00010110b (0x16).
 */
void inverse(unsigned char *data, int len)
{
int i, j;
unsigned char c;

for (i = 0; i < len; i++)
  {
  c = 0;
  for (j = 0; j < 8; j++) c |= ((data[i] & (1 << j)) != 0) << (7 - j);
  data[i] = ~c;
  }

return;
}

/***********************************************************************
*								       *
*      03  log_packet		       parent = 01  main	       *
*								       *
*      In debugging mode, print the contents of all packets.	       *
*								       *
*								       *
***********************************************************************/
void log_packet(unsigned char *header, unsigned char *data,
		int direction)
{
int i, j, k;
unsigned char c[2]=" \0";

if (header[1]==0x7a) return;
FastScroll(7,19);
if (header[1] == 0x60)	  /* illegal command code 0x60: reset */
  {
  // printf("\rRESET:   ");
  FastPrintf(21,40, 4,"RESET:                        ");
  }
 else
  {
  // printf(screenbuf,
  //	    "\r%s %02x: ", (direction == IN) ? "dcdr" : "card", header[1]);
  sprintf(screenbuf,
	  "%s %02x: ", (direction == IN) ? "dcdr" : "card", header[1]);
   FastPrintf(19, 0,30,screenbuf);
  }

/* dcdr xx: ..	*/
#define BEGINHEX 9
#define BEGINASCII 61
// i counts chars, j is col for hex, k is col for ascii
for (i = 0, j = BEGINHEX, k = BEGINASCII+1; i < header[4]; i++, k++)
  {
  if (j==BEGINHEX)
    {
    FastPrintf(19,BEGINASCII,30,"'");
    FastPrintf(19,BEGINASCII+17,30,"'");
    }
  // printf("%02x ", data[i]);
  sprintf(screenbuf,"%02x", data[i]);
  FastPrintf(19, j,30,screenbuf); j+=3;

  c[0]=data[i]; if (c[0]<' ') c[0]='.';
  FastPrintf(19, k,30,c);

  // begin new line if exceeding 16 bytes
  if ((i & 15) == 15 && (i != header[4]-1))
    {
    // printf("\t\n         ");
    FastScroll( 7,19);
    j = BEGINHEX; k = BEGINASCII;
    }
  }
// putchar('\t');
// putchar('\n');

return;
}

/***********************************************************************
*								       *
*      03  DisplayStation	       parent = 01  main	       *
*								       *
***********************************************************************/
int DisplayStation()
{
/* manage on screen display */
if (station == -1 && data[6] != 0xd1)
  {
  station = data[6];
  strcpy((char *) display + 13,
         "JOIN FIDONET"
	 /*channel_id[data[6] & 0x0f]*/
	);
  }
 else
  if (station != -1 && station != -2)
    {
    display[0] = 0x80;
    station = -2;
    }

/* PC display message */
if (messagePC)
  {

  if (indata[6] != 0xd1 && outdata[0] != 0x01)
    current_name = channel_name[data[6] & 0x0f];

  /* if (!debug) */
    {
    // printf("\r\t\rDecrypting %s %02x %02x %02x",
    //	      current_name, data[0], data[1], data[6]);
    sprintf(screenbuf,"Online: %s %02x %02x %02x",
	    "  ", data[0], data[1], data[6]);
    screenbuf[30]='\x0';
    FastPrintf(21,40, 4,screenbuf);
    FastPrintf(21,65, 4,"             ");

    FastPrintf(20,49,64,current_name);
    }
  }
return 0;
}

/***********************************************************************
*								       *
*      03  PreloadValues	       parent = 01  main	       *
*								       *
***********************************************************************/
int PreloadValues()
{
mod08 = ext_ee[0x08];	   // preload values 17.5.95
mod81 = ext_ee[0x81];	   // preload values
mod83 = ext_ee[0x83];	   // preload values
modaa = ext_ee[0xaa];	   // preload values
mod7e = ext_ee[0x7e];	   // preload values 7.4.95
modfe = ext_ee[0xfe];	   // preload values 7.4.95

return 0;
}


/***********************************************************************
*								       *
*      03  InitScreen		       parent = 01  main	       *
*								       *
*      Initialise the screen					       *
*								       *
***********************************************************************/
int InitScreen()
{
FastPrintf( 0, 0, 7,
"Ŀ");
FastPrintf( 1, 0, 7,""); FastPrintf( 1,79, 7,"");
FastPrintf( 2, 0, 7,""); FastPrintf( 2,79, 7,"");
FastPrintf( 3, 0, 7,""); FastPrintf( 3,79, 7,"");
FastPrintf( 4, 0, 7,""); FastPrintf( 4,79, 7,"");
FastPrintf( 5, 0, 7,""); FastPrintf( 5,79, 7,"");
FastPrintf( 6, 0, 7,
"");

ShowHelp(0);

FastPrintf( 7, 0,30,
"                                                                                ");
FastPrintf( 8, 0,30,
"                                                                                ");
FastPrintf( 9, 0,30,
"                                                                                ");
FastPrintf(10, 0,30,
"                          "); FastPrintf(11, 0,30,
"                                                                "); FastPrintf(12, 0,30,
"                               "); FastPrintf(13, 0,30,
"                         ܰ                                "); FastPrintf(14, 0,30,
"                                                      "); FastPrintf(15, 0,30,
"               ߱                           "); FastPrintf(16, 0,30,
"                                                                "); FastPrintf(17, 0,30,
"                           ");
FastPrintf(18, 0,30,
"                                                                                ");
FastPrintf(19, 0,30,
"                                                                                ");




FastPrintf(20, 0,64,
"                                        channel:                                ");
FastPrintf(23,40,32,"Modified by: MAX          SEASON95 V"VERSION" ");
FastPrintf(24,40,32,"Thanks to: Markus, & others. ");

return 0;
}

/***********************************************************************
*								       *
*      99  ShowHelp		       parent = --  everyone who wants *
*								       *
*      show helppage						       *
*								       *
***********************************************************************/
int ShowHelp(int helppage)
{
switch (helppage)
  {
  case 1:
FastPrintf( 1, 2, 7,
"Welcome to season95. Season95 is a computer program emulating a video-    "); FastPrintf( 2, 2, 7,
"crypt smartcard to view BSkyB TV channels and other channels.             "); FastPrintf( 3, 2, 7,
"Adult and Eurotica add by i5uxj                                           "); FastPrintf( 4, 2, 7,
"See next page for command line options.                                   "); FastPrintf( 5, 2, 7,
"                        Press <PG UP> and <PG DN> to scroll help.    pg. 1");
    break;
  case 2:
FastPrintf( 1, 2, 7,
"Sintax to start SEASON95                                                  "); FastPrintf( 2, 2, 7,
"SEASON95 [com] [wax] [wbx] [wcx] [wdx] [wex] [m] [e] [d]                  "); FastPrintf( 3, 2, 7,
" x is a numeric value     com: comport number e.g. 1  e: no PC screen     "); FastPrintf( 4, 2, 7,
" wa: delay time for reset wc - we: experimental only  d: start in debug   "); FastPrintf( 5, 2, 7,
" wb: byte delay time      m: suppress OSD display    <PG UP> <PG DN> pg. 2");
    break;
  case 3:
FastPrintf( 1, 2, 7,
"Possible keyboard commands while the program is running:                  "); FastPrintf( 2, 2, 7,
" q exit the program    a increase reset delay                             "); FastPrintf( 3, 2, 7,
" d toggle debug mode   b decrease reset delay                             "); FastPrintf( 4, 2, 7,
" l write logfile       + increase byte delay  - decrease byte delay       "); FastPrintf( 5, 2, 7,
" s is for debugging only 7a and 78 messages          <PG UP> <PG DN> pg. 3");
    break;
  case 4:
FastPrintf( 1, 2, 7,
"Explanation of the SEASON95 status screen:                                "); FastPrintf( 2, 2, 7,
"bottom 4 lines is status block, showing current settings (delays, comport "); FastPrintf( 3, 2, 7,
"etc.) and operating messages like waiting for reset, online, etc.         "); FastPrintf( 4, 2, 7,
"Bytes meaning after the word 'ONLINE': data[0] data[1] channelID nanocomm."); FastPrintf( 5, 2, 7,
"subnanocommand                                       <PG UP> <PG DN> pg. 4");
    break;
  case 5:
FastPrintf( 1, 2, 7,
"Explanation of the SEASON95 middle area of the screen:                    "); FastPrintf( 2, 2, 7,
"This area (initially showing the SEASON word) is used for debugging       "); FastPrintf( 3, 2, 7,
"messages when the program is in debug mode (keyboard d). In that case, it "); FastPrintf( 4, 2, 7,
"shows the various messages going to and coming from the decoder in hexa-  "); FastPrintf( 5, 2, 7,
"decimal and in ascii.                                <PG UP> <PG DN> pg. 5");
    break;
  case MAXHELPPAGE:
FastPrintf( 1, 2, 7,
" Season 95 was derived from SEASON7 and SKY09PUB, with some additional    "); FastPrintf( 2, 2, 7,
" user-interface features being added.                                     "); FastPrintf( 3, 2, 7,
"                                                                          "); FastPrintf( 4, 2, 7,
" Last modification: 05-08-1995                                            "); FastPrintf( 5, 2, 7,
"                                                     <PG UP> <PG DN> pg. 6");
    break;

  default:
FastPrintf( 1, 2, 7,
"NOTICE: this software mustn't be used to view a channel for wich a regular"); FastPrintf( 2, 2, 7,
"subscription is available where you live, unless you have such a sub-     "); FastPrintf( 3, 2, 7,
"scription and want to use this software for educational purposes. This    "); FastPrintf( 4, 2, 7,
"software is PUBLIC DOMAIN and may be redistributed and used onder the     "); FastPrintf( 5, 2, 7,
"above conditions. THIS SOFTWARE IS FREE, YOU SHOULDN'T HAVE PAID FOR IT.  ");
  } /* end switch helppage */

return 0;
}
/***********************************************************************
*								       *
*      99  InitVideo		       parent = --  everyone who wants *
*								       *
*      Determine begin address of video memory and store it in	       *
*      p_screen (global variable). This function MUST be called once   *
*      before any of the Fast functions is used.		       *
*								       *
*								       *
***********************************************************************/
int InitVideo()
{
char far * p_video_mode;	       /* verre pointer naar een */
				       /* gegevensgebied in het */
				       /* LOW MEMORY bios data area */
				       /* die video mode aangeeft */
int video_mode;

p_video_mode=(char far *)(0x0040L*65536L+0x0049L);
video_mode=*p_video_mode;
if (video_mode==3) p_screen=(char far *)(0xb800L*65536L+0x0000L);
 else p_screen=(char far *)(0xb000L*65536L+0x0000L);

return 0;
}
/***********************************************************************
*								       *
*      99  FastPrintf		       parent = --  everyone who wants *
*								       *
*      fast print (using direct video memory) on line line, column     *
*      col, with attribute attr 				       *
*								       *
*      line varies from 0 to 24 				       *
*      col varies from 0 to 79					       *
*								       *
***********************************************************************/
int FastPrintf(int line, int col, int attr, char * str)
{
char far * w;
int i, j, k;

w=p_screen + line*160 + col*2;
for (i=0; i<strlen(str); i++)
  {
  *w=str[i];
  w++;
  *w=attr;
  w++;
  }

return 0;
}
/***********************************************************************
*								       *
*      99  FastScroll		       parent = --  everyone who wants *
*								       *
*      fast scroll (using direct video memory)			       *
*								       *
*      scroll the screen region 1 line up (losing the top line and     *
*      making bottom line blank)				       *
*								       *
*      region define bij line_top and line_bottom		       *
*								       *
***********************************************************************/
int FastScroll(int line_top, int line_bottom)
{
char far * w;
char far * x;
char c;

int i, j, k;

k = (line_bottom - line_top) * 80;
w = p_screen + line_top*160;
x = p_screen + line_top*160 + 160;
for (i=0; i<k; i++)   // scroll 1 line up, including attr's
  {
  c=*x; *w=c;
  w++; x++;
  c=*x; *w=c;
  w++; x++;
  }
for (i=0; i<80; i++)   // make last line blank (attr's not changed)
  {
  *w=' '; w++; w++;
  }

return 0;
}

