$ NOMOD51
$ PAGELENGTH (60)
$ PAGEWIDTH (130)
$ NOLIST
$ INCLUDE (REG51.PDF)
$ LIST

;**************************************************************************
;* MODULE               : ISOASYNC                                        *
;* DESCRIPTION          : PERFORMS BIDIRECTIONAL ASYNCRONOUS              *
;*                      : COMMUNICATION ACCORDING TO ISO 7816             *
;**************************************************************************
;*                  ADAPTED FOR 16MHZ CRYSTAL !!!!!!!!                    *
;**************************************************************************

NAME	ISOASYNC

ISORXD	EQU	P1.0	;
ISOTXD	EQU	P1.0	;

?PR?_TRANSMIT_ISO_ASYNC?ISOASYNC         SEGMENT CODE
?DT?_TRANSMIT_ISO_ASYNC?ISOASYNC         SEGMENT DATA
?BI?_TRANSMIT_ISO_ASYNC?ISOASYNC         SEGMENT BIT
?PR?_RECEIVE_ISO_ASYNC?ISOASYNC          SEGMENT CODE
?DT?_RECEIVE_ISO_ASYNC?ISOASYNC          SEGMENT DATA
?BI?_RECEIVE_ISO_ASYNC?ISOASYNC          SEGMENT BIT

EXTRN	DATA (GUARDTIME)
EXTRN	BIT (CONVENTION)

PUBLIC	_RECEIVE_ISO_ASYNC
PUBLIC	_TRANSMIT_ISO_ASYNC

	RSEG  ?DT?_TRANSMIT_ISO_ASYNC?ISOASYNC
?_TRANSMIT_ISO_ASYNC?BYTE:
SEND_BYTE?00:		DS  1

	RSEG  ?BI?_TRANSMIT_ISO_ASYNC?ISOASYNC
?_TRANSMIT_ISO_ASYNC?BIT:
PARITY_BACKUP?01:	DBIT  1

	RSEG  ?DT?_RECEIVE_ISO_ASYNC?ISOASYNC
?_RECEIVE_ISO_ASYNC?BYTE:
READ_BYTE?10:		DS  1

	RSEG  ?BI?_RECEIVE_ISO_ASYNC?ISOASYNC
?_RECEIVE_ISO_ASYNC?BIT:
PARITY_BACKUP?11:	DBIT  1

$ EJECT

;ASYNCHRONOUS COMMUNICATION TRANSMIT
;***********************************

; BIT TRANSMIT_ISO_ASYNC ( UNSIGNED CHAR SEND_BYTE )

	RSEG  ?PR?_TRANSMIT_ISO_ASYNC?ISOASYNC
	USING	0
					; DECODER HAS 106,02 US BIT-TIME 
					;
					;  3,500 MHZ = 3,43 US
					; 11,059 MHZ = 1,08 US
					; 12,000 MHZ = 1,00 US
					; 16,000 MHZ = 0,75 US

_TRANSMIT_ISO_ASYNC:
	MOV  	SEND_BYTE?00,R7		; 2 ;
X_1552:	MOV	A,SEND_BYTE?00          ; 1 ;
	MOV	SEND_BYTE?00,A          ; 1 ;
	MOV	R3,#00FH		; 1 ;RETRY_COUNTER (IF PARITY ERROR ) = 15
X_1558:	MOV	A,SEND_BYTE?00          ; 1 ;
	MOV	R2,GUARDTIME            ; 2 ; COUNTER1 = GUARDTIME;
	INC	R2                      ; 1 ; IF ( ++COUNTER1 != 00)
	CJNE	R2,#000H,X_1567         ; 2 ;   {
	SJMP	X_156E                  ; 2 ;
					;GUARDTIME WAIT -> SHOULD BE 106,02 US
X_1567:	MOV	R1,#69			; 1 ;
	DJNZ	R1,$                    ; 2 ;
	NOP				; 1 ; 142 CYCLES = 160,5 US   
	DJNZ	R2,X_1567		; 2 ;	}

X_156E:	MOV	R2,#009H                ; 1 ;BIT_COUNTER = 0X09 (START + 8 DATA)
	MOV	C,P                     ; 1 ;
	MOV	PARITY_BACKUP?01,C      ; 2 ;SAVE PARITY
	CPL	PARITY_BACKUP?01        ; 1 ;    COMPLEMENT PARITY
	CPL	A                       ; 1 ;    COMPLEMENT ACCU
	CLR	C                       ; 1 ;PREPARE STARTBIT
	SJMP	X_1586                  ; 2 ;STARTBIT --> I/O
					;   ;
X_157D:					;   ;   {
	RLC	A                       ; 1 ;   ROTATE LEFT
X_1586:	MOV	ISOTXD,C                ; 2 ;   OUTPUT --> I/O
	MOV	R1,#68			; 1 ;   
	DJNZ	R1,$                    ; 2 ;
	DJNZ	R2,X_157D               ; 2 ;   }LOOP_CYCLE_TIME : 106,5 US
					;   ;
	MOV	C,PARITY_BACKUP?01      ; 1 ;
	MOV	ISOTXD,C                ; 2 ;PARITY --> I/O
	MOV	R1,#69                  ; 1 ;
	DJNZ	R1,$      		; 2 ;
	SETB	C                       ; 1 ;
	MOV	ISOTXD,C                ; 2 ;STOPBIT --> I/O
					;   ;
	MOV	R1,#50                  ; 1 ;
	DJNZ	R1,$			; 2 ; SAMPLE AT MIDDLE OF BIT
	MOV	C,ISOTXD                ; 1 ;
	CPL	C                       ; 1 ;CHECK PARITY_ERROR ( 1 IF O.K. )
X_15B6:	JNC	X_15BF                  ; 2 ;
	MOV	R1,#50                  ; 1 ;
	DJNZ	R1,$			; 2 ; WAIT OTHER MIDDLE OF BIT
	DJNZ	R3,X_1558               ; 2 ;
X_15BA:	SETB	C                       ; 1 ;
	MOV	ISOTXD,C                ; 2 ;
	CLR	C                       ; 1 ;PARITY_ERROR
	RET                             ; 2 ;
					;   ;
X_15BF:	SETB	C                       ; 1 ;
	MOV	ISOTXD,C                ; 2 ;
	RET                             ; 2 ;

; END OF _TRANSMIT_ISO_ASYNC

$ EJECT

;ASYNCHRONOUS COMMUNICATION RECEIVE 
;**********************************

; BIT RECEIVE_ISO_ASYNC ( UNSIGNED CHAR IDATA *READ_BYTE )

	RSEG  ?PR?_RECEIVE_ISO_ASYNC?ISOASYNC
	USING	0

_RECEIVE_ISO_ASYNC:
	MOV	READ_BYTE?10,R7		; 2 ;SAVE IDATA_POINTER
X_15C6:	MOV	R4,#00FH                ; 1 ;REPEAT_COUNTER = 0X0F
X_15C8:	SETB	ISORXD                  ; 1 ;
	MOV	R2,#0B3H                ; 1 ;
	MOV	R1,#000H                ; 1 ;( ( 256 * 6 + 2 ) * 39 ) [CYCLES]
X_15D2:	JB	ISORXD,X_15E8           ; 2 ;
	JNB	ISORXD,X_15F4           ; 2 ;BEGIN_OF_START_BIT (POSITIVE_LOGIC)
X_15E8:	DJNZ	R1,X_15D2               ; 2 ;
	DJNZ	R2,X_15D2               ; 2 ;
	LJMP	X_167C                  ; 2 ;
X_15F4:	MOV	R3,#008H                ; 1 ;BIT_COUNTER = 0X08
	MOV	R2,#000H                ; 1 ;SHIFT_REGISTER = 0X00
	                                ;   ;WAIT FOR END_OF_STARTBIT:
	MOV	R1,#66                  ; 1 ;
	DJNZ	R1,$			; 2 ;
					;   ;READ 8 DATA_BITS:
X_15FF:	MOV	C,CONVENTION            ; 1 ;FOR ( ;BIT_COUNTER != 0X00;BIT_COUNTER-- )
	CPL	C                       ; 1 ;   {   
	MOV	A,#000H                 ; 1 ;   ACCU = 0
	MOV	ACC.1,C                 ; 2 ;  
	MOV	C,ISORXD                ; 1 ;   SAMPLE I/O (DATA_BIT_N FIRST SAMPLE)
	ADDC	A,#000H                 ; 1 ;
	MOV	C,ISORXD                ; 1 ;   SAMPLE I/O (DATA_BIT_N 2ND SAMPLE)
	ADDC	A,#000H                 ; 1 ;
	MOV	C,ISORXD                ; 1 ;   SAMPLE I/O (DATA_BIT_N 3RD SAMPLE)
	ADDC	A,#000H                 ; 1 ;
	MOV	C,ACC.1                 ; 1 ;   
	MOV	A,R2                    ; 1 ;   ACCU = SHIFT_REGISTER
	RLC	A                       ; 1 ;   ROTATE ACCU LEFT THROUGH CARRY
	MOV	R2,A                    ; 1 ;   SHIFT_REGISTER = ACCU
	MOV	R1,#63                  ; 1 ;
	DJNZ	R1,$                    ; 2 ;
	DJNZ	R3,X_15FF		; 2 ;   }LOOP_CYCLE_TIME : 106,5 US

	MOV	R1,#8                   ; 1 ;
	DJNZ	R1,$                    ; 2 ;
	MOV	C,CONVENTION            ; 1 ;
	CPL	C                       ; 1 ;
	MOV	A,#000H                 ; 1 ;READ PARITY_BIT:
	MOV	ACC.1,C                 ; 2 ;
	MOV	C,ISORXD                ; 1 ;SAMPLE I/O (PARITY_BIT FIRST SAMPLE)
	ADDC	A,#000H                 ; 1 ;
	MOV	C,ISORXD                ; 1 ;SAMPLE I/O (PARITY_BIT 2ND SAMPLE)
	ADDC	A,#000H                 ; 1 ;
	MOV	C,ISORXD                ; 1 ;SAMPLE I/O (PARITY_BIT 3RD SAMPLE)
	ADDC	A,#000H                 ; 1 ;
	MOV	C,ACC.1                 ; 1 ;
	MOV	A,R2                    ; 1 ;GET PARITY OF 8 DATA_BITS
	JB 	P,X_164C                ; 2 ;
	JC	X_1665                  ; 2 ;
	SJMP	X_1650                  ; 2 ;
X_164C:	JNC	X_1665                  ; 2 ;
	SJMP	X_1650                  ; 2 ;
X_1650:
	MOV	R1,#70                  ; 1 ; WAIT AT LEAST FOR END OF PARITY..
	DJNZ	R1,$                    ; 2 ;

	MOV	R1,READ_BYTE?10         ; 2 ;READ_POINTER = REG_6F
	MOV	@R1,A                   ; 1 ;*READ_POINTER = SHIFT_REGISTER 
	SETB	C                       ; 1 ;
	RET     	                ; 2 ;

$ EJECT

X_1665:	
	MOV	R1,#60                  ; 1 ;WAIT FOR NEAR END OF PARITY
	DJNZ	R1,$			; 2 ;
	CLR	C		        ; 1 ;INDICATE PARITY ERROR
	MOV	ISORXD,C                ; 2 ;
	MOV	R1,#107                 ; 1 ;OVER STOP BIT TIME
	DJNZ	R1,$			; 2 ;
	SETB	ISORXD                  ; 1 ;RELEASE BUS AND GO BACK..
	DJNZ	R4,X_1679               ; 2 ;
	SJMP	X_167C                  ; 2 ;
X_1679:	LJMP	X_15C8                  ; 2 ;
X_167C:	SETB	C                       ; 1 ;
	MOV	ISORXD,C                ; 2 ;
	CLR	C                       ; 1 ;
	RET                             ; 2 ;

; END OF _RECEIVE_ISO_ASYNC

	END
