/* demonstration on how to use the 'VCLOG' output file from skyfixer.
 *
 * this program deals with the ecm on 15.june.95. it doesn't really
 * fix it, but it shows you that you can allways get the right
 * answer code by simply testing out the values from 0x00 to 0xff for
 * the comtents of the smart card memory at 0xe7. there also appears
 * to be no obvious relation between the given value (eedta) and
 * that one you have to place into 0xe7 to come to the right answer
 * string. you may now add watches all over your decode() and kernel()
 * routine to find out where this value occurs... and you may find
 * it out (that line you have to delete/set in comment marks; see below).
 * This is also the way to use the 0x09/0x30 backdoor in order to read
 * out the romimage. Generate a cryptomessage, set the pointer to the
 * wanted rom address. set the 0x30 hash loop counter to zero (eq 1
 * hash iteration) and record the answer package from your genuine
 * sky card. then, pass the same cryptomessage to your decoding program
 * and use the values from 0x00 to 0xff in the 0x30 nano routine until
 * the resulting answer package equals that one from your genuine card.
 * now, you have found your first rom value...
 *
 * you have to make some changes to your season source code/project to
 * get this demonstration to work. I assume you are using the season95
 * source code.
 *
 * season95.c :
 * insert the line '#include <vcdebug.c>' e.g. right before your main()
 * routine. rename the original season95 main() routine into e.g. bmain()
 * decode.c:
 * insert the line 'extern unsigned char do_flag,given_value; extern int
 * loop_variable1;' in top of the file.
 * go to the 0x11 nano code processing part and insert 'case 0xe7:
 * given_value=eedta; ext_ee[0xe7]=loop_variable1; do_flag=1; break;'
 * go to the kernel routine and delete or set comment-marks to the line
 * 'ext_ee[0xe7]=m>>8;'
 *
 * another tip: get rid of the modxy thing! It only slows down the whole
 * thing. modify the romimage direcly (the romimage isn't placed in ROM !)
 *
 * enjoy,
 * klausi 31.08.95
 *
 */

// global variables, altered by decode()
unsigned char do_flag;
unsigned char given_value;
int loop_variable1;
#include <VCLOG>
#define SCREENLOG 1
/****************************************/
void main (void)
/****************************************/
{
unsigned char screen_tmp[255];
unsigned char ok_check;
unsigned char bottomline;
unsigned int i,j,num,foundit=0;
int match[256];
struct text_info ti;

gettextinfo(&ti);
bottomline=ti.screenheight-1;
InitVideo();
clrscr();
// initialize the recording table ( -1 = empty )
for(i=0;i<256;i++) match[i]=-300;

// use all entries (=LOGENTRIES) for inspection
for(num=1;num<LOGENTRIES;num++)
  {
  do_flag=0;
  memcpy(indata,&(VCDATA[num].QUERY[0]),32);
  memset(outdata,0,8);
  decode();
  if (do_flag) // OK, this package cointains a 0x00e7 address value to the 0x11 command
    {
    if (SCREENLOG)
      for(i=0;i<32;i++)  // print the cryptomessage and the desired result ...
	{
	sprintf(screen_tmp,"%02x", VCDATA[num].QUERY[i]);
	FastPrintf( (bottomline>42) ? 20 : 10,i*2,7,screen_tmp);
	if (i<8)
	  {
	  sprintf(screen_tmp,"%02x", VCDATA[num].ANSWER[i]);
	  FastPrintf( (bottomline>42) ? 21 : 11,10+i*3,12,screen_tmp);
	  }
	}

    ok_check=1;
    for(loop_variable1=0; (loop_variable1 < 256) && ok_check; loop_variable1++)
      {
      if (SCREENLOG)
	{
	sprintf(screen_tmp,"%02x",loop_variable1);
	FastPrintf( (bottomline>42) ? 22 : 12,0,14,screen_tmp);
	}
      // fetch cryptomessage to be processed in decoding routine
      memcpy(indata,&(VCDATA[num].QUERY[0]),32);
      memset(outdata,0,8);

      decode();

      // compensate bug in S95 - decode(): last nibble! is unused.
      outdata[7]&=0x0f;

      ok_check=0;
      // print the calculated answer and compare it with the desired one
      for(i=0;i<8;i++)
	{
	if (SCREENLOG)
	  {
	  sprintf(screen_tmp,"%02x", outdata[i]);
	  FastPrintf( (bottomline>42) ? 22 : 12,10+i*3,12,screen_tmp);
	  }
	if (outdata[i] != VCDATA[num].ANSWER[i])
	  ok_check |= 1; // calculated answer wrong
	}
      }

    // now, all values have been tried or a correct answer has been calculated
    if (ok_check==0) // calculation was correct
      {
      sprintf(screen_tmp,"%02x:%02x", given_value, loop_variable1-1);
      match[given_value] =
	(match[given_value]<-256) ? loop_variable1-1 : -(loop_variable1-1);
      }
    else             // no value fits
      sprintf(screen_tmp,"%02x:-(", given_value);
    FastPrintf( (bottomline>42) ? 40 : 20,foundit*6,(ok_check==0) ? 14 : 7, screen_tmp);
    if ( ++foundit >= 12)
      {
      foundit=0;
      FastScroll( (bottomline>42) ? 30 : 15, (bottomline>42) ? 40 :  20);
      }
    //while(!kbhit());
    //getch();
    if (SCREENLOG)
      {
      FastScroll(0,(bottomline>42) ? 23 : 13);
      FastScroll(0,(bottomline>42) ? 23 : 13);
      FastScroll(0,(bottomline>42) ? 23 : 13);
      FastScroll(0,(bottomline>42) ? 23 : 13);
      FastScroll(0,(bottomline>42) ? 23 : 13);
      }
    } // if(do_flag)
  } // for(num=1 ...

// now, print the result: a red number indicate that there are different
// substitue values that produce a correct answer packet.
// if there are only grey numbers, you may easily find a relation between
// the given value (that is the position where the grey number is stored)
// and the according number that will cause the correct answer string.
// possibly the tyble you see is part of the romimage... (that would really
// be too simple)
  for(j=i=0;i<256;i++)
    {
    if (match[i] < -256)
      sprintf(screen_tmp,"--");
    else
      sprintf(screen_tmp,"%02x",(unsigned char) ((match[i]<0) ? -match[i] : match[i]) & 0xff);
    FastPrintf(bottomline,j*3, (match[i]<0) ? 12 : 7, screen_tmp);
    if(j++>23)
      {
      j=0;
      FastScroll(0,bottomline);
      }
    }
  gotoxy(1,bottomline+1);
} // main()

 