// csvtoarb.cpp : Defines the entry point for the console application.
//

 ******************************************************************************
 * 
 * BUILDING THIS EXAMPLE:
 * 
 * This sample program is intended to be used with Microsoft Visual C# 2005, 
 * or later, and the VISA library.
 * 
 * Sample program execution requires the VISA library as a prerequisite,
 * which is installed by the Agilent IO Libraries Suite.
 * 
 * visa.h is located at:
 * $(VXIPNPPATH)\winnt\include
 *
 * visa32.lib/visa64.lib is located at:
 * 32-bit 
 * $(VXIPNPPATH)\winnt\lib\msc
 * 64-bit
 * $(VXIPNPPATH)\winnt\lib_x64\msc
 * 

 *
 *******************************************************************************/

#include "stdafx.h"
#include <iostream>
#include <fstream>
#include <string>
#include "visa.h"

using namespace std;


static void csvtoarb();

int _tmain(int argc, _TCHAR* argv[])
{
	csvtoarb();

	char buffer[100];
    printf("Press [Enter] to exit\n");
	scanf("%c", buffer);

	return 0;
}

static void csvtoarb()
{
	const char noErrString[] = "+0,\"No error\"\n";

	const int NUM_DATA_POINTS = 1012500;
	float * z = NULL;
	z = new float[NUM_DATA_POINTS];



	char tBuffer[100];
	tBuffer[0] = '\0';
	

	ViRsrc instAddress = "TCPIP0::156.140.93.74::inst0::INSTR";
	ViSession rm = 0,
		vi = 0;

	//Open session for instrument.
	viOpenDefaultRM(&rm);
	viOpen(rm, instAddress, 0, 0, &vi);
	viSetAttribute(vi, VI_ATTR_TMO_VALUE, 20000);

	//Query Identity string and report.
	viPrintf(vi, "*IDN?\n");
	viScanf(vi, "%t", tBuffer);

	printf("Instrument Identity String: %s\n", tBuffer);

	//Clear and reset instrument
	viPrintf(vi, "*CLS;*RST\n");
	viPrintf(vi, "*OPC?\n");
    viScanf(vi, "%t", tBuffer);

	//Clear volatile memory
	viPrintf(vi, "SOURce1:DATA:VOLatile:CLEar\n");
	
	
	
	///////////////////////////////////////////////////////////////////////////////

	//Load Data from .csv file into variable z

	ifstream ch1 ("C:\\Users\\lhornburg\\Documents\\CH1-CH8_CSV_files\\CH1.csv");
	string line;
	
	int i = 0;
	const char*cstring;
	if (ch1.is_open())
	{
		while ( getline (ch1, line) )
    {
		cstring=line.c_str();
      sscanf(cstring, "%f",&(z[i++]));
    }
    ch1.close();
	}

	//////////////////////////////////////////////////////////////////////////////

	

	// set the endian format
	viPrintf(vi, "FORM:BORD NORM\n");

	//Downloading 
	printf("Downloading Waveform...\n");

	//viPrintf(vi, "SOURce1:DATA:ARBitrary:DAC testarb, %*hb\n", NUM_DATA_POINTS, z);

	viPrintf(vi, "SOURce1:DATA:ARBitrary testarb, %*zb\n", NUM_DATA_POINTS, z);
	
	// wait for the operation to complete before moving on
	viPrintf(vi, "*WAI\n");

	printf("Download Complete\n");

	//Set desired configuration
	viPrintf(vi, "SOURce1:FUNCtion:ARBitrary testarb\n"); // set current arb waveform to defined arb pulse
	viPrintf(vi, "SOURce1:FUNCtion ARB\n"); // turn on arb function
	viPrintf(vi, "SOURCE1:FUNCtion:ARB:SRATe 750000\n"); // set sample rate
	//viPrintf(vi, "SOURCE1:VOLT 2\n"); // set max waveform amplitude to 2 Vpp
	//viPrintf(vi, "SOURCE1:VOLT:OFFSET 0\n"); // set offset to 0 V
	viPrintf(vi, "OUTPUT1:LOAD 50\n"); // set output load to 50 ohms

	//Enable Output
	viPrintf(vi, "OUTPUT1 ON\n"); // turn on channel 1 output

	//Read Error/s
	viPrintf(vi, "SYSTEM:ERROR?\n");
	viScanf(vi, "%t", tBuffer);

	if (strcmp(tBuffer, noErrString) == 0)
	{
		printf("Output set without any error\n");
	}
	else
	{
		printf("Error reported: %s\n", tBuffer);
	}

	//OPTIONAL: Save Arb to USB stick, and/or internal memory titled TEST ARB.barb

	//viPrintf(vi, "MMEM:STOR:DATA \"USB:\ch1.barb\"\n");
	//viPrintf(vi, "MMEM:STOR:DATA \"INT:\ch1.barb\"\n");

	return;
}