// TILLOligochrome.h
//
// Copyright Bruxton Corporation, 2007-2008

#ifndef TILLOligochrome_H
#define TILLOligochrome_H

#ifdef WIN32
#include <windows.h>
#else
#define WINAPI
#endif

#ifdef __cplusplus
extern "C" {
#endif

int WINAPI TILLOligochrome_Create(void** handle);

int WINAPI TILLOligochrome_OpenPort(void* handle, const char* port);

void WINAPI TILLOligochrome_Close(void* handle);

void WINAPI TILLOligochrome_GetLastError(
	void* handle,
	char* text,
	int text_size);

int WINAPI TILLOligochrome_GetConfiguration(
	void* handle,
	char* model,
	int model_size,
	char* identification,
	int identification_size);

void WINAPI TILLOligochrome_GetFeatures(
	void* handle,
	int* filter_position_count,
	int* UART_port_count,
	int* focus_clamp);

void WINAPI TILLOligochrome_GetIntervalResolution(
	void* handle,
	double* resolution,
	double* maximum);

int WINAPI TILLOligochrome_GetFilterDescription(
	void* handle,
	int filter_position,
	char* filter_name,
	int filter_name_size,
	int* filter_status,
	int* filter_type,
	double* filter_wavelength,
	double* filter_bandwidth);

int WINAPI TILLOligochrome_GetStatus(void* handle, double* lamp_time);

int WINAPI TILLOligochrome_DigitalInputRead(
	void* handle,
	int bank,
	int mask,
	int* value);

int WINAPI TILLOligochrome_DigitalOutputWrite(
	void* handle,
	int bank,
	int mask,
	int value);

int WINAPI TILLOligochrome_NoOperation(void* handle);

int WINAPI TILLOligochrome_SetFilterPosition(
	void* handle,
	int filter_position,
	double intensity);

int WINAPI TILLOligochrome_EventDefineDigitalInput(
	void* handle,
	int* event,
	int bank,
	int mask,
	int value);

int WINAPI TILLOligochrome_EventFree(void* handle, int event);

int WINAPI TILLOligochrome_ProtocolBegin(void* handle);

int WINAPI TILLOligochrome_ProtocolEnd(void* handle);

int WINAPI TILLOligochrome_ProtocolCancel(void* handle);

int WINAPI TILLOligochrome_ProtocolDelayEvent(
	void* handle,
	int event);

int WINAPI TILLOligochrome_ProtocolDelayTime(
	void* handle,
	double interval);

int WINAPI TILLOligochrome_ProtocolDelayTrigger(
	void* handle,
	int trigger_as_gate);

int WINAPI TILLOligochrome_ProtocolLoopBegin(void* handle, int count);

int WINAPI TILLOligochrome_ProtocolLoopEnd(void* handle);

int WINAPI TILLOligochrome_ProtocolLoopDisable(void* handle);

int WINAPI TILLOligochrome_ProtocolLoopEnable(void* handle);

int WINAPI TILLOligochrome_ProtocolLoopGetIndex(void* handle, int level);

int WINAPI TILLOligochrome_ProtocolIf(void* handle, int event);

int WINAPI TILLOligochrome_ProtocolElse(void* handle);

int WINAPI TILLOligochrome_ProtocolEndIf(void* handle);

int WINAPI TILLOligochrome_ProtocolDigitalInputRead(
	void* handle,
	int bank,
	int mask);

int WINAPI TILLOligochrome_ProtocolDigitalOutputWrite(
	void* handle,
	int bank,
	int mask,
	int value);

int WINAPI TILLOligochrome_ProtocolExperimentTimerRead(
	void* handle);

int WINAPI TILLOligochrome_ProtocolExperimentTimerReset(
	void* handle);

int WINAPI TILLOligochrome_ProtocolMark(void* handle, int mark);

int WINAPI TILLOligochrome_ProtocolNoOperation(void* handle);

int WINAPI TILLOligochrome_ProtocolSetFilterPosition(
	void* handle,
	int filter_position,
	double intensity);

int WINAPI TILLOligochrome_GetResponse(void* handle, int* response);

static const int TILL_OLIGOCHROME_RESPONSE_NONE = 0;
static const int TILL_OLIGOCHROME_RESPONSE_PROTOCOL_END = 1;
static const int TILL_OLIGOCHROME_RESPONSE_MARK = 2;
static const int TILL_OLIGOCHROME_RESPONSE_VARIABLE_READ_INTEGER = 3;
static const int TILL_OLIGOCHROME_RESPONSE_VARIABLE_READ_STRING = 4;
static const int TILL_OLIGOCHROME_RESPONSE_GET_LOOP_INDEX = 5;
static const int TILL_OLIGOCHROME_RESPONSE_DIGITAL_INPUT_READ = 6;
static const int TILL_OLIGOCHROME_RESPONSE_EXPERIMENT_TIMER_READ = 7;
static const int TILL_OLIGOCHROME_RESPONSE_EXPERIMENT_TIMER_RESET = 8;
static const int TILL_OLIGOCHROME_RESPONSE_UICU_WARNING = 9;
static const int TILL_OLIGOCHROME_RESPONSE_UICU_ERROR = 10;

int WINAPI TILLOligochrome_ResponseDigitalInputRead(
	void* handle,
	int* bank,
	int* value);

int WINAPI TILLOligochrome_ResponseExperimentTimerRead(
	void* handle,
	double* timer);

int WINAPI TILLOligochrome_ResponseExperimentTimerReset(
	void* handle,
	double* reset_timer);

int WINAPI TILLOligochrome_ResponseGetLoopIndex(
	void* handle,
	int* level,
	int* index);

int WINAPI TILLOligochrome_ResponseMark(void* handle, int* mark);

static const int TILL_OLIGOCHROME_SUCCESS = 0;
static const int TILL_OLIGOCHROME_ERROR_ALLOCATION = 1;
static const int TILL_OLIGOCHROME_ERROR_CONNECTION = 2;
static const int TILL_OLIGOCHROME_ERROR_COMMAND = 3;
static const int TILL_OLIGOCHROME_ERROR_CONFIGURATION = 4;
static const int TILL_OLIGOCHROME_ERROR_DEVICE = 5;
static const int TILL_OLIGOCHROME_ERROR_PARAMETER = 6;
static const int TILL_OLIGOCHROME_ERROR_INVALID_HANDLE = 7;
static const int TILL_OLIGOCHROME_ERROR_NULL_PARAMETER = 8;

static const int TILL_OLIGOCHROME_STRING_LENGTH = 256;

#ifdef __cplusplus
}
#endif

#endif
