#--------------------------------------------------------------------------
# Title:  ApplicationLauncher GUI Application (Tcl/Tk Application)
#--------------------------------------------------------------------------
# AppVersion:    (master application version number is in the INI file)
# Created:       05 Jul 2009
# Last modified: 05 Jul 2009
#----------------------------------------------------------------------
# Requires: Tcl/Tk 8.3 (or later) and BWidgets 1.2.1 (or later)
#--------------------------------------------------------------------------
#  Copyright (C) 2009 Agilent Technologies
#
#  All copies of this program, whether in whole or in part, and whether
#  modified or not, must display this and all other embedded copyright
#  and ownership notices in full.
#--------------------------------------------------------------------------
# Sample software conditions of use:
#
#  This software is provided as an example. It is distributed in the hope
#  that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#--------------------------------------------------------------------------
# Synopsis:
#  QT GUI wrapper for the Application Launcher utility
#
# Assumptions:
#   - The libraries AgtClient, AgtTsuLib, AgtSgaLib, AgtQuickTestLib
#     and BWidgets are available
#
#--------------------------------------------------------------------------
# Organisation:
#   Ordered alphabetically in the following groups
#       - namespace declaration
#       - loading external packages and source files
#       - GUI         procedures
#       - APPLICATION procedures
#       - MAIN
#--------------------------------------------------------------------------

#==========================================================================
#   N a m e s p a c e s
#==========================================================================

#==========================================================================
#   P r o c e d u r e s
#==========================================================================

#==========================================================================
#   M a i n
#==========================================================================

# =============== DO NOT CHANGE (unless you're really sure!) =================

# if running under Tcl then abort as we need Tk
set isTcl [expr ![info exists ::tk_version]]
if { $isTcl } {
    # running under some variant of TLCSH => Tcl
    puts "WARNING: This GUI script cannot be used under 'tclsh' as it requires"
    puts "         Tk and can only be used under some variant of 'wish'."
    puts "         (currently running under [file tail [info nameofexecutable]])"
    exit
}

#
# load INI file (into global namespace)
#
namespace eval :: {
    set iniFileName [lindex [split [file tail [info script]] .] 0].ini.tcl
    set iniFileName [file dirname [info script]]/$iniFileName
    if { ![file exists $iniFileName] } {
        error "Cannot find application INI file: $iniFileName"
        exit
    } else {
        if { [catch {source $iniFileName}] } {
            error "Failed to source application INI file: $iniFileName"
        }
    }
    unset iniFileName
}
::AppIni::InitialiseStdDefaults ;# declared in the INI file sourced above


# Load external packages and source files and initialise the script variables
set scriptName [lindex [split [file tail [info script]] .] 0]
eval exec wish83 \"[file join [file dirname [info script]] ApplicationLauncher.tcl]\" $argv &
exit
#--<end>--

