#--------------------------------------------------------------------------
# Title:  SmallApp_Template
#--------------------------------------------------------------------------
# Created:       14 Jul 2009
# Last modified: 14 Jul 2009
#--------------------------------------------------------------------------
# Requires:     Tcl/Tk 8.3 (or later)
#--------------------------------------------------------------------------
#  Copyright (C) 2009 Agilent Technologies
#
#  All copies of this program, whether in whole or in part, and whether
#  modified or not, must display this and all other embedded copyright
#  and ownership notices in full.
#--------------------------------------------------------------------------
# Conditions of use:
#
#  This software is provided as an example. It is distributed in the hope
#  that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#--------------------------------------------------------------------------

#--------------------------------------------------------------------------
# This script progressively turns on Profiles in sequence, thereby altering
# Traffic Loading while the Real-Time traffic generator is running.
# Both Continuous and Bursty traffic types may be used, and the steps are
# linear per user entry in milliSeconds.
# All Profiles are cleared before the Stepping starts, so the user is
# CAUTIONED before proceeding to check the Session, Blade and Port.
#--------------------------------------------------------------------------

# Ensure we are running under wish
set isTk [info exists ::tk_version]

#----------------------------------------------------------------
# Load external files
#----------------------------------------------------------------

if { [llength [namespace children :: AgtQcl]] == 0 } {
    namespace eval :: {
        lappend auto_path "c:/program files/agilent/n2x/quicktest/lib"
        puts "Loaded AgtQcl [package require AgtQcl]"
    }

    AgtQclLoadClass -group ALL
}

#----------------------------------------------------------------
# Test Parameter Definition (TPD) XML
#----------------------------------------------------------------

set xmlString \
   {<?xml version="1.0" standalone="yes"?>
    <!-- ============================================================ -->
    <!-- Agilent Configuration Parameter Definition File              -->
    <!-- ============================================================ -->
    <!--  Application:    ProfileStepper                              -->
    <!--  Version:        1.0                                         -->
    <!--  Last modified:  12 Jun 2009                                 -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!--  Copyright 2009 Agilent Technologies                         -->
    <!--  All rights reserved                                         -->
    <!-- ============================================================ -->

    <ConfigurationParameterSet application="SmallApp_Template" version="1.01">

      <NotebookTab id="Setup">
        <ParameterSet id="testports" name="Test ports" titleframe="1" help="Selected test ports">
          <Parameter id="srcportlist"  type="n2xport" subtype="list" name="Source port" variable="::gData(srcPortName)" width="10"/>
        </ParameterSet>
      </NotebookTab>

    </ConfigurationParameterSet>
}

#----------------------------------------------------------------
# Master Data array
#----------------------------------------------------------------
array set gData [list                               \
                                                    \
    agtServerName           localhost               \
    agtSessionType          RouterTester900         \
    agtSessionVersion       latest                  \
    agtSessionLabel         ""                      \
    agtSessionHandle        0                       \
    agtConnectionHandle     0                       \
                                                    \
    scriptName              [file rootname [file tail [info script]]] \
    scriptTitle             "Small Application Template" \
    scriptVersion           1.01                    \
                                                    \
    srcPortName             "101/1"                 \
]

#----------------------------------------------------------------
# Utility procedures
#----------------------------------------------------------------

#----------------------------------------------------------------
# StartTest { }
#----------------------------------------------------------------
# Parameters:
#   none
#
# Returns:
#   nothing
#
# Purpose:
#   Handle the framework StartTest callback.
#----------------------------------------------------------------
proc StartTest { } {
    global gData

    #
    # Check for connection
    #
    if { ![AgtTsuSessionConnected] } {
       AgtTsuShowMessage FATAL "Unable to connect to the N2X test session, exiting."
    }

    $gData(myApp) runState RUNNING

    #----------------------------------------------------------------
    # This is where the core script functionality goes
    #----------------------------------------------------------------

    while { [string equal [$gData(myApp) runState] RUNNING] } {
        AgtTsuTraceMessage "INFO - Press Run->Stop to end this example"
        AgtTsuDelay 1000
    }

    AgtTsuTraceMessage ""
    AgtTsuTraceMessage "Done"
    AgtTsuTraceMessage ""

    StopTest
}

#----------------------------------------------------------------
# StopTest { }
#----------------------------------------------------------------
# Parameters:
#   none
#
# Returns:
#   nothing
#
# Purpose:
#   Handle the framework StopTest callback.
#----------------------------------------------------------------
proc StopTest { } {
    global gData

    #----------------------------------------------------------------
    # Terminate any looping behaviour and tidy up if needed
    #----------------------------------------------------------------

    $gData(myApp) runState STOPPED
}

#----------------------------------------------------------------
# M A I N
#----------------------------------------------------------------

if { !$isTk } {
    puts "\n\n[CMiniTestApplication getDefaultUsageMessage $gData(scriptName)]"
    exit
} else {
    #
    # Create the application
    #
    set gData(myApp) [CMiniTestApplication %AUTO% -title        $gData(scriptTitle)   \
                                                  -version      $gData(scriptVersion) \
                                                  -cbstarttest  ::StartTest           \
                                                  -cbstoptest   ::StopTest            \
                                                  -tpdxml       $xmlString]

    # All done, GUI should be up and running for the user.
}