/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.management.OperatingSystemMXBean;
import java.awt.BorderLayout;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.DateFormat;
import java.util.concurrent.ExecutionException;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.HTMLPane;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SummaryTab
extends Tab {
    private static final String cpuUsageKey = "cpu";
    private static final String cpuUsageName = Resources.getText("CPU Usage", new Object[0]);
    private static final String cpuUsageFormat = "CPUUsageFormat";
    private static final String newDivider = "<tr><td colspan=4><font size =-1><hr>";
    private static final String newTable = "<tr><td colspan=4 align=left><table cellpadding=1>";
    private static final String newLeftTable = "<tr><td colspan=2 align=left><table cellpadding=1>";
    private static final String newRightTable = "<td colspan=2 align=left><table cellpadding=1>";
    private static final String endTable = "</table>";
    private static final int CPU_DECIMALS = 1;
    private CPUOverviewPanel overviewPanel;
    private DateFormat headerDateTimeFormat;
    private String pathSeparator = null;
    HTMLPane info;
    StringBuilder buf;

    public static String getTabName() {
        return Resources.getText("SummaryTab.tabName", new Object[0]);
    }

    public SummaryTab(VMPanel vMPanel) {
        super(vMPanel, SummaryTab.getTabName());
        this.setLayout(new BorderLayout());
        this.info = new HTMLPane();
        Utilities.setAccessibleName(this.info, SummaryTab.getTabName());
        this.add(new JScrollPane(this.info));
        this.headerDateTimeFormat = Formatter.getDateTimeFormat("SummaryTab.headerDateTimeFormat");
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return new SwingWorker<Result, Object>(){

            @Override
            public Result doInBackground() {
                return SummaryTab.this.formatSummary();
            }

            @Override
            protected void done() {
                block5: {
                    try {
                        Result result = (Result)this.get();
                        if (result != null) {
                            SummaryTab.this.info.setText(result.summary);
                            if (SummaryTab.this.overviewPanel != null && result.upTime > 0L && result.processCpuTime >= 0L) {
                                SummaryTab.this.overviewPanel.updateCPUInfo(result);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        if (!JConsole.isDebug()) break block5;
                        executionException.printStackTrace();
                    }
                }
            }
        };
    }

    synchronized Result formatSummary() {
        Result result = new Result();
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (proxyClient.isDead()) {
            return null;
        }
        this.buf = new StringBuilder();
        this.append("<table cellpadding=1>");
        try {
            RuntimeMXBean runtimeMXBean = proxyClient.getRuntimeMXBean();
            CompilationMXBean compilationMXBean = proxyClient.getCompilationMXBean();
            ThreadMXBean threadMXBean = proxyClient.getThreadMXBean();
            MemoryMXBean memoryMXBean = proxyClient.getMemoryMXBean();
            ClassLoadingMXBean classLoadingMXBean = proxyClient.getClassLoadingMXBean();
            java.lang.management.OperatingSystemMXBean operatingSystemMXBean = proxyClient.getOperatingSystemMXBean();
            OperatingSystemMXBean operatingSystemMXBean2 = proxyClient.getSunOperatingSystemMXBean();
            this.append("<tr><td colspan=4>");
            this.append("<center><b>" + Resources.getText("SummaryTab.tabName", new Object[0]) + "</b></center>");
            String string = this.headerDateTimeFormat.format(System.currentTimeMillis());
            this.append("<center>" + string + "</center>");
            this.append(newDivider);
            this.append(newLeftTable);
            this.append("Connection name", this.vmPanel.getDisplayName());
            this.append("Virtual Machine", Resources.getText("SummaryTab.vmVersion", runtimeMXBean.getVmName(), runtimeMXBean.getVmVersion()));
            this.append("Vendor", runtimeMXBean.getVmVendor());
            this.append("Name", runtimeMXBean.getName());
            this.append(endTable);
            this.append(newRightTable);
            result.upTime = runtimeMXBean.getUptime();
            this.append("Uptime", Formatter.formatTime(result.upTime));
            if (operatingSystemMXBean2 != null) {
                result.processCpuTime = operatingSystemMXBean2.getProcessCpuTime();
                this.append("Process CPU time", Formatter.formatNanoTime(result.processCpuTime));
            }
            if (compilationMXBean != null) {
                this.append("JIT compiler", compilationMXBean.getName());
                this.append("Total compile time", compilationMXBean.isCompilationTimeMonitoringSupported() ? Formatter.formatTime(compilationMXBean.getTotalCompilationTime()) : Resources.getText("Unavailable", new Object[0]));
            } else {
                this.append("JIT compiler", Resources.getText("Unavailable", new Object[0]));
            }
            this.append(endTable);
            this.append(newDivider);
            this.append(newLeftTable);
            int n = threadMXBean.getThreadCount();
            int n2 = threadMXBean.getDaemonThreadCount();
            int n3 = threadMXBean.getPeakThreadCount();
            long l = threadMXBean.getTotalStartedThreadCount();
            String[] object6 = Formatter.formatLongs(n, n3, n2, l);
            this.append("Live Threads", object6[0]);
            this.append("Peak", object6[1]);
            this.append("Daemon threads", object6[2]);
            this.append("Total threads started", object6[3]);
            this.append(endTable);
            this.append(newRightTable);
            long l2 = classLoadingMXBean.getLoadedClassCount();
            long l3 = classLoadingMXBean.getUnloadedClassCount();
            long l4 = classLoadingMXBean.getTotalLoadedClassCount();
            String[] stringArray = Formatter.formatLongs(l2, l3, l4);
            this.append("Current classes loaded", stringArray[0]);
            this.append("Total classes loaded", stringArray[2]);
            this.append("Total classes unloaded", stringArray[1]);
            this.append(null, "");
            this.append(endTable);
            this.append(newDivider);
            Object object2 = memoryMXBean.getHeapMemoryUsage();
            this.append(newLeftTable);
            Object object3 = Formatter.formatKByteStrings(((MemoryUsage)object2).getUsed(), ((MemoryUsage)object2).getMax());
            this.append("Current heap size", object3[0]);
            this.append("Maximum heap size", object3[1]);
            this.append(endTable);
            this.append(newRightTable);
            Object object4 = Formatter.formatKByteStrings(((MemoryUsage)object2).getCommitted());
            this.append("Committed memory", object4[0]);
            this.append("SummaryTab.pendingFinalization.label", Resources.getText("SummaryTab.pendingFinalization.value", memoryMXBean.getObjectPendingFinalizationCount()));
            this.append(endTable);
            this.append(newTable);
            Object object5 = proxyClient.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean garbageCollectorMXBean : object5) {
                String string2 = garbageCollectorMXBean.getName();
                long l5 = garbageCollectorMXBean.getCollectionCount();
                long l6 = garbageCollectorMXBean.getCollectionTime();
                this.append("Garbage collector", Resources.getText("GcInfo", string2, l5, l6 >= 0L ? Formatter.formatTime(l6) : Resources.getText("Unavailable", new Object[0])), 4);
            }
            this.append(endTable);
            this.append(newDivider);
            this.append(newLeftTable);
            object2 = operatingSystemMXBean.getName();
            object3 = operatingSystemMXBean.getVersion();
            object4 = operatingSystemMXBean.getArch();
            result.nCPUs = operatingSystemMXBean.getAvailableProcessors();
            this.append("Operating System", (String)object2 + " " + (String)object3);
            this.append("Architecture", (String)object4);
            this.append("Number of processors", result.nCPUs + "");
            if (this.pathSeparator == null) {
                String string3 = this.pathSeparator = ((String)object2).startsWith("Windows ") ? ";" : ":";
            }
            if (operatingSystemMXBean2 != null) {
                object5 = Formatter.formatKByteStrings(operatingSystemMXBean2.getCommittedVirtualMemorySize());
                String[] stringArray2 = Formatter.formatKByteStrings(operatingSystemMXBean2.getTotalPhysicalMemorySize(), operatingSystemMXBean2.getFreePhysicalMemorySize(), operatingSystemMXBean2.getTotalSwapSpaceSize(), operatingSystemMXBean2.getFreeSwapSpaceSize());
                this.append("Committed virtual memory", object5[0]);
                this.append(endTable);
                this.append(newRightTable);
                this.append("Total physical memory", stringArray2[0]);
                this.append("Free physical memory", stringArray2[1]);
                this.append("Total swap space", stringArray2[2]);
                this.append("Free swap space", stringArray2[3]);
            }
            this.append(endTable);
            this.append(newDivider);
            this.append(newTable);
            object2 = "";
            object3 = runtimeMXBean.getInputArguments();
            object4 = object3.iterator();
            while (object4.hasNext()) {
                object5 = (String)object4.next();
                object2 = (String)object2 + (String)object5 + " ";
            }
            this.append("VM arguments", (String)object2, 4);
            this.append("Class path", runtimeMXBean.getClassPath(), 4);
            this.append("Library path", runtimeMXBean.getLibraryPath(), 4);
            this.append("Boot class path", runtimeMXBean.isBootClassPathSupported() ? runtimeMXBean.getBootClassPath() : Resources.getText("Unavailable", new Object[0]), 4);
            this.append(endTable);
        }
        catch (IOException iOException) {
            if (JConsole.isDebug()) {
                iOException.printStackTrace();
            }
            proxyClient.markAsDead();
            return null;
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (JConsole.isDebug()) {
                undeclaredThrowableException.printStackTrace();
            }
            proxyClient.markAsDead();
            return null;
        }
        this.append(endTable);
        result.timeStamp = System.currentTimeMillis();
        result.summary = this.buf.toString();
        return result;
    }

    private synchronized void append(String string) {
        this.buf.append(string);
    }

    void append(String string, String string2) {
        this.append(Formatter.newRow(string != null ? Resources.getText(string, new Object[0]) : string, string2));
    }

    private void append(String string, String string2, int n) {
        if (n == 4 && this.pathSeparator != null) {
            string2 = string2.replace(this.pathSeparator, "<b></b>" + this.pathSeparator);
        }
        this.append(Formatter.newRow(Resources.getText(string, new Object[0]), string2, n));
    }

    void append(String string, String string2, String string3, String string4) {
        this.append(Formatter.newRow(Resources.getText(string, new Object[0]), string2, Resources.getText(string3, new Object[0]), string4));
    }

    @Override
    OverviewPanel[] getOverviewPanels() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new CPUOverviewPanel();
        }
        return new OverviewPanel[]{this.overviewPanel};
    }

    private static class CPUOverviewPanel
    extends OverviewPanel {
        private long prevUpTime;
        private long prevProcessCpuTime;

        CPUOverviewPanel() {
            super(Resources.getText("CPU Usage", new Object[0]), SummaryTab.cpuUsageKey, cpuUsageName, Plotter.Unit.PERCENT);
            this.getPlotter().setDecimals(1);
        }

        public void updateCPUInfo(Result result) {
            if (this.prevUpTime > 0L && result.upTime > this.prevUpTime) {
                long l = result.processCpuTime - this.prevProcessCpuTime;
                long l2 = result.upTime - this.prevUpTime;
                float f = Math.min(99.0f, (float)l / ((float)l2 * 10000.0f * (float)result.nCPUs));
                this.getPlotter().addValues(result.timeStamp, Math.round((double)f * Math.pow(10.0, 1.0)));
                this.getInfoLabel().setText(Resources.getText(SummaryTab.cpuUsageFormat, String.format("%.1f", Float.valueOf(f))));
            }
            this.prevUpTime = result.upTime;
            this.prevProcessCpuTime = result.processCpuTime;
        }
    }

    private static class Result {
        long upTime = -1L;
        long processCpuTime = -1L;
        long timeStamp;
        int nCPUs;
        String summary;

        private Result() {
        }
    }
}

