/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.ThreadDialog;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XMBeanAttributes;
import sun.tools.jconsole.inspector.XMBeanInfo;
import sun.tools.jconsole.inspector.XMBeanNotifications;
import sun.tools.jconsole.inspector.XMBeanOperations;
import sun.tools.jconsole.inspector.XNodeInfo;
import sun.tools.jconsole.inspector.XTree;

public class XSheet
extends JPanel
implements ActionListener,
NotificationListener {
    private JPanel mainPanel;
    private JPanel southPanel;
    private static final JPanel emptyPanel = new JPanel();
    private DefaultMutableTreeNode node;
    private XMBean mbean;
    private XMBeanAttributes mbeanAttributes;
    private XMBeanOperations mbeanOperations;
    private XMBeanNotifications mbeanNotifications;
    private XMBeanInfo mbeanInfo;
    private JButton refreshButton;
    private JButton clearButton;
    private JButton subscribeButton;
    private JButton unsubscribeButton;
    private MBeansTab mbeansTab;

    public XSheet(MBeansTab mBeansTab) {
        this.mbeansTab = mBeansTab;
        this.setupScreen();
    }

    public void dispose() {
        this.clear();
        XDataViewer.dispose(this.mbeansTab);
        this.mbeanNotifications.dispose();
    }

    private void setupScreen() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.southPanel = new JPanel();
        this.add((Component)this.southPanel, "South");
        String string = "MBeansTab.refreshAttributesButton";
        this.refreshButton = new JButton(Resources.getText(string, new Object[0]));
        this.refreshButton.setMnemonic(Resources.getMnemonicInt(string));
        this.refreshButton.setToolTipText(Resources.getText(string + ".toolTip", new Object[0]));
        this.refreshButton.addActionListener(this);
        String string2 = "MBeansTab.clearNotificationsButton";
        this.clearButton = new JButton(Resources.getText(string2, new Object[0]));
        this.clearButton.setMnemonic(Resources.getMnemonicInt(string2));
        this.clearButton.setToolTipText(Resources.getText(string2 + ".toolTip", new Object[0]));
        this.clearButton.addActionListener(this);
        String string3 = "MBeansTab.subscribeNotificationsButton";
        this.subscribeButton = new JButton(Resources.getText(string3, new Object[0]));
        this.subscribeButton.setMnemonic(Resources.getMnemonicInt(string3));
        this.subscribeButton.setToolTipText(Resources.getText(string3 + ".toolTip", new Object[0]));
        this.subscribeButton.addActionListener(this);
        String string4 = "MBeansTab.unsubscribeNotificationsButton";
        this.unsubscribeButton = new JButton(Resources.getText(string4, new Object[0]));
        this.unsubscribeButton.setMnemonic(Resources.getMnemonicInt(string4));
        this.unsubscribeButton.setToolTipText(Resources.getText(string4 + ".toolTip", new Object[0]));
        this.unsubscribeButton.addActionListener(this);
        this.mbeanAttributes = new XMBeanAttributes(this.mbeansTab);
        this.mbeanOperations = new XMBeanOperations(this.mbeansTab);
        this.mbeanOperations.addOperationsListener(this);
        this.mbeanNotifications = new XMBeanNotifications();
        this.mbeanNotifications.addNotificationsListener(this);
        this.mbeanInfo = new XMBeanInfo();
    }

    public boolean isMBeanNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
        return xNodeInfo.getType().equals((Object)XNodeInfo.Type.MBEAN);
    }

    public void displayNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.clear();
        if (defaultMutableTreeNode == null) {
            this.displayEmptyNode();
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof XNodeInfo) {
            XNodeInfo xNodeInfo = (XNodeInfo)object;
            switch (xNodeInfo.getType()) {
                case MBEAN: {
                    this.displayMBeanNode(defaultMutableTreeNode);
                    break;
                }
                case NONMBEAN: {
                    this.displayEmptyNode();
                    break;
                }
                case ATTRIBUTES: {
                    this.displayMBeanAttributesNode(defaultMutableTreeNode);
                    break;
                }
                case OPERATIONS: {
                    this.displayMBeanOperationsNode(defaultMutableTreeNode);
                    break;
                }
                case NOTIFICATIONS: {
                    this.displayMBeanNotificationsNode(defaultMutableTreeNode);
                    break;
                }
                case ATTRIBUTE: 
                case OPERATION: 
                case NOTIFICATION: {
                    this.displayMetadataNode(defaultMutableTreeNode);
                    break;
                }
                default: {
                    this.displayEmptyNode();
                    break;
                }
            }
        } else {
            this.displayEmptyNode();
        }
    }

    private void displayMBeanNode(final DefaultMutableTreeNode defaultMutableTreeNode) {
        final XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
        if (!xNodeInfo.getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            return;
        }
        this.mbeansTab.workerAdd(new Runnable(){

            public void run() {
                try {
                    XSheet.this.node = defaultMutableTreeNode;
                    XSheet.this.mbean = (XMBean)xNodeInfo.getData();
                    XSheet.this.mbeanInfo.addMBeanInfo(XSheet.this.mbean, XSheet.this.mbean.getMBeanInfo());
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new ThreadDialog(XSheet.this, throwable.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        XSheet.this.mainPanel.add((Component)XSheet.this.mbeanInfo, "Center");
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.southPanel.add((Component)emptyPanel, "South");
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                });
            }
        });
    }

    private void displayMetadataNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        final XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
        final XMBeanInfo xMBeanInfo = this.mbeanInfo;
        switch (xNodeInfo.getType()) {
            case ATTRIBUTE: {
                this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        Object object = xNodeInfo.getData();
                        XSheet.this.mbean = (XMBean)((Object[])object)[0];
                        final MBeanAttributeInfo mBeanAttributeInfo = (MBeanAttributeInfo)((Object[])object)[1];
                        final XMBeanAttributes xMBeanAttributes = XSheet.this.mbeanAttributes;
                        try {
                            xMBeanAttributes.loadAttributes(XSheet.this.mbean, new MBeanInfo(null, null, new MBeanAttributeInfo[]{mBeanAttributeInfo}, null, null, null));
                        }
                        catch (Exception exception) {
                            EventQueue.invokeLater(new ThreadDialog(XSheet.this, exception.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                            return;
                        }
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                XSheet.this.invalidate();
                                XSheet.this.mainPanel.removeAll();
                                JPanel jPanel = new JPanel(new BorderLayout());
                                JPanel jPanel2 = new JPanel(new BorderLayout());
                                jPanel2.setBorder(BorderFactory.createTitledBorder(Resources.getText("Attribute value", new Object[0])));
                                JPanel jPanel3 = new JPanel(new BorderLayout());
                                jPanel3.setBorder(LineBorder.createGrayLineBorder());
                                jPanel3.add((Component)xMBeanAttributes.getTableHeader(), "First");
                                jPanel3.add((Component)xMBeanAttributes, "Center");
                                jPanel2.add((Component)jPanel3, "Center");
                                JPanel jPanel4 = new JPanel();
                                jPanel4.add(XSheet.this.refreshButton);
                                jPanel2.add((Component)jPanel4, "South");
                                XSheet.this.refreshButton.setEnabled(true);
                                jPanel.add((Component)jPanel2, "North");
                                xMBeanInfo.addMBeanAttributeInfo(mBeanAttributeInfo);
                                jPanel.add((Component)xMBeanInfo, "Center");
                                XSheet.this.mainPanel.add((Component)jPanel, "Center");
                                XSheet.this.southPanel.removeAll();
                                XSheet.this.southPanel.add((Component)emptyPanel, "South");
                                XSheet.this.validate();
                                XSheet.this.repaint();
                            }
                        });
                    }
                });
                break;
            }
            case OPERATION: {
                Object object = xNodeInfo.getData();
                this.mbean = (XMBean)((Object[])object)[0];
                MBeanOperationInfo mBeanOperationInfo = (MBeanOperationInfo)((Object[])object)[1];
                XMBeanOperations xMBeanOperations = this.mbeanOperations;
                try {
                    xMBeanOperations.loadOperations(this.mbean, new MBeanInfo(null, null, null, null, new MBeanOperationInfo[]{mBeanOperationInfo}, null));
                }
                catch (Exception exception) {
                    EventQueue.invokeLater(new ThreadDialog(this, exception.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                    return;
                }
                this.invalidate();
                this.mainPanel.removeAll();
                JPanel jPanel = new JPanel(new BorderLayout());
                JPanel jPanel2 = new JPanel(new BorderLayout());
                jPanel2.setBorder(BorderFactory.createTitledBorder(Resources.getText("Operation invocation", new Object[0])));
                jPanel2.add(new JScrollPane(xMBeanOperations));
                jPanel.add((Component)jPanel2, "North");
                xMBeanInfo.addMBeanOperationInfo(mBeanOperationInfo);
                jPanel.add((Component)xMBeanInfo, "Center");
                this.mainPanel.add((Component)jPanel, "Center");
                this.southPanel.removeAll();
                this.southPanel.add((Component)emptyPanel, "South");
                this.validate();
                this.repaint();
                break;
            }
            case NOTIFICATION: {
                Object object = xNodeInfo.getData();
                this.invalidate();
                this.mainPanel.removeAll();
                xMBeanInfo.addMBeanNotificationInfo((MBeanNotificationInfo)object);
                this.mainPanel.add((Component)xMBeanInfo, "Center");
                this.southPanel.removeAll();
                this.southPanel.add((Component)emptyPanel, "South");
                this.validate();
                this.repaint();
            }
        }
    }

    private void displayMBeanAttributesNode(final DefaultMutableTreeNode defaultMutableTreeNode) {
        final XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
        if (!xNodeInfo.getType().equals((Object)XNodeInfo.Type.ATTRIBUTES)) {
            return;
        }
        final XMBeanAttributes xMBeanAttributes = this.mbeanAttributes;
        this.mbeansTab.workerAdd(new Runnable(){

            public void run() {
                try {
                    XSheet.this.node = defaultMutableTreeNode;
                    XSheet.this.mbean = (XMBean)xNodeInfo.getData();
                    xMBeanAttributes.loadAttributes(XSheet.this.mbean, XSheet.this.mbean.getMBeanInfo());
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new ThreadDialog(XSheet.this, throwable.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        JPanel jPanel = new JPanel(new BorderLayout());
                        jPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Attribute values", new Object[0])));
                        jPanel.add(new JScrollPane(xMBeanAttributes));
                        XSheet.this.mainPanel.add((Component)jPanel, "Center");
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.southPanel.add((Component)XSheet.this.refreshButton, "South");
                        XSheet.this.refreshButton.setEnabled(true);
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                });
            }
        });
    }

    private void displayMBeanOperationsNode(final DefaultMutableTreeNode defaultMutableTreeNode) {
        final XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
        if (!xNodeInfo.getType().equals((Object)XNodeInfo.Type.OPERATIONS)) {
            return;
        }
        final XMBeanOperations xMBeanOperations = this.mbeanOperations;
        this.mbeansTab.workerAdd(new Runnable(){

            public void run() {
                try {
                    XSheet.this.node = defaultMutableTreeNode;
                    XSheet.this.mbean = (XMBean)xNodeInfo.getData();
                    xMBeanOperations.loadOperations(XSheet.this.mbean, XSheet.this.mbean.getMBeanInfo());
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new ThreadDialog(XSheet.this, throwable.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        JPanel jPanel = new JPanel(new BorderLayout());
                        jPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Operation invocation", new Object[0])));
                        jPanel.add(new JScrollPane(xMBeanOperations));
                        XSheet.this.mainPanel.add((Component)jPanel, "Center");
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.southPanel.add((Component)emptyPanel, "South");
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                });
            }
        });
    }

    private void displayMBeanNotificationsNode(final DefaultMutableTreeNode defaultMutableTreeNode) {
        final XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
        if (!xNodeInfo.getType().equals((Object)XNodeInfo.Type.NOTIFICATIONS)) {
            return;
        }
        final XMBeanNotifications xMBeanNotifications = this.mbeanNotifications;
        this.mbeansTab.workerAdd(new Runnable(){

            public void run() {
                try {
                    XSheet.this.node = defaultMutableTreeNode;
                    XSheet.this.mbean = (XMBean)xNodeInfo.getData();
                    xMBeanNotifications.loadNotifications(XSheet.this.mbean);
                    XSheet.this.updateNotifications();
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new ThreadDialog(XSheet.this, throwable.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        JPanel jPanel = new JPanel(new BorderLayout());
                        jPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Notification buffer", new Object[0])));
                        jPanel.add(new JScrollPane(xMBeanNotifications));
                        XSheet.this.mainPanel.add((Component)jPanel, "Center");
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.southPanel.add((Component)XSheet.this.subscribeButton, "West");
                        XSheet.this.southPanel.add((Component)XSheet.this.unsubscribeButton, "Center");
                        XSheet.this.southPanel.add((Component)XSheet.this.clearButton, "East");
                        XSheet.this.subscribeButton.setEnabled(true);
                        XSheet.this.unsubscribeButton.setEnabled(true);
                        XSheet.this.clearButton.setEnabled(true);
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                });
            }
        });
    }

    private void displayEmptyNode() {
        this.invalidate();
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)emptyPanel, "Center");
        this.southPanel.removeAll();
        this.southPanel.add((Component)emptyPanel, "South");
        this.validate();
        this.repaint();
    }

    private void registerListener() throws InstanceNotFoundException, IOException {
        this.mbeanNotifications.registerListener(this.node);
        this.updateNotifications();
        this.validate();
    }

    private void unregisterListener() {
        if (this.mbeanNotifications.unregisterListener(this.node)) {
            this.clearNotifications();
            this.validate();
        }
    }

    private void refreshAttributes() {
        this.mbeanAttributes.refreshAttributes();
    }

    private void updateNotifications() {
        if (this.mbean.isBroadcaster()) {
            if (this.mbeanNotifications.isListenerRegistered(this.mbean)) {
                long l = this.mbeanNotifications.getReceivedNotifications(this.mbean);
                this.updateReceivedNotifications(this.node, l, false);
            } else {
                this.clearNotifications();
            }
        } else {
            this.clearNotifications();
        }
    }

    private void updateReceivedNotifications(DefaultMutableTreeNode defaultMutableTreeNode, long l, boolean bl) {
        String string = Resources.getText("Notifications", new Object[0]) + "[" + l + "]";
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.mbeansTab.getTree().getLastSelectedPathComponent();
        if (bl && defaultMutableTreeNode != defaultMutableTreeNode2) {
            string = "<html><b>" + string + "</b></html>";
        }
        this.updateNotificationsNodeLabel(defaultMutableTreeNode, string);
    }

    private void clearNotifications() {
        this.updateNotificationsNodeLabel(this.node, Resources.getText("Notifications", new Object[0]));
    }

    private void clearNotifications0() {
        this.updateNotificationsNodeLabel(this.node, Resources.getText("Notifications", new Object[0]) + "[0]");
    }

    private void updateNotificationsNodeLabel(final DefaultMutableTreeNode defaultMutableTreeNode, final String string) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                XTree xTree = XSheet.this.mbeansTab.getTree();
                synchronized (xTree) {
                    XSheet.this.invalidate();
                    XNodeInfo xNodeInfo = (XNodeInfo)defaultMutableTreeNode.getUserObject();
                    XNodeInfo xNodeInfo2 = new XNodeInfo(xNodeInfo.getType(), xNodeInfo.getData(), string, xNodeInfo.getToolTipText());
                    defaultMutableTreeNode.setUserObject(xNodeInfo2);
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)XSheet.this.mbeansTab.getTree().getModel();
                    defaultTreeModel.nodeChanged(defaultMutableTreeNode);
                    XSheet.this.validate();
                    XSheet.this.repaint();
                }
            }
        });
    }

    private void clearCurrentNotifications() {
        this.mbeanNotifications.clearCurrentNotifications();
        if (this.mbeanNotifications.isListenerRegistered(this.mbean)) {
            this.clearNotifications0();
        } else {
            this.clearNotifications();
        }
    }

    private void clear() {
        this.mbeanAttributes.stopCellEditing();
        this.mbeanAttributes.emptyTable();
        this.mbeanAttributes.removeAttributes();
        this.mbeanOperations.removeOperations();
        this.mbeanNotifications.stopCellEditing();
        this.mbeanNotifications.emptyTable();
        this.mbeanNotifications.disableNotifications();
        this.mbean = null;
        this.node = null;
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification.getType().equals("jam.xoperations.invoke.result")) {
            Component component;
            if (object == null) {
                JTextArea jTextArea = new JTextArea("null");
                jTextArea.setEditable(false);
                jTextArea.setEnabled(true);
                jTextArea.setRows(jTextArea.getLineCount());
                component = jTextArea;
            } else {
                Component component2 = this.mbeansTab.getDataViewer().createOperationViewer(object, this.mbean);
                if (component2 == null) {
                    JTextArea jTextArea = new JTextArea(object.toString());
                    jTextArea.setEditable(false);
                    jTextArea.setEnabled(true);
                    jTextArea.setRows(jTextArea.getLineCount());
                    JScrollPane jScrollPane = new JScrollPane(jTextArea);
                    Dimension dimension = jScrollPane.getPreferredSize();
                    if (dimension.getWidth() > 400.0 || dimension.getHeight() > 250.0) {
                        jScrollPane.setPreferredSize(new Dimension(400, 250));
                    }
                    component = jScrollPane;
                } else {
                    Dimension dimension;
                    if (!(component2 instanceof JScrollPane)) {
                        component2 = new JScrollPane(component2);
                    }
                    if ((dimension = component2.getPreferredSize()).getWidth() > 400.0 || dimension.getHeight() > 250.0) {
                        component2.setPreferredSize(new Dimension(400, 250));
                    }
                    component = component2;
                }
            }
            EventQueue.invokeLater(new ThreadDialog((Component)notification.getSource(), component, Resources.getText("Operation return value", new Object[0]), 1));
        } else if (notification.getType().equals("jconsole.xnotification.received")) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Long l = (Long)notification.getUserData();
            this.updateReceivedNotifications(defaultMutableTreeNode, l, true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.refreshButton) {
                this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        XSheet.this.refreshAttributes();
                    }
                });
                return;
            }
            if (jButton == this.clearButton) {
                this.clearCurrentNotifications();
                return;
            }
            if (jButton == this.subscribeButton) {
                this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        try {
                            XSheet.this.registerListener();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = Utils.getActualException(throwable);
                            EventQueue.invokeLater(new ThreadDialog(XSheet.this, throwable2.getMessage(), Resources.getText("Problem adding listener", new Object[0]), 0));
                        }
                    }
                });
                return;
            }
            if (jButton == this.unsubscribeButton) {
                this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        try {
                            XSheet.this.unregisterListener();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = Utils.getActualException(throwable);
                            EventQueue.invokeLater(new ThreadDialog(XSheet.this, throwable2.getMessage(), Resources.getText("Problem removing listener", new Object[0]), 0));
                        }
                    }
                });
                return;
            }
        }
    }
}

