$numArgs = $#ARGV + 1;
$param1 = $ARGV[0];
$param2 = $ARGV[1];

$usage = "USAGE: runXrayTester [-start user|developer|operator|service|login]\n";

if (($numArgs != 0) && ($numArgs != 2))
{
  die $usage;
}

if ($numArgs > 0)
{
  if ($param1 !~ /^-start$/i)
  {
    die $usage;
  }

  if ($param2 !~ /^(user|developer|operator|service|login)$/)
  {
    die $usage;
  }
}

# set up the PATH
$programFiles = $ENV{'ProgramFiles'};
$xrayHome = $ENV{'AGILENT_XRAY_HOME'};
$xrayJreHome = $ENV{'AGILENT_XRAY_JRE_HOME'};

$origPath = $ENV{'PATH'};

# put our bin directories in front of the system
# environment variables.  This needs to be done
# because AOI puts some dlls that conflict with
# ours in the system32 directory
$newPath = "";
$newPath .= "$xrayHome/bin;";
$newPath .= "$xrayJreHome/bin;";
$newPath .= "$origPath;";
$newPath .= "$programFiles/internet explorer";
$ENV{'PATH'}=$newPath;

#print "$ENV{'PATH'}\n";

print "#### The following environment variables must be set properly ####\n";
print "     AGILENT_XRAY_HOME=$xrayHome\n";
print "     AGILENT_XRAY_JRE_HOME=$xrayJreHome\n";

$title = "Medalist_x6000";
system("title", "$title");
system("hideWindow", "$title");

$xrayHomeUrl = $xrayHome;
$xrayHomeUrl =~ s/\s/%20/g;


# show that java version being used
$out = `"$xrayJreHome/bin/java" -version 2>&1`;
print "$out\n";

# for 1.5 add -Dsun.java2d.opengl=true once it works with our video drivers!

# explanation of options
# -Xmx768m - Allow Java to use a maximum of 768Megs of memory for its heap space. 
# -XX:MaxDirectMemorySize=1534M - Allow direct byte buffers to use a maximum of 1534Megs of memory.
#                                 We use direct byte buffers for our images.  The memory we allocate
#                                 for these direct byte buffers is memory outside of the java heap,
#                                 so the -Xmx setting is not affected by this setting directly.
#
#                                 NOTE: This number must be greater than the setting "maximumSpaceForImagesInMegabytes" 
#                                       in file software.config.  To avoid out of memory errors caused by memory
#                                       fragmentation, the -XX:MaxDirectMemorySize needs to be at least 2 times larger
#                                       than the "maximumSpaceForImagesInMegabytes" setting in the software.config file.
#
#
# - Keep in mind that Windows XP allows 2Gig memory max per process, so the -Xmx and -XX:MaxDirectMemorySize should not add up 
#      to 2Gig or larger.
# - The combination in this file sets the memory size above 2GB.  This has been tested on the system and has not run into problems with
#      large panels, and the higher Xmx is more stable for large panels.
# - Also note that the java executable will take more memory than the -Xmx setting, since -Xmx controls only the java heap, 
#      it does not control the amount of memory that the JIT compiler and other parts of java use.
#
# -Xss256k - set the size of the stack - this was necessary to increase from the default value of 64k for serializing large projects
# -Xms768M - initialize the application with 768 MB of memory. This should match the -Xmx setting so Java immediately allocated
#            all the memory it will need.  This provides better performance than letting Java keep grabbing more memory as it needs it.

# uncomment this line for remote debugging with JBuilder 2005
# wpd - uncommented this for now so we can track down hangs
#$jbuilderRemoteDebugOptions = "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,address=3999,suspend=n";


# When we start up the prorgram, it will redirect output to the log directory.
# Make sure this directory exists.
mkdir "$xrayHome/log" unless -e -d "$xrayHome/log";

$timeInMillis = time();

# start up the program
# NOTE: I use pid ($$) in the log file name.  Unfortunately this must be done.  If the name is not unique you get into trouble
#       with the following case:
#       - start up appication
#       - from the application pull up help (which starts internet explorere)
#       - now close the application, but keep IE running
#       - try to start the application again - it will NOT restart because IE still has a hold on the xRayTester.log file
#$out = `"$xrayJreHome/bin/javaw" $jbuilderRemoteDebugOptions -Xmx968m -Xms768m -XX:+UseDefaultStackSize -Xss256K -Dsun.java2d.opengl=false -Djava.security.policy="$xrayHome/config/server_security.policy" -Djava.rmi.server.codebase=file:/$xrayHomeUrl/bin/xRayTest.jar -DassertLogDir="$xrayHome/log" -classpath "$xrayHome/bin/patch.jar;$xrayHome/bin/xRayTest.jar;$xrayHome" com.agilent.xRayTest.gui.mainMenu.MainMenuGui $param1 $param2 >> "$xrayHome/log/xRayTester.$timeInMillis.log" 2>&1`;
$out = `"$xrayJreHome/bin/javaw" $jbuilderRemoteDebugOptions -Xmx968m -Xms768m -XX:+UseDefaultStackSize -Xss256K  -Dcom.sun.management.jmxremote -Dsun.java2d.opengl=false -Djava.security.policy="$xrayHome/config/server_security.policy" -Djava.rmi.server.codebase=file:/$xrayHomeUrl/bin/xRayTest.jar -DassertLogDir="$xrayHome/log" -classpath "$xrayHome/bin/patch.jar;$xrayHome/bin/xRayTest.jar;$xrayHome" com.agilent.xRayTest.gui.mainMenu.MainMenuGui $param1 $param2 >> "$xrayHome/log/xRayTester.$timeInMillis.log" 2>&1`;
print "$out\n";

